/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.potion;

import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.MapKeys;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.potion.PotionManager;

public class MarketablePotion
extends MarketableMaterial {
    private final PotionType potionType;

    public MarketablePotion(DEPlugin main, PotionManager itemManager, String ID, ConfigurationSection config, ConfigurationSection defaultConfig) {
        super(main, itemManager, ID, config, defaultConfig);
        PotionType potionType = null;
        try {
            potionType = PotionType.valueOf((String)config.getString(MapKeys.POTION_TYPE.key));
        }
        catch (IllegalArgumentException exception) {
            this.error = exception.getMessage();
        }
        this.potionType = potionType;
    }

    @Override
    public boolean check() {
        return this.material != null && this.potionType != null;
    }

    public PotionType getType() {
        return this.potionType;
    }

    @Override
    public ItemStack getItemStack(int amount) {
        ItemStack itemStack = new ItemStack(this.material, amount);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionType(this.potionType);
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    @Override
    public boolean equals(MarketableMaterial material) {
        if (this == material) {
            return true;
        }
        if (!(material instanceof MarketablePotion)) {
            return false;
        }
        MarketablePotion potion = (MarketablePotion)material;
        return this.material.equals((Object)potion.material) && this.potionType.equals((Object)potion.potionType);
    }

    @Override
    public boolean equals(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return false;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        return itemStack.getType().equals((Object)this.material) && potionMeta.getBasePotionType().equals((Object)((PotionMeta)this.getItemStack(1).getItemMeta()).getBasePotionType());
    }
}

