/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.potion;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.market.items.materials.potion.MarketablePotion;

public class PotionManager
extends MaterialManager {
    public static final String PotionFile = "potions.yml";
    public static final String PotionAliasFile = "potionAliases.yml";

    public PotionManager(DEPlugin main) {
        super(main, PotionFile, PotionAliasFile, new ConcurrentHashMap());
    }

    @Override
    public String getType() {
        return "POTION";
    }

    @Override
    public Set<String> getLocalKeys() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getKey).map(NamespacedKey::getKey).map(Object::toString).map(String::toUpperCase).collect(Collectors.toSet());
    }

    @Override
    public MaterialValueResponse getSellValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketablePotion potionData = (MarketablePotion)this.getItem(itemStack);
        if (potionData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, potionData.getQuantity(), this.sellScale, false);
        response.addToken(potionData, amount, value, new ItemStack[]{itemStack});
        if (!potionData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), potionData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), potionData.getName()));
        }
        return response;
    }

    @Override
    public MaterialValueResponse getBuyValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketablePotion potionData = (MarketablePotion)this.getItem(itemStack);
        if (potionData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, potionData.getQuantity(), this.buyScale, true);
        response.addToken(potionData, amount, value, new ItemStack[]{itemStack});
        if (!potionData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), potionData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), potionData.getName()));
        }
        return response;
    }

    @Override
    public MarketableMaterial loadItem(String ID, ConfigurationSection data, ConfigurationSection defaultData) {
        return new MarketablePotion(this.getMain(), this, ID, data, defaultData);
    }
}

