/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.migrators.migrations;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.potion.PotionType;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.migrators.Migration;

public class Migrate343
extends Migration {
    public Migrate343(DEPlugin main) {
        super(main, "3.4.3", "3.5.0");
    }

    @Override
    protected void migrate() {
        this.migratePotionFile();
    }

    private void migratePotionFile() {
        File potionFile = this.getMain().getConfMan().getFile("potions.yml");
        FileConfiguration potionConfig = this.getMain().getConfMan().readFile(potionFile);
        for (String key : potionConfig.getKeys(false)) {
            String potionType = potionConfig.getString(key + ".POTION_TYPE");
            if (potionConfig.getBoolean(key + ".POTION_EXTENDED")) {
                potionConfig.set(key + ".POTION_TYPE", (Object)("LONG_" + potionType));
            }
            if (potionConfig.getBoolean(key + ".POTION_UPGRADED")) {
                potionConfig.set(key + ".POTION_TYPE", (Object)("STRONG_" + potionType));
            }
            potionConfig.set(key + ".POTION_EXTENDED", null);
            potionConfig.set(key + ".POTION_UPGRADED", null);
            try {
                PotionType.valueOf((String)potionConfig.getString(key + ".POTION_TYPE"));
            }
            catch (IllegalArgumentException exception) {
                potionConfig.set(key, null);
                this.getMain().getConsole().migrate("Removed potion %s due to invalid potion type", key);
            }
        }
        this.getMain().getConfMan().saveFile(potionConfig, "potions.yml");
    }
}

