/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.economy.NameStore;
import org.divinitycraft.divinityeconomy.player.PlayerLRUCache;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class PlayerManager
extends DivinityModule {
    private static final int MAX_SEARCH_DEPTH_INT = 64;
    private static final long MAX_SEARCH_NANO_LONG = 50000000L;
    private static final int PLAYER_TASK_INTERVAL = Converter.getTicks(60);
    private final Set<OfflinePlayer> players;
    private final Map<UUID, OfflinePlayer> playerUUIDs;
    private final PlayerLRUCache playerCache;
    private final Map<OfflinePlayer, NameStore> playerNames;
    private final BukkitRunnable playerTask = new BukkitRunnable(){

        public void run() {
            PlayerManager.this.fetchOfflinePlayers();
        }
    };

    public PlayerManager(DEPlugin main) {
        super(main);
        this.players = Collections.synchronizedSet(new HashSet());
        this.playerNames = new ConcurrentHashMap<OfflinePlayer, NameStore>();
        this.playerUUIDs = new ConcurrentHashMap<UUID, OfflinePlayer>();
        this.playerCache = new PlayerLRUCache(this.getMain());
    }

    @Override
    public void init() {
        this.playerTask.runTaskTimerAsynchronously((Plugin)this.getMain(), (long)PLAYER_TASK_INTERVAL, (long)PLAYER_TASK_INTERVAL);
        this.fetchOfflinePlayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchOfflinePlayers() {
        this.getConsole().debug("Fetching players...", new Object[0]);
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>(Arrays.asList(this.getMain().getServer().getOfflinePlayers()));
        if (players.size() != this.players.size()) {
            this.playerCache.clear();
            this.getConsole().debug("Players changed, invalidated player cache.", new Object[0]);
        }
        Map<UUID, OfflinePlayer> map = this.players;
        synchronized (map) {
            this.players.clear();
            this.players.addAll(players);
        }
        map = this.playerNames;
        synchronized (map) {
            this.playerNames.clear();
            for (OfflinePlayer player : players) {
                this.playerNames.put(player, new NameStore(player));
            }
        }
        map = this.playerUUIDs;
        synchronized (map) {
            this.playerUUIDs.clear();
            for (OfflinePlayer player : players) {
                this.playerUUIDs.put(player.getUniqueId(), player);
            }
        }
        this.getConsole().debug("Fetched %s players", this.players.size());
    }

    @Override
    public void deinit() {
        this.playerTask.cancel();
    }

    public Set<OfflinePlayer> getPlayers() {
        return new HashSet<OfflinePlayer>(this.players);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NameStore getPlayerName(OfflinePlayer player) {
        Map<OfflinePlayer, NameStore> map = this.playerNames;
        synchronized (map) {
            NameStore nameStore = this.playerNames.get(player);
            if (nameStore == null) {
                nameStore = new NameStore(player);
                this.playerNames.put(player, nameStore);
            }
            return nameStore;
        }
    }

    @Nullable
    public OfflinePlayer getPlayer(String name, boolean exact) {
        if (exact) {
            return this.getMain().getServer().getOfflinePlayer(name);
        }
        Set<OfflinePlayer> players = this.getPlayers(name);
        Iterator<OfflinePlayer> iterator = players.iterator();
        if (iterator.hasNext()) {
            OfflinePlayer player = iterator.next();
            return player;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfflinePlayer getPlayer(UUID uuid) {
        OfflinePlayer player = this.playerUUIDs.getOrDefault(uuid, null);
        if (player == null) {
            player = this.getMain().getServer().getOfflinePlayer(uuid);
        }
        Map<UUID, OfflinePlayer> map = this.playerUUIDs;
        synchronized (map) {
            this.playerUUIDs.put(uuid, player);
        }
        return player;
    }

    public Set<OfflinePlayer> getPlayers(String term) {
        Set<OfflinePlayer> players = (Set<OfflinePlayer>)this.playerCache.get(term);
        if (players == null) {
            players = this.searchPlayers(term);
            this.playerCache.put(term, players);
        }
        return players;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OfflinePlayer> searchPlayers(String term) {
        term = term.toLowerCase().strip();
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        HashSet<OfflinePlayer> priority0ArrayList = new HashSet<OfflinePlayer>();
        HashSet<OfflinePlayer> priority1ArrayList = new HashSet<OfflinePlayer>();
        HashSet<OfflinePlayer> priority2ArrayList = new HashSet<OfflinePlayer>();
        HashSet<OfflinePlayer> priority3ArrayList = new HashSet<OfflinePlayer>();
        long startTime = System.nanoTime();
        Set<OfflinePlayer> set = this.players;
        synchronized (set) {
            for (OfflinePlayer offlinePlayer : this.players) {
                int depth = priority0ArrayList.size() + priority1ArrayList.size() + priority2ArrayList.size() + priority3ArrayList.size();
                if (depth > 64) {
                    this.getConsole().debug("Max search depth reached, stopping search.", new Object[0]);
                    break;
                }
                if (System.nanoTime() - startTime > 50000000L) {
                    this.getConsole().debug("Max search time reached, stopping search.", new Object[0]);
                    break;
                }
                NameStore nameStore = this.getPlayerName(offlinePlayer);
                if (nameStore == null) continue;
                String playerName = nameStore.getName().toLowerCase().strip();
                String playerDisplayName = nameStore.name().toLowerCase().strip();
                if (playerName.equalsIgnoreCase(term) || playerDisplayName.equalsIgnoreCase(term)) {
                    priority0ArrayList.add(offlinePlayer);
                    continue;
                }
                if (playerName.startsWith(term) || playerDisplayName.startsWith(term)) {
                    priority1ArrayList.add(offlinePlayer);
                    continue;
                }
                if (playerName.contains(term) || playerDisplayName.contains(term)) {
                    priority2ArrayList.add(offlinePlayer);
                    continue;
                }
                if (!playerName.endsWith(term) && !playerDisplayName.endsWith(term)) continue;
                priority3ArrayList.add(offlinePlayer);
            }
        }
        players.addAll(priority0ArrayList);
        players.addAll(priority1ArrayList);
        players.addAll(priority2ArrayList);
        players.addAll(priority3ArrayList);
        this.getConsole().debug("Found %s players matching '%s' in %s milliseconds.", players.size(), term, (System.nanoTime() - startTime) / 1000000L);
        return players;
    }

    public String[] getPlayerNames(String term) {
        Set<OfflinePlayer> players = this.getPlayers(term);
        HashSet<String> playerNames = new HashSet<String>();
        for (OfflinePlayer player : players) {
            playerNames.add(player.getName());
        }
        return playerNames.toArray(new String[0]);
    }

    public static void addPlayerItems(Player player, ItemStack[] itemStacks) {
        PlayerInventory inventory = player.getInventory();
        for (ItemStack itemStack : itemStacks) {
            inventory.addItem(new ItemStack[]{itemStack});
        }
    }

    public static void addPlayerItems(Player player, ItemStack itemStack) {
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public static int getEmptySlots(Player player) {
        ItemStack[] inventory;
        int count = 0;
        for (ItemStack iStack : inventory = player.getInventory().getStorageContents()) {
            if (iStack != null) continue;
            ++count;
        }
        return count;
    }

    public static void replaceItemStack(Player player, ItemStack itemStack1, ItemStack itemStack2) {
        PlayerManager.removePlayerItems(itemStack1);
        PlayerManager.addPlayerItems(player, itemStack2);
    }

    public static void replaceItemStacks(Player player, ItemStack[] itemStacks1, ItemStack[] itemStacks2) {
        PlayerManager.removePlayerItems(itemStacks1);
        PlayerManager.addPlayerItems(player, itemStacks2);
    }

    public static void removePlayerItems(ItemStack[] itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            PlayerManager.removePlayerItems(itemStack);
        }
    }

    public static void removePlayerItems(ItemStack itemStack) {
        itemStack.setAmount(0);
    }

    public static ItemStack getHeldItem(Player player) {
        int slotIdx = player.getInventory().getHeldItemSlot();
        return player.getInventory().getItem(slotIdx);
    }

    public static ItemStack getHeldItem(Player player, ItemStack fallback) {
        ItemStack heldItem = PlayerManager.getHeldItem(player);
        if (heldItem == null) {
            heldItem = fallback;
        }
        return heldItem;
    }

    public static Set<String> getInventoryMaterialNames(Player player) {
        ItemStack[] materials = PlayerManager.getInventoryMaterials(player);
        HashSet<String> uniqueMaterialIDs = new HashSet<String>();
        for (ItemStack material : materials) {
            uniqueMaterialIDs.add(material.getType().name());
        }
        return uniqueMaterialIDs;
    }

    public static ItemStack[] getInventoryMaterials(Player player) {
        ItemStack[] materials = player.getInventory().getStorageContents();
        ArrayList<ItemStack> materialList = new ArrayList<ItemStack>();
        for (ItemStack iStack : materials) {
            if (iStack == null) continue;
            materialList.add(iStack);
        }
        return materialList.toArray(new ItemStack[0]);
    }
}

