/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.response;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.EconomyResponse;

public class Response {
    private EconomyResponse.ResponseType responseType;
    private String errorMessage;

    public Response(EconomyResponse.ResponseType responseType, String errorMessage) {
        this.responseType = responseType;
        this.errorMessage = errorMessage;
    }

    public Response() {
        this(EconomyResponse.ResponseType.NOT_IMPLEMENTED, null);
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nonnull
    public EconomyResponse.ResponseType getResponseType() {
        return this.responseType;
    }

    public Response setResponseType(@Nonnull EconomyResponse.ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public Response setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Response setResponse(@Nonnull EconomyResponse.ResponseType responseType, @Nullable String errorMessage) {
        this.responseType = responseType;
        this.errorMessage = errorMessage;
        return this;
    }

    public Response setFailure(@Nullable String errorMessage) {
        return this.setResponse(EconomyResponse.ResponseType.FAILURE, errorMessage);
    }

    public Response setSuccess(@Nullable String errorMessage) {
        return this.setResponse(EconomyResponse.ResponseType.SUCCESS, errorMessage);
    }

    public boolean isSuccess() {
        return this.responseType == EconomyResponse.ResponseType.SUCCESS;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String toString() {
        return String.format("Response: { type: %s, message: %s }", this.responseType.toString(), this.errorMessage != null ? this.errorMessage : "null");
    }
}

