/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.utils;

import com.google.errorprone.annotations.ForOverride;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.utils.Converter;

public abstract class LRUCache<K, V>
extends ConcurrentHashMap<K, V> {
    protected final DEPlugin main;
    protected final int memorySize;
    protected final LinkedBlockingDeque<K> orderList;
    private static final double DEBLOAT_FACTOR = 0.75;

    public LRUCache(DEPlugin main) {
        this.main = main;
        int memorySize = this.loadMemorySize();
        this.memorySize = memorySize <= 0 ? 0 : Converter.constrainInt(memorySize, 64, Integer.MAX_VALUE);
        this.orderList = new LinkedBlockingDeque(this.loadMemorySize());
    }

    protected DEPlugin getMain() {
        return this.main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFront(K key) {
        LinkedBlockingDeque<K> linkedBlockingDeque = this.orderList;
        synchronized (linkedBlockingDeque) {
            if (this.orderList.size() >= this.memorySize) {
                this.trim();
            }
            this.orderList.addFirst(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trim() {
        LinkedBlockingDeque<K> linkedBlockingDeque = this.orderList;
        synchronized (linkedBlockingDeque) {
            int debloatAmount = this.getDebloatSize();
            this.getMain().getConsole().debug("Debloating %s objects", debloatAmount);
            while (debloatAmount > 0) {
                K obj = this.orderList.removeLast();
                if (this.orderList.contains(obj)) continue;
                super.remove(obj);
                --debloatAmount;
            }
        }
    }

    @ForOverride
    protected int loadMemorySize() {
        return 0;
    }

    protected int getDebloatSize() {
        if (this.memorySize <= 0) {
            return 0;
        }
        return (int)Math.ceil((double)this.memorySize * 0.75);
    }

    protected boolean query(K key) {
        return this.containsKey(key);
    }

    @ForOverride
    protected V load(K key) {
        return null;
    }

    @Override
    @Nullable
    @ForOverride
    public V get(Object k) {
        Object key = k;
        Object result = super.get(key);
        if (result == null) {
            result = this.load(key);
            if (result != null) {
                this.put(key, result);
                this.getMain().getConsole().debug("Loaded %s from storage", key);
            }
        } else {
            this.getMain().getConsole().debug("Loaded %s from memory", key);
        }
        return result;
    }

    @Override
    @ForOverride
    public V put(@Nonnull Object k, @Nonnull Object v) {
        Object key = k;
        Object value = v;
        if (this.memorySize == 0) {
            return this.load(key);
        }
        Object object = super.put(key, value);
        this.setFront(key);
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedBlockingDeque<K> linkedBlockingDeque = this.orderList;
        synchronized (linkedBlockingDeque) {
            super.clear();
            this.orderList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@Nonnull Object k) {
        Object key = k;
        LinkedBlockingDeque<K> linkedBlockingDeque = this.orderList;
        synchronized (linkedBlockingDeque) {
            this.orderList.remove(key);
            return super.remove(key);
        }
    }
}

