/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.world.events.WorldNotification;

public class WorldManager
extends DivinityModule {
    private List<String> configMarketEnabledWorlds;
    private HashMap<String, Boolean> marketEnabledWorlds;
    private boolean marketEnableAllWorlds;
    private boolean marketApplyToItems;
    private boolean marketApplyToEnchants;
    private boolean marketApplyToExperience;
    private List<String> configEconomyEnabledWorlds;
    private HashMap<String, Boolean> economyEnabledWorlds;
    private boolean economyEnableAllWorlds;

    public WorldManager(DEPlugin main) {
        super(main);
    }

    @Override
    public void init() {
        this.configMarketEnabledWorlds = this.getMain().getConfig().getStringList(Setting.WORLDS_MARKET_ENABLED_WORLDS_STRINGLIST.path);
        this.configEconomyEnabledWorlds = this.getMain().getConfig().getStringList(Setting.WORLDS_ECONOMY_ENABLED_WORLDS_STRINGLIST.path);
        this.marketEnabledWorlds = new HashMap();
        this.economyEnabledWorlds = new HashMap();
        this.marketEnableAllWorlds = this.getMain().getConfig().getBoolean(Setting.WORLDS_MARKET_ENABLE_ALL_WORLDS_BOOLEAN.path);
        this.economyEnableAllWorlds = this.getMain().getConfig().getBoolean(Setting.WORLDS_ECONOMY_ENABLE_ALL_WORLDS_BOOLEAN.path);
        this.marketApplyToItems = this.getMain().getConfig().getBoolean(Setting.WORLDS_MARKET_APPLY_ITEMS_BOOLEAN.path);
        this.marketApplyToEnchants = this.getMain().getConfig().getBoolean(Setting.WORLDS_MARKET_APPLY_ENCHANTS_BOOLEAN.path);
        this.marketApplyToExperience = this.getMain().getConfig().getBoolean(Setting.WORLDS_MARKET_APPLY_EXP_BOOLEAN.path);
        boolean enableNotification = this.getMain().getConfig().getBoolean(Setting.WORLDS_ENABLE_NOTIFICATION_BOOLEAN.path);
        if (enableNotification) {
            this.getMain().getServer().getPluginManager().registerEvents((Listener)new WorldNotification(this.getMain(), this), (Plugin)this.getMain());
        }
    }

    @Override
    public void deinit() {
    }

    public List<World> getMarketEnabledWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (World world : this.getMain().getServer().getWorlds()) {
            if (!this.isMarketEnabled(world)) continue;
            worlds.add(world);
        }
        return worlds;
    }

    public List<World> getMarketDisabledWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (World world : this.getMain().getServer().getWorlds()) {
            if (this.isMarketEnabled(world)) continue;
            worlds.add(world);
        }
        return worlds;
    }

    public List<World> getEconomyEnabledWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (World world : this.getMain().getServer().getWorlds()) {
            if (!this.isEconomyEnabled(world)) continue;
            worlds.add(world);
        }
        return worlds;
    }

    public List<World> getEconomyDisabledWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (World world : this.getMain().getServer().getWorlds()) {
            if (this.isEconomyEnabled(world)) continue;
            worlds.add(world);
        }
        return worlds;
    }

    public boolean isEconomyEnabled(String worldName) {
        for (World world : this.getMain().getServer().getWorlds()) {
            if (!world.getName().equalsIgnoreCase(worldName)) continue;
            return this.isEconomyEnabled(world);
        }
        return false;
    }

    public boolean isEconomyEnabled(World world) {
        if (this.economyEnableAllWorlds) {
            return true;
        }
        if (!this.economyEnabledWorlds.containsKey(world.getName())) {
            this.economyEnabledWorlds.put(world.getName(), this.configEconomyEnabledWorlds.contains(world.getName()));
        }
        return this.economyEnabledWorlds.get(world.getName());
    }

    public boolean isMarketEnabled(String worldName) {
        for (World world : this.getMain().getServer().getWorlds()) {
            if (!world.getName().equalsIgnoreCase(worldName)) continue;
            return this.isMarketEnabled(world);
        }
        return false;
    }

    public boolean isMarketEnabled(World world) {
        if (this.marketEnableAllWorlds) {
            return true;
        }
        if (!this.marketEnabledWorlds.containsKey(world.getName())) {
            this.marketEnabledWorlds.put(world.getName(), this.configMarketEnabledWorlds.contains(world.getName()));
        }
        return this.marketEnabledWorlds.get(world.getName());
    }

    public boolean isItemMarketEnabled(World world) {
        return this.marketApplyToItems && this.isMarketEnabled(world);
    }

    public boolean isEnchantMarketEnabled(World world) {
        return this.marketApplyToEnchants && this.isMarketEnabled(world);
    }

    public boolean isExperienceMarketEnabled(World world) {
        return this.marketApplyToExperience && this.isMarketEnabled(world);
    }
}

