/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import org.mariuszgromada.math.mxparser.StringUtils;
import org.mariuszgromada.math.mxparser.mXparser;

public class License {
    private static UseType typeOfUse = UseType.Null;
    private static String signature = null;
    private static int numberOfConfirmationAttempts = 0;
    private static String message = "";
    private static String errorMessage = "";
    private static final String ERROR_NOT_CONFIRMED = "The type of use has not been confirmed. You can test the software, but its distribution does not comply with the License.geTermsOfAgreement().";
    private static final int MAXIMUM_NUMBER_OF_WARNING_DISPLAY = 100;
    private static int numberOfWarningDisplay = 0;
    public static final String MATHPARSERORG_MXPARSER_DUAL_LICENSE_AGREEMENT = "mXparser - version 6.0.0\nMathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19\nThe most up-to-date license is available at the below link:\n- https://mathparser.org/mxparser-license\n\nAUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved\nPUBLISHER: INFIMA - https://payhip.com/infima\n\nSOFTWARE means source code and/or binary form and/or documentation.\nPRODUCT: MathParser.org-mXparser SOFTWARE\nLICENSE: DUAL LICENSE AGREEMENT\n\nBY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE\nBOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.\n\nThe AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT\nmodel designed to meet the needs of both non-commercial use and commercial\nuse.\n\nNON-COMMERCIAL USE means any use or activity where a fee is not charged\nand the purpose is not the sale of a good or service, and the use or\nactivity is not intended to produce a profit. Examples of NON-COMMERCIAL USE\ninclude:\n\n1. Non-commercial open-source software.\n2. Non-commercial mobile applications.\n3. Non-commercial desktop software.\n4. Non-commercial web applications/solutions.\n5. Non-commercial use in research, scholarly and educational context.\n\nThe above list is non-exhaustive and illustrative only.\n\nCOMMERCIAL USE means any use or activity where a fee is charged or the\npurpose is the sale of a good or service, or the use or activity is\nintended to produce a profit. COMMERCIAL USE examples:\n\n1. OEMs (Original Equipment Manufacturers).\n2. ISVs (Independent Software Vendors).\n3. VARs (Value Added Resellers).\n4. Other distributors that combine and distribute commercially licensed\n   software.\n\nThe above list is non-exhaustive and illustrative only.\n\nIN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE\nAPPROPRIATE LICENSE FROM \"INFIMA\" ONLINE STORE, STORE ADDRESS:\n\n1. https://mathparser.org/order-commercial-license\n2. https://payhip.com/infima\n\nNON-COMMERCIAL LICENSE\n\nRedistribution and use of the PRODUCT in source and/or binary forms,\nwith or without modification, are permitted provided that the following\nconditions are met:\n\n1. Redistributions of source code must retain the unmodified content of\n   the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including\n   the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,\n   the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,\n   and the following DISCLAIMER.\n2. Redistributions in binary form must reproduce the entire content of\n   MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation\n   and/or other materials provided with the distribution, including the\n   definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the\n   NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,\n   and the following DISCLAIMER.\n3. Any form of redistribution requires confirmation and signature of\n   the NON-COMMERCIAL USE by successfully calling the method:\n      License.iConfirmNonCommercialUse(...)\n   The method call is used only internally for logging purposes, and\n   there is no connection with other external services, and no data is\n   sent or collected. The lack of a method call (or its successful call)\n   does not affect the operation of the PRODUCT in any way. Please see\n   the API documentation.\n\nCOMMERCIAL LICENSE\n\n 1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow\n    you to download, install, and use up to three copies of the PRODUCT to\n    perform integration tests, confirm the quality of the PRODUCT, and\n    its suitability. The testing period should be limited to fourteen\n    days. Tests should be performed under the test environments conditions\n    and not for profit generation.\n 2. Provided that you purchased a license from \"INFIMA\" online store\n    (store address: https://mathparser.org/order-commercial-license or\n    https://payhip.com/infima), and you comply with all terms and\n    conditions below, and you have acknowledged and understood the\n    following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive\n    license with the following rights:\n 3. The license is granted only to you, the person or entity that made\n    the purchase, identified and confirmed by the data provided during\n    the purchase.\n 4. If you purchased a license in the \"ONE-TIME PURCHASE\" model, the\n    license is granted only for the PRODUCT version specified in the\n    purchase. The upgrade policy gives you additional rights, described\n    in the dedicated section below.\n 5. If you purchased a license in the \"SUBSCRIPTION\" model, you may\n    install and use any version of the PRODUCT during the subscription\n    validity period.\n 6. If you purchased a \"SINGLE LICENSE\" you may install and use the\n    PRODUCT on/from one workstation that is located/accessible at/from\n    any of your premises.\n 7. Additional copies of the PRODUCT may be installed and used on/from\n    more than one workstation, limited to the number of workstations\n    purchased per order.\n 8. If you purchased a \"SITE LICENSE\", the PRODUCT may be installed\n    and used on/from all workstations located/accessible at/from any\n    of your premises.\n 9. You may incorporate the unmodified PRODUCT into your own products\n    and software.\n10. If you purchased a license with the \"SOURCE CODE\" option, you may\n    modify the PRODUCT's source code and incorporate the modified source\n    code into your own products and/or software.\n11. Provided that the license validity period has not expired, you may\n    distribute your product and/or software with the incorporated\n    PRODUCT royalty-free.\n12. You may make copies of the PRODUCT for backup and archival purposes.\n13. Any form of redistribution requires confirmation and signature of\n    the COMMERCIAL USE by successfully calling the method:\n       License.iConfirmCommercialUse(...)\n    The method call is used only internally for logging purposes, and\n    there is no connection with other external services, and no data is\n    sent or collected. The lack of a method call (or its successful call)\n    does not affect the operation of the PRODUCT in any way. Please see\n    the API documentation.\n14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to\n    you in this agreement.\n\nADDITIONAL CLARIFICATION ON WORKSTATION\n\nA workstation is a device, a remote device, or a virtual device, used by\nyou, your employees, or other entities to whom you have commissioned\ntasks. For example, the number of workstations may refer to the number\nof software developers, engineers, architects, scientists, and other\nprofessionals who use the PRODUCT on your behalf. The number of\nworkstations is not the number of copies of your end-product that you\ndistribute to your end-users.\n\nBy purchasing the COMMERCIAL LICENSE, you only pay for the number of\nworkstations, while the number of copies/users of your final product\n(delivered to your end-users) is not limited.\n\nBelow are some examples to help you select the right license size:\n\nExample 1: Single Workstation License\nOnly one developer works on the development of your application. You do\nnot use separate environments for testing, meaning you design, create,\ntest, and compile your final application on one environment. In this\ncase, you need a license for a single workstation.\n\nExample 2: Up to 5 Workstations License\nTwo developers are working on the development of your application.\nAdditionally, one tester conducts tests in a separate environment.\nYou use three workstations in total, so you need a license for up to\nfive workstations.\n\nExample 3: Up to 20 Workstations License\nTen developers are working on the development of your application.\nAdditionally, five testers conduct tests in separate environments.\nYou use fifteen workstations in total, so you need a license for\nup to twenty workstations.\n\nExample 4: Site License\nSeveral dozen developers and testers work on the development of your\napplication using multiple environments. You have a large,\nmulti-disciplinary team involved in creating your solution. As your team\nis growing and you want to avoid licensing limitations, the best choice\nwould be a site license.\n\nUPGRADE POLICY\n\nThe PRODUCT is versioned according to the following convention:\n\n   [MAJOR].[MINOR].[PATCH]\n\n1. COMMERCIAL LICENSE holders can install and use the updated version\n   for bug fixes free of charge, i.e. if you have purchased a license\n   for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install\n   all releases specified in the [PATCH] version (e.g., 5.0.2).\n   The license terms remain unchanged after the update.\n2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)\n   can install and use the updated version [MAJOR].[MINOR + 1] free of\n   charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The\n   license terms remain unchanged after the update.\n3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are\n   not eligible for the free upgrade, can claim a discount when\n   purchasing the upgrade. For this purpose, please contact us via e-mail.\n\nDISCLAIMER\n\nTHIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER \"AS IS\" AND ANY EXPRESS\nOR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\nWARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\nDISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE\nLIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\nSUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\nINTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\nCONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\nARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF\nTHE POSSIBILITY OF SUCH DAMAGE.\n\nTHE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE\nTHOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING\nOFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.\n\nCONTACT\n\n- e-mail: info@mathparser.org\n- website: https://mathparser.org\n- source code: https://github.com/mariuszgromada/MathParser.org-mXparser\n- online store: https://mathparser.org/order-commercial-license\n- online store: https://payhip.com/infima\n";

    private static void displayWarning() {
        if (++numberOfWarningDisplay > 100) {
            return;
        }
        StringUtils.errorPrintln();
        StringUtils.errorPrintln("WARNING: MathParser.org-mXparser License - use type not confirmed!");
        StringUtils.errorPrintln("WARNING: The type of use has not been confirmed. You can test the software, but its distribution does not comply with the License.geTermsOfAgreement().");
        StringUtils.errorPrintln("WARNING: Please call one of the following methods:");
        StringUtils.errorPrintln("WARNING:    License.iConfirmNonCommercialUse(...)");
        StringUtils.errorPrintln("WARNING:    License.iConfirmCommercialUse(...)");
        StringUtils.errorPrintln("WARNING: Read more at:");
        StringUtils.errorPrintln("WARNING:    https://mathparser.org");
        StringUtils.errorPrintln("WARNING:    https://mathparser.org/mxparser-tutorial/confirming-non-commercial-commercial-use");
        StringUtils.errorPrintln();
    }

    static void checkLicense() {
        if (numberOfConfirmationAttempts == 0 || typeOfUse == UseType.Null || signature == null) {
            License.displayWarning();
        }
    }

    static int getUseType() {
        if (typeOfUse == UseType.Null) {
            return 0;
        }
        if (typeOfUse == UseType.NonCommercial) {
            return 1;
        }
        if (typeOfUse == UseType.Commercial) {
            return 2;
        }
        return 3;
    }

    private static void setErrorMessage(MessageType type, String errorMessage) {
        License.errorMessage = (Object)((Object)type) + ": " + errorMessage;
        StringUtils.errorPrintln(License.errorMessage);
    }

    private static void setMessageConfirmedCommercial() {
        message = "You \"" + signature + "\" have confirmed the commercial use according to the License.geTermsOfAgreement(). Thank you.";
    }

    private static void setMessageConfirmedNonCommercial() {
        message = "You \"" + signature + "\" have confirmed the non-commercial use according to the License.geTermsOfAgreement(). Thank you.";
    }

    private static boolean checkIfProperSignature(String providedSignature) {
        if (providedSignature == null) {
            License.setErrorMessage(MessageType.ERROR, "The signature cannot be null.");
            return false;
        }
        if (providedSignature.trim().length() < 5) {
            License.setErrorMessage(MessageType.ERROR, "The signature cannot be shorter than 5 characters.");
            return false;
        }
        return true;
    }

    private static boolean checkIfNoPreviousConfirmationAttempts() {
        if (numberOfConfirmationAttempts == 0) {
            return true;
        }
        License.setErrorMessage(MessageType.ERROR, "Only one attempt of use type confirmation can be made. If you want to modify the confirmed use type, you should identify the previous call and change it.");
        return false;
    }

    private static boolean checkLackOfPreviousConfirmation() {
        if (typeOfUse == UseType.Null || signature == null) {
            return true;
        }
        License.setErrorMessage(MessageType.WARNING, "You cannot change a previously signed confirmation. " + message + " If you want to modify the confirmed use type, you should identify the previous call and change it.");
        return false;
    }

    public static boolean iConfirmCommercialUse(String mySignature) {
        if (!License.checkLackOfPreviousConfirmation()) {
            return false;
        }
        if (!License.checkIfNoPreviousConfirmationAttempts()) {
            return false;
        }
        ++numberOfConfirmationAttempts;
        if (!License.checkIfProperSignature(mySignature)) {
            return false;
        }
        signature = mySignature.trim();
        typeOfUse = UseType.Commercial;
        License.setMessageConfirmedCommercial();
        return true;
    }

    public static boolean iConfirmNonCommercialUse(String mySignature) {
        if (!License.checkLackOfPreviousConfirmation()) {
            return false;
        }
        if (!License.checkIfNoPreviousConfirmationAttempts()) {
            return false;
        }
        ++numberOfConfirmationAttempts;
        if (!License.checkIfProperSignature(mySignature)) {
            return false;
        }
        signature = mySignature.trim();
        typeOfUse = UseType.NonCommercial;
        License.setMessageConfirmedNonCommercial();
        return true;
    }

    public static boolean checkIfUseTypeConfirmed() {
        if (numberOfConfirmationAttempts == 0) {
            License.setErrorMessage(MessageType.WARNING, ERROR_NOT_CONFIRMED);
            return false;
        }
        if (typeOfUse == UseType.Null || signature == null) {
            License.setErrorMessage(MessageType.ERROR, ERROR_NOT_CONFIRMED);
            return false;
        }
        if (typeOfUse == UseType.NonCommercial) {
            License.setMessageConfirmedNonCommercial();
        }
        if (typeOfUse == UseType.Commercial) {
            License.setMessageConfirmedCommercial();
        }
        return true;
    }

    public static String getUseTypeConfirmationMessage() {
        if (!License.checkIfUseTypeConfirmed()) {
            return errorMessage;
        }
        return message;
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static String geTermsOfAgreement() {
        return MATHPARSERORG_MXPARSER_DUAL_LICENSE_AGREEMENT;
    }

    public static void consolePrintLicense() {
        mXparser.consolePrint("\n\n");
        mXparser.consolePrint(MATHPARSERORG_MXPARSER_DUAL_LICENSE_AGREEMENT);
        mXparser.consolePrintln();
    }

    private static enum UseType {
        Null,
        NonCommercial,
        Commercial;

    }

    private static enum MessageType {
        ERROR,
        WARNING;

    }
}

