/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;

public class ClearBal
extends DivinityCommand {
    public ClearBal(DEPlugin app) {
        super(app, "clearbal", true, Setting.COMMAND_CLEAR_BALANCE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        Player player2;
        switch (args.length) {
            case 0: {
                player2 = sender;
                break;
            }
            case 1: {
                player2 = this.getMain().getPlayMan().getPlayer(args[0], false);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (player2 == null) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance((OfflinePlayer)player2);
        EconomyResponse response = this.getMain().getEconMan().setCash((OfflinePlayer)player2, 0.0);
        if (response.transactionSuccess()) {
            this.getMain().getConsole().logBalance((OfflinePlayer)sender, (OfflinePlayer)player2, startingBalance, response.balance, LangEntry.BALANCE_ClearedByPlayer.get(this.getMain(), sender.getName()));
        } else {
            this.getMain().getConsole().logFailedBalance((OfflinePlayer)sender, (OfflinePlayer)player2, response.errorMessage);
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        OfflinePlayer player;
        switch (args.length) {
            case 1: {
                player = this.getMain().getPlayMan().getPlayer(args[0], false);
                break;
            }
            default: {
                this.getMain().getConsole().usage(LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (player == null) {
            this.getMain().getConsole().send(LangEntry.GENERIC_InvalidPlayerName.logLevel, LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), new Object[0]);
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance(player);
        EconomyResponse response = this.getMain().getEconMan().setCash(player, 0.0);
        if (response.transactionSuccess()) {
            this.getMain().getConsole().logBalance(null, player, startingBalance, response.balance, LangEntry.BALANCE_ClearedByConsole.get(this.getMain()));
        } else {
            this.getMain().getConsole().logFailedBalance(null, player, response.errorMessage);
        }
        return true;
    }
}

