/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ESetStock
extends DivinityCommand {
    public ESetStock(DEPlugin app) {
        super(app, "esetstock", true, Setting.COMMAND_E_SET_STOCK_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int stock;
        MarketableEnchant enchantData;
        switch (args.length) {
            case 2: {
                enchantData = this.getMain().getEnchMan().getEnchant(args[0]);
                stock = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (enchantData == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidEnchantName.get(this.getMain()), args[0]);
            return true;
        }
        if (stock < 0) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidStockAmount.logLevel, LangEntry.MARKET_InvalidStockAmount.get(this.getMain()), stock, 0);
            return true;
        }
        int previousStock = enchantData.getQuantity();
        double previousValue = this.getMain().getEnchMan().getBuyPrice(enchantData.getQuantity());
        this.getMain().getEnchMan().setQuantity(enchantData, stock);
        this.getMain().getConsole().send(sender, LangEntry.STOCK_CountChanged.logLevel, LangEntry.STOCK_CountChanged.get(this.getMain()), previousStock, this.getMain().getConsole().formatMoney(previousValue), stock, this.getMain().getConsole().formatMoney(this.getMain().getEnchMan().getBuyPrice(enchantData.getQuantity())));
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

