/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ESetValue
extends DivinityCommand {
    public ESetValue(DEPlugin app) {
        super(app, "esetvalue", true, Setting.COMMAND_E_SET_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        double value;
        MarketableEnchant enchantData;
        switch (args.length) {
            case 2: {
                enchantData = this.getMain().getEnchMan().getEnchant(args[0]);
                value = Converter.getDouble(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (enchantData == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidEnchantName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), args[0]);
            return true;
        }
        if (value < 0.0) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), value, 0);
            return true;
        }
        int previousStock = enchantData.getQuantity();
        double previousValue = this.getMain().getEnchMan().getBuyPrice(enchantData.getQuantity());
        this.getMain().getEnchMan().setPrice(enchantData, value);
        this.getMain().getConsole().send(sender, LangEntry.STOCK_ValueChanged.logLevel, LangEntry.STOCK_ValueChanged.get(this.getMain()), this.getMain().getConsole().formatMoney(previousValue), previousStock, this.getMain().getConsole().formatMoney(value), enchantData.getQuantity());
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

