/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.admin;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class SetValue
extends DivinityCommand {
    public SetValue(DEPlugin app) {
        super(app, "setvalue", true, Setting.COMMAND_SET_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        double value;
        MarketableMaterial marketableMaterial;
        switch (args.length) {
            case 2: {
                marketableMaterial = this.getMain().getMarkMan().getItem(args[0]);
                value = Converter.getDouble(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, String.format(LangEntry.MARKET_InvalidItemName.get(this.getMain()), args[0]), new Object[0]);
            return true;
        }
        if (value < 0.0) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, String.format(LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), value, 0), new Object[0]);
            return true;
        }
        int previousStock = marketableMaterial.getQuantity();
        double previousValue = marketableMaterial.getManager().getBuyPrice(marketableMaterial.getQuantity());
        marketableMaterial.getManager().setPrice(marketableMaterial, value);
        this.getMain().getConsole().send(sender, LangEntry.STOCK_ValueChanged.logLevel, String.format(LangEntry.STOCK_ValueChanged.get(this.getMain()), this.getMain().getConsole().formatMoney(previousValue), previousStock, this.getMain().getConsole().formatMoney(value), marketableMaterial.getQuantity()), new Object[0]);
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

