/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.response.Response;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EnchantHandBuy
extends DivinityCommandEnchant {
    public EnchantHandBuy(DEPlugin app) {
        super(app, "ebuy", false, Setting.COMMAND_E_BUY_ENABLE_BOOLEAN);
        this.checkEnchantMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String enchantName;
        int enchantLevels = 1;
        switch (args.length) {
            case 1: {
                enchantName = args[0];
                break;
            }
            case 2: {
                enchantName = args[0];
                enchantLevels = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (enchantLevels > 10000 || enchantLevels < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            this.getMain().getConsole().warn(sender, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        if (heldItem.getAmount() > 1) {
            this.getMain().getConsole().warn(sender, LangEntry.MARKET_EnchantsInvalidItemAmount.get(this.getMain()), new Object[0]);
            return true;
        }
        EnchantValueResponse evr = this.getMain().getEnchMan().getBuyValue(heldItem, enchantName, enchantLevels);
        if (evr.isFailure()) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, enchantLevels, enchantName, evr.getErrorMessage());
            return true;
        }
        MarketableEnchant enchantData = this.getMain().getEnchMan().getEnchant(enchantName);
        if (enchantData == null) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, enchantLevels, enchantName, String.format(LangEntry.MARKET_InvalidEnchantName.get(this.getMain()), enchantName));
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance((OfflinePlayer)sender);
        EconomyResponse economyResponse = this.getMain().getEconMan().remCash((OfflinePlayer)sender, evr.getValue());
        if (!economyResponse.transactionSuccess()) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, enchantLevels, enchantData.getName(), economyResponse.errorMessage);
            this.getMain().getEconMan().setCash((OfflinePlayer)sender, startingBalance);
            return true;
        }
        Response response = this.getMain().getEnchMan().addEnchantToItem(heldItem, enchantData.getEnchantment(), enchantLevels);
        if (response.isFailure()) {
            this.getMain().getConsole().logFailedPurchase((OfflinePlayer)sender, enchantLevels, enchantData.getName(), response.getErrorMessage());
            this.getMain().getEconMan().setCash((OfflinePlayer)sender, startingBalance);
            return true;
        }
        this.getMain().getConsole().logPurchase((OfflinePlayer)sender, enchantLevels, evr.getValue(), enchantData.getName());
        this.getMain().getEnchMan().editLevelQuantity(enchantData, -enchantLevels);
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

