/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import java.util.ArrayList;
import java.util.HashSet;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.player.PlayerManager;

public class EnchantSellAll
extends DivinityCommandEnchant {
    public EnchantSellAll(DEPlugin app) {
        super(app, "esellall", false, Setting.COMMAND_E_SELL_ALL_ENABLE_BOOLEAN);
        this.checkEnchantMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        boolean blocking = false;
        HashSet<MarketableMaterial> marketableMaterials = new HashSet<MarketableMaterial>();
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                String arg = args[0];
                if (arg.startsWith("!")) {
                    blocking = true;
                    arg = arg.replaceFirst("!", "");
                }
                for (String materialName : arg.split(",")) {
                    MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
                    if (marketableMaterial == null) {
                        this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemName.logLevel, LangEntry.MARKET_InvalidItemName.get(this.getMain()), materialName);
                        return true;
                    }
                    marketableMaterials.add(marketableMaterial);
                }
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        ItemStack[] playerInventory = PlayerManager.getInventoryMaterials(sender);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : playerInventory) {
            MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(itemStack);
            if (!(blocking && !marketableMaterials.contains(marketableMaterial) || !blocking && marketableMaterials.contains(marketableMaterial)) && (blocking || marketableMaterials.size() != 0)) continue;
            itemStackList.add(itemStack);
        }
        ItemStack[] allStacks = itemStackList.toArray(new ItemStack[0]);
        if (allStacks.length == 0) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_NothingToSell.logLevel, LangEntry.MARKET_NothingToSell.get(this.getMain()), new Object[0]);
            return true;
        }
        EnchantValueResponse response = this.getMain().getEnchMan().getSellValue(allStacks);
        if (response.getTokenIds().size() == 0) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_NothingToSellAfterSkipping.logLevel, LangEntry.MARKET_NothingToSellAfterSkipping.get(this.getMain()), new Object[0]);
            return true;
        }
        if (response.isFailure()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), LangEntry.MARKET_EnchantList.get(this.getMain(), response.listNames()), response.getErrorMessage());
            return true;
        }
        for (ItemStack itemStack : response.getItemStacks()) {
            this.getMain().getEnchMan().removeEnchantsFromItem(itemStack);
        }
        for (MarketableToken token : response.getQuantities().keySet()) {
            MarketableEnchant enchant = (MarketableEnchant)token;
            enchant.getManager().editQuantity(enchant, response.getQuantity(enchant));
        }
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, response.getValue());
        if (!economyResponse.transactionSuccess()) {
            PlayerManager.removePlayerItems(response.getItemStacksAsArray());
            PlayerManager.addPlayerItems(sender, response.getClonesAsArray());
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), LangEntry.MARKET_EnchantList.get(this.getMain(), response.listNames()), economyResponse.errorMessage);
            return true;
        }
        this.getMain().getConsole().logSale((OfflinePlayer)sender, response.getQuantity(), response.getValue(), LangEntry.MARKET_EnchantList.get(this.getMain(), response.listNames()));
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

