/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.enchants;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandEnchant;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EnchantValue
extends DivinityCommandEnchant {
    public EnchantValue(DEPlugin app) {
        super(app, "evalue", true, Setting.COMMAND_E_VALUE_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String enchantName;
        int enchantLevels = 1;
        switch (args.length) {
            case 1: {
                enchantName = args[0];
                break;
            }
            case 2: {
                enchantName = args[0];
                enchantLevels = Converter.getInt(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (enchantLevels > 10000 || enchantLevels < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableEnchant enchantData = this.getMain().getEnchMan().getEnchant(enchantName);
        if (enchantData == null) {
            this.getMain().getConsole().usage(sender, String.format(LangEntry.MARKET_InvalidEnchantName.get(this.getMain()), enchantName), this.help.getUsages());
            return true;
        }
        ItemStack itemStack = new ItemStack(Material.DIAMOND_SWORD);
        EnchantValueResponse evr1 = this.getMain().getEnchMan().getBuyValue(itemStack, enchantName, enchantLevels);
        itemStack.addUnsafeEnchantment(enchantData.getEnchantment(), enchantLevels);
        EnchantValueResponse evr2 = this.getMain().getEnchMan().getSellValue(itemStack, enchantName, enchantLevels);
        if (evr1.isFailure()) {
            this.getMain().getConsole().warn(sender, LangEntry.VALUE_BuyFailedResponse.get(this.getMain()), enchantLevels, enchantData.getName(), evr1.getErrorMessage());
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_BuyResponse.get(this.getMain()), enchantLevels, enchantData.getName(), this.getMain().getConsole().formatMoney(evr1.getValue()));
        }
        if (evr1.isFailure()) {
            this.getMain().getConsole().warn(sender, LangEntry.VALUE_SellFailedResponse.get(this.getMain()), enchantLevels, enchantData.getName(), evr2.getErrorMessage());
        } else {
            this.getMain().getConsole().info(sender, LangEntry.VALUE_SellResponse.get(this.getMain()), enchantLevels, enchantData.getName(), this.getMain().getConsole().formatMoney(evr2.getValue()));
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

