/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.experience;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandExperience;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.exp.ExpManager;
import org.divinitycraft.divinityeconomy.response.ValueResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class ExperienceSell
extends DivinityCommandExperience {
    public ExperienceSell(DEPlugin app) {
        super(app, "xpsell", false, Setting.COMMAND_EXP_SELL_ENABLE_BOOLEAN);
        this.checkExperienceMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int experience = 1;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (LangEntry.W_max.is(this.getMain(), args[0])) {
                    experience = ExpManager.getPlayerExp(sender);
                    break;
                }
                experience = Converter.getInt(args[0]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        experience = Converter.constrainInt(experience, this.getMain().getExpMan().getMinTradableExp(), this.getMain().getExpMan().getMaxTradableExp());
        ValueResponse valueResponse = this.getMain().getExpMan().getSellValue(experience, sender);
        if (valueResponse.isFailure()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, experience, LangEntry.W_experience.get(this.getMain()), valueResponse.getErrorMessage());
            return true;
        }
        double startingBalance = this.getMain().getEconMan().getBalance((OfflinePlayer)sender);
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, valueResponse.getValue());
        if (!economyResponse.transactionSuccess()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, experience, LangEntry.W_experience.get(this.getMain()), economyResponse.errorMessage);
            this.getMain().getEconMan().setCash((OfflinePlayer)sender, startingBalance);
        } else {
            this.getMain().getExpMan().remExperience(sender, experience);
            this.getMain().getConsole().logSale((OfflinePlayer)sender, experience, economyResponse.amount, LangEntry.W_experience.get(this.getMain()));
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

