/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.mail;

import java.util.ArrayList;
import java.util.Map;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.mail.Mail;
import org.divinitycraft.divinityeconomy.mail.MailList;

public class ClearMail
extends DivinityCommand {
    public ClearMail(DEPlugin app) {
        super(app, "clearmail", false, Setting.COMMAND_CLEAR_MAIL_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        if (!this.getMain().getMailMan().isMailEnabled()) {
            this.returnCommandDisabled(sender);
            return true;
        }
        boolean clearRead = false;
        boolean clearUnread = false;
        switch (args.length) {
            case 1: {
                String arg = args[0].toLowerCase();
                if (LangEntry.W_all.is(this.getMain(), arg)) {
                    clearRead = true;
                    clearUnread = true;
                    break;
                }
                if (LangEntry.W_read.is(this.getMain(), arg)) {
                    clearRead = true;
                    break;
                }
                if (LangEntry.W_unread.is(this.getMain(), arg)) {
                    clearUnread = true;
                    break;
                }
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        MailList mailList = this.getMain().getMailMan().getMailList(sender.getUniqueId().toString());
        Map<String, Mail> allMail = mailList.getAllMail();
        ArrayList<String> readMail = mailList.getReadMail();
        ArrayList<String> unreadMail = mailList.getUnreadMail();
        ArrayList<String> mailToClear = new ArrayList<String>();
        int readMailCleared = 0;
        int unreadMailCleared = 0;
        if (allMail.isEmpty()) {
            this.getMain().getConsole().warn(sender, LangEntry.MAIL_NothingToClear.get(this.getMain()), new Object[0]);
        } else {
            if (clearRead) {
                mailToClear.addAll(readMail);
                readMailCleared = readMail.size();
            }
            if (clearUnread) {
                mailToClear.addAll(unreadMail);
                unreadMailCleared = unreadMail.size();
            }
            for (String mailID : mailToClear) {
                mailList.removeMail(mailID);
            }
            this.getMain().getConsole().info(sender, LangEntry.MAIL_Removed.get(this.getMain()), mailToClear.size(), unreadMailCleared, readMailCleared);
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

