/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterials;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class HandSell
extends DivinityCommandMaterials {
    public HandSell(DEPlugin app) {
        super(app, "handsell", false, Setting.COMMAND_HAND_SELL_ITEM_ENABLE_BOOLEAN);
        this.checkItemMarketEnabled = true;
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        int amountToSell = 1;
        boolean sellAll = false;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                String arg = args[0];
                if (LangEntry.W_max.is(this.getMain(), arg)) {
                    sellAll = true;
                    break;
                }
                amountToSell = Converter.getInt(args[0]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (amountToSell > 10000 || amountToSell < 1) {
            this.getMain().getConsole().send(sender, LangEntry.GENERIC_InvalidAmountGiven.logLevel, LangEntry.GENERIC_InvalidAmountGiven.get(this.getMain()), new Object[0]);
            return true;
        }
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemHeld.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(heldItem);
        if (marketableMaterial == null) {
            this.getMain().getConsole().send(sender, LangEntry.MARKET_InvalidItemHeld.logLevel, LangEntry.MARKET_InvalidItemHeld.get(this.getMain()), new Object[0]);
            return true;
        }
        int materialCount = marketableMaterial.getMaterialCount(sender);
        if (sellAll) {
            amountToSell = materialCount;
        }
        if (!marketableMaterial.getAllowed()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, amountToSell, marketableMaterial.getName(), LangEntry.MARKET_ItemIsBanned.get(this.getMain(), marketableMaterial.getName()));
            return true;
        }
        if (materialCount < amountToSell) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, amountToSell, marketableMaterial.getName(), String.format(LangEntry.MARKET_InvalidInventoryStock.get(this.getMain()), materialCount, amountToSell));
            return true;
        }
        MaterialValueResponse response = marketableMaterial.getManager().getSellValue(marketableMaterial.getMaterialSlotsToCount(sender, amountToSell));
        if (response.getItemStacks().size() == 0) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), LangEntry.MARKET_NothingToSellAfterSkipping.get(this.getMain()).toLowerCase());
            return true;
        }
        if (response.isFailure()) {
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), response.getErrorMessage());
            return true;
        }
        PlayerManager.removePlayerItems(response.getItemStacksAsArray());
        EconomyResponse economyResponse = this.getMain().getEconMan().addCash((OfflinePlayer)sender, response.getValue());
        if (!economyResponse.transactionSuccess()) {
            PlayerManager.addPlayerItems(sender, response.getClonesAsArray());
            this.getMain().getConsole().logFailedSale((OfflinePlayer)sender, response.getQuantity(), marketableMaterial.getName(), economyResponse.errorMessage);
            return true;
        }
        marketableMaterial.getManager().editQuantity(marketableMaterial, response.getQuantity());
        this.getMain().getConsole().logSale((OfflinePlayer)sender, response.getQuantity(), response.getValue(), marketableMaterial.getName());
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return false;
    }
}

