/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommandMaterialsTC;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.player.PlayerManager;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class HandSellTC
extends DivinityCommandMaterialsTC {
    public HandSellTC(DEPlugin app) {
        super(app, "handsell", false, Setting.COMMAND_HAND_SELL_ITEM_ENABLE_BOOLEAN);
    }

    @Override
    public List<String> onPlayerTabCompleter(Player sender, String[] args) {
        String[] strings = new String[]{};
        ItemStack heldItem = PlayerManager.getHeldItem(sender);
        if (heldItem == null) {
            strings = new String[]{LangEntry.MARKET_InvalidItemHeld.get(this.getMain())};
        } else {
            MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(heldItem);
            switch (args.length) {
                case 1: {
                    Material material = marketableMaterial.getMaterial();
                    ArrayList<String> allStrings = new ArrayList<String>();
                    int heldAmount = heldItem.getAmount();
                    int stackSize = material.getMaxStackSize();
                    int inventoryCount = marketableMaterial.getMaterialCount(sender);
                    LangEntry.W_max.addLang(this.getMain(), allStrings);
                    allStrings.add(String.valueOf(heldAmount));
                    if (stackSize < inventoryCount) {
                        allStrings.add(String.valueOf(stackSize));
                        allStrings.add(String.valueOf(inventoryCount));
                    }
                    strings = allStrings.toArray(new String[0]);
                    break;
                }
                case 2: {
                    strings = new String[]{LangEntry.VALUE_Response.get(this.getMain(), this.getMain().getConsole().formatMoney(marketableMaterial.getManager().calculatePrice(Converter.getInt(args[0]), marketableMaterial.getQuantity(), marketableMaterial.getManager().getSellScale(), false)))};
                }
            }
        }
        return Arrays.asList(strings);
    }

    @Override
    public List<String> onConsoleTabCompleter(String[] args) {
        return null;
    }
}

