/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.market;

import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;

public class Info
extends DivinityCommand {
    public Info(DEPlugin app) {
        super(app, "information", true, Setting.COMMAND_INFO_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        String materialName;
        switch (args.length) {
            case 1: {
                materialName = args[0];
                break;
            }
            default: {
                this.getMain().getConsole().usage(sender, LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(materialName);
        if (marketableMaterial == null) {
            this.getMain().getConsole().usage(sender, LangEntry.MARKET_UnknownItem.get(this.getMain(), materialName), this.help.getUsages());
        } else {
            this.getMain().getConsole().info(sender, LangEntry.INFO_InformationFor.get(this.getMain()), marketableMaterial.getName());
            this.getMain().getConsole().info(sender, LangEntry.INFO_TypeInformation.get(this.getMain()), marketableMaterial.getManager().getType());
            this.getMain().getConsole().info(sender, LangEntry.INFO_IDInformation.get(this.getMain()), marketableMaterial.getID());
            this.getMain().getConsole().info(sender, LangEntry.INFO_CurrentQuantityInformation.get(this.getMain()), marketableMaterial.getQuantity());
            this.getMain().getConsole().info(sender, LangEntry.INFO_IsBannedInformation.get(this.getMain()), !marketableMaterial.getAllowed());
        }
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        return this.onPlayerCommand(null, args);
    }
}

