/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.commands.misc;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.commands.DivinityCommand;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayer;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EconomyNotifications
extends DivinityCommand {
    public EconomyNotifications(DEPlugin app) {
        super(app, "economynotifications", true, Setting.COMMAND_ECONOMY_NOTIFICATIONS_ENABLE_BOOLEAN);
    }

    @Override
    public boolean onPlayerCommand(Player sender, String[] args) {
        boolean enable;
        EconomyPlayer player = this.getMain().getEconMan().getPlayer((OfflinePlayer)sender);
        switch (args.length) {
            case 0: {
                enable = !player.getNotification();
                break;
            }
            case 1: {
                enable = Converter.getBoolean(args[0]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        player.setNotification(enable);
        this.getMain().getConsole().info(sender, LangEntry.MISC_EnableNotifications.get(this.getMain(), player.getNotification()), new Object[0]);
        return true;
    }

    @Override
    public boolean onConsoleCommand(String[] args) {
        OfflinePlayer player = null;
        Boolean enable = null;
        switch (args.length) {
            case 1: {
                player = this.getMain().getPlayMan().getPlayer(args[0], true);
                break;
            }
            case 2: {
                player = this.getMain().getPlayMan().getPlayer(args[0], true);
                enable = Converter.getBoolean(args[1]);
                break;
            }
            default: {
                this.getMain().getConsole().usage(LangEntry.GENERIC_InvalidNumberOfArguments.get(this.getMain()), this.help.getUsages());
                return true;
            }
        }
        if (player == null) {
            this.getMain().getConsole().warn(LangEntry.GENERIC_InvalidPlayerName.get(this.getMain()), args[0]);
            return true;
        }
        EconomyPlayer econPlayer = this.getMain().getEconMan().getPlayer(player);
        if (enable == null) {
            enable = !econPlayer.getNotification();
        }
        econPlayer.setNotification(enable);
        this.getMain().getConsole().info(LangEntry.MISC_EnableNotificationsFor.get(this.getMain(), econPlayer.getName(), econPlayer.getNotification()), new Object[0]);
        Player onlinePlayer = player.getPlayer();
        if (onlinePlayer != null) {
            this.getMain().getConsole().info(player.getPlayer(), LangEntry.MISC_EnableNotifications.get(this.getMain(), econPlayer.getNotification()), new Object[0]);
        }
        return true;
    }
}

