/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.console;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.console.LogLevel;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.mail.MailList;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class Console
extends DivinityModule {
    private static final String[] variables = new String[]{"<VERSION>"};
    private static final String[] variableValues = new String[]{"<VERSION>"};
    private static Console i;
    private final ConsoleCommandSender consoleSender;
    private final boolean debugMode;
    private final String chatPrefix;
    private final String consolePrefix;
    private final int scale;
    private final String currencyPrefix;
    private final String currencySuffix;

    public Console(DEPlugin main) {
        super(main);
        this.consoleSender = main.getServer().getConsoleSender();
        Console.variableValues[0] = main.getDescription().getVersion();
        FileConfiguration conf = main.getConfig();
        this.debugMode = conf.getBoolean(Setting.CHAT_DEBUG_OUTPUT_BOOLEAN.path);
        String prefix = conf.getString(Setting.CHAT_PREFIX_STRING.path);
        String conPrefix = conf.getString(Setting.CHAT_CONSOLE_PREFIX.path);
        this.chatPrefix = Console.insertColours(prefix);
        conPrefix = Console.insertColours(conPrefix);
        this.consolePrefix = Console.insertVariables(conPrefix);
        this.scale = Converter.constrainInt(conf.getInt(Setting.CHAT_ECONOMY_DIGITS_INT.path), 0, 8);
        this.currencyPrefix = conf.getString(Setting.CHAT_ECONOMY_PREFIX_STRING.path);
        this.currencySuffix = conf.getString(Setting.CHAT_ECONOMY_SUFFIX_STRING.path);
        i = this;
    }

    public static Console get() {
        return i;
    }

    private static String insertVariables(String string) {
        for (int idx = 0; idx < variables.length; ++idx) {
            string = string.replace(variables[idx], variableValues[idx]);
        }
        return string;
    }

    private static String insertColours(String string) {
        for (ChatColor colour : ChatColor.values()) {
            string = string.replaceAll(String.format("(&%s)|(%s)", Character.valueOf(colour.getChar()), colour.name()), colour.toString());
        }
        return string;
    }

    @Override
    public void init() {
    }

    @Override
    public void deinit() {
    }

    public void send(LogLevel level, String message, Object ... args) {
        this.consoleSender.sendMessage(this.consolePrefix + String.valueOf(level.getColour()) + String.format(message, args));
    }

    public void migrate(String message, Object ... args) {
        this.send(LogLevel.MIGRATE, message, args);
    }

    public void info(String message, Object ... args) {
        this.send(LogLevel.INFO, message, args);
    }

    public void debug(String message, Object ... args) {
        if (this.debugMode) {
            this.send(LogLevel.DEBUG, message, args);
        }
    }

    public void warn(String message, Object ... args) {
        this.send(LogLevel.WARNING, message, args);
    }

    public void severe(String message, Object ... args) {
        this.send(LogLevel.SEVERE, message, args);
    }

    public void send(Player player, LogLevel level, String message, Object ... args) {
        if (player != null) {
            player.sendMessage(this.chatPrefix + String.valueOf(level.getColour()) + String.format(message, args));
        } else {
            this.send(level, message, args);
        }
    }

    public void usage(Player player, String errorMessage, String[] usages) {
        this.warn(player, String.format(LangEntry.GENERIC_IncorrectCommandUsage.get(this.getMain()), errorMessage), new Object[0]);
        this.warn(player, String.format(LangEntry.GENERIC_CommandUsage.get(this.getMain()), Arrays.toString(usages)), new Object[0]);
    }

    public void usage(String errorMessage, String[] usages) {
        this.warn(String.format(LangEntry.GENERIC_IncorrectCommandUsage.get(this.getMain()), errorMessage), new Object[0]);
        this.warn(String.format(LangEntry.GENERIC_CommandUsage.get(this.getMain()), Arrays.toString(usages)), new Object[0]);
    }

    public void help(Player player, String command, String description, String[] usages, String[] aliases) {
        this.info(player, LangEntry.GENERIC_HelpFor.get(this.getMain(), command), new Object[0]);
        this.info(player, LangEntry.GENERIC_Description.get(this.getMain(), description), new Object[0]);
        this.info(player, LangEntry.GENERIC_Usages.get(this.getMain(), ""), new Object[0]);
        for (String usage : usages) {
            this.info(player, "  -" + usage, new Object[0]);
        }
        this.info(player, LangEntry.GENERIC_Aliases.get(this.getMain(), String.join((CharSequence)", ", aliases)), new Object[0]);
    }

    public void info(Player player, String message, Object ... args) {
        this.send(player, LogLevel.INFO, message, args);
    }

    public void warn(Player player, String message, Object ... args) {
        this.send(player, LogLevel.WARNING, message, args);
    }

    public void severe(Player player, String message, Object ... args) {
        this.send(player, LogLevel.SEVERE, message, args);
    }

    public String getCurrencyPrefix() {
        return this.currencyPrefix;
    }

    public String getCurrencySuffix() {
        return this.currencySuffix;
    }

    public String formatMoney(double value) {
        return String.format("%s%,." + this.scale + "f%s", this.currencyPrefix, Math.floor(value * Math.pow(10.0, this.scale)) / Math.pow(10.0, this.scale), this.currencySuffix);
    }

    public String getFormattedBalance(OfflinePlayer player) {
        return this.formatMoney(this.getEconMan().getBalance(player));
    }

    public void logTransfer(OfflinePlayer player1, OfflinePlayer player2, double amount) {
        String stringAmount = this.formatMoney(amount);
        this.info(this.getLang().get(LangEntry.TRANSFER_Log), player1.getName(), stringAmount, player2.getName());
        Player onlinePlayer1 = player1.getPlayer();
        MailList player1MailList = this.getMailMan().getMailList(player1.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.TRANSFER_SourceResponse, stringAmount, player2.getName(), this.getFormattedBalance(player1));
        if (onlinePlayer1 != null) {
            this.info(onlinePlayer1, player1Message, new Object[0]);
        } else {
            player1MailList.createMail(String.format("%s <aptime>", player1Message));
        }
        Player onlinePlayer2 = player2.getPlayer();
        MailList player2MailList = this.getMailMan().getMailList(player2.getUniqueId().toString());
        String player2Message = this.getLang().get(LangEntry.TRANSFER_TargetResponse, stringAmount, player1.getName(), this.getFormattedBalance(player2));
        if (onlinePlayer2 != null) {
            this.info(onlinePlayer2, player2Message, new Object[0]);
        } else {
            player2MailList.createMail(String.format("%s <aptime>", player2Message));
        }
    }

    public void logFailedTransfer(OfflinePlayer player1, OfflinePlayer player2, double amount, String error) {
        String stringAmount = this.formatMoney(amount);
        this.warn(this.getLang().get(LangEntry.TRANSFER_FailedLog), player1.getName(), stringAmount, player2.getName(), error);
        Player onlinePlayer1 = player1.getPlayer();
        MailList player1MailList = this.getMailMan().getMailList(player1.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.TRANSFER_FailedResponse, stringAmount, player2.getName(), error);
        if (onlinePlayer1 != null) {
            this.warn(onlinePlayer1, player1Message, new Object[0]);
        } else {
            player1MailList.createMail(player1Message);
        }
    }

    public void logBalance(@Nullable OfflinePlayer player1, @Nonnull OfflinePlayer player2, double balance1, double balance2, String reason) {
        String stringBalance1 = this.formatMoney(balance1);
        String stringBalance2 = this.formatMoney(balance2);
        this.info(LangEntry.BALANCE_ChangedLog.get(this.getMain()), player2.getName(), stringBalance1, stringBalance2, reason);
        if (player1 != player2 && player1 != null) {
            Player onlinePlayer1 = player1.getPlayer();
            String playerMessage1 = LangEntry.BALANCE_ChangedSourcePlayer.get(this.getMain(), player2.getName(), stringBalance1, stringBalance2, reason);
            if (onlinePlayer1 != null) {
                this.info(onlinePlayer1, playerMessage1, new Object[0]);
            }
        }
        Player onlinePlayer2 = player2.getPlayer();
        MailList playerMailList2 = this.getMailMan().getMailList(player2.getUniqueId().toString());
        String playerMessage2 = LangEntry.BALANCE_ChangedTargetPlayer.get(this.getMain(), stringBalance1, stringBalance2, reason);
        if (onlinePlayer2 != null) {
            this.info(onlinePlayer2, playerMessage2, new Object[0]);
        } else {
            playerMailList2.createMail(String.format("%s <aptime>", playerMessage2));
        }
    }

    public void logFailedBalance(@Nullable OfflinePlayer player1, @Nonnull OfflinePlayer player2, String error) {
        Player onlinePlayer1;
        String playerMessage = LangEntry.BALANCE_ChangeFailedLog.get(this.getMain(), player2.getName(), error);
        this.warn(playerMessage, new Object[0]);
        if (player1 != player2 && player1 != null && (onlinePlayer1 = player1.getPlayer()) != null) {
            this.warn(onlinePlayer1, playerMessage, new Object[0]);
        }
        Player onlinePlayer2 = player2.getPlayer();
        MailList playerMailList = this.getMailMan().getMailList(player2.getUniqueId().toString());
        if (onlinePlayer2 != null) {
            this.warn(onlinePlayer2, playerMessage, new Object[0]);
        } else {
            playerMailList.createMail(String.format("%s <aptime>", playerMessage));
        }
    }

    public void logPurchase(OfflinePlayer player, int amount, double cost, String materialName) {
        String stringCost = this.formatMoney(cost);
        this.info(this.getLang().get(LangEntry.PURCHASE_Log), player.getName(), amount, materialName, stringCost);
        Player onlinePlayer = player.getPlayer();
        MailList playerMailList = this.getMailMan().getMailList(player.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.PURCHASE_Response, amount, materialName, stringCost);
        if (onlinePlayer != null) {
            this.info(onlinePlayer, player1Message, new Object[0]);
        } else {
            playerMailList.createMail(String.format("%s <aptime>", player1Message));
        }
    }

    public void logFailedPurchase(OfflinePlayer player, int amount, String materialName, String error) {
        this.warn(this.getLang().get(LangEntry.PURCHASE_FailedLog), player.getName(), amount, materialName, error);
        Player onlinePlayer = player.getPlayer();
        MailList playerMailList = this.getMailMan().getMailList(player.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.PURCHASE_FailedResponse, amount, materialName, error);
        if (onlinePlayer != null) {
            this.warn(onlinePlayer, player1Message, new Object[0]);
        } else {
            playerMailList.createMail(String.format("%s <aptime>", player1Message));
        }
    }

    public void logSale(OfflinePlayer player, int amount, double value, String materialName) {
        String stringValue = this.formatMoney(value);
        this.info(this.getLang().get(LangEntry.SALE_Log), player.getName(), amount, materialName, stringValue);
        Player onlinePlayer = player.getPlayer();
        MailList playerMailList = this.getMailMan().getMailList(player.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.SALE_Response, amount, materialName, stringValue);
        if (onlinePlayer != null) {
            this.info(onlinePlayer, player1Message, new Object[0]);
        } else {
            playerMailList.createMail(String.format("%s <aptime>", player1Message));
        }
    }

    public void logFailedSale(OfflinePlayer player, int amount, String materialName, String error) {
        this.warn(this.getLang().get(LangEntry.SALE_FailedLog), player.getName(), amount, materialName, error);
        Player onlinePlayer = player.getPlayer();
        MailList playerMailList = this.getMailMan().getMailList(player.getUniqueId().toString());
        String player1Message = this.getLang().get(LangEntry.SALE_FailedResponse, amount, materialName, error);
        if (onlinePlayer != null) {
            this.warn(onlinePlayer, player1Message, new Object[0]);
        } else {
            playerMailList.createMail(String.format("%s <aptime>", player1Message));
        }
    }
}

