/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.economy.FileKey;
import org.divinitycraft.divinityeconomy.economy.banks.EconomyBank;
import org.divinitycraft.divinityeconomy.economy.banks.EconomyBankLRUCache;
import org.divinitycraft.divinityeconomy.economy.events.PlayerJoin;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayer;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayerLRUCache;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class DivinityEconomy
implements Economy {
    private static final String userdata = "userdata";
    private static final String bankdata = "bankdata";
    private static final int LIST_TASK_INTERVAL = Converter.getTicks(60);
    private final DEPlugin main;
    private final int fractionalDigits;
    private final String currencyNamePlural;
    private final String currencyNameSingular;
    private final EconomyPlayerLRUCache economyPlayerMap;
    private final EconomyBankLRUCache economyBankMap;
    private final File userFolder;
    private final File bankData;
    private final Set<String> banks;
    private final BukkitRunnable bankListTask = new BukkitRunnable(){

        public void run() {
            DivinityEconomy.this.fetchBanks();
        }
    };

    public DivinityEconomy(DEPlugin main) {
        this.main = main;
        this.fractionalDigits = this.main.getConfMan().getInt(Setting.CHAT_ECONOMY_DIGITS_INT);
        this.currencyNamePlural = this.main.getConfMan().getString(Setting.CHAT_ECONOMY_PLURAL_STRING);
        this.currencyNameSingular = this.main.getConfMan().getString(Setting.CHAT_ECONOMY_SINGULAR_STRING);
        this.userFolder = this.main.getConfMan().getFolder(userdata);
        this.bankData = this.main.getConfMan().getFolder(bankdata);
        this.economyPlayerMap = new EconomyPlayerLRUCache(this.main, this.userFolder);
        this.economyBankMap = new EconomyBankLRUCache(this.main, this.bankData);
        this.banks = Collections.synchronizedSet(new HashSet());
        this.main.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(this.main, this), (Plugin)this.main);
    }

    public void startTasks() {
        this.bankListTask.runTaskTimerAsynchronously((Plugin)this.main, 0L, (long)LIST_TASK_INTERVAL);
        this.fetchBanks();
    }

    public void stopTasks() {
        this.bankListTask.cancel();
    }

    private EconomyPlayer get(UUID uuid) {
        OfflinePlayer player = this.main.getPlayMan().getPlayer(uuid);
        return this.get(player);
    }

    public EconomyPlayer get(@Nonnull OfflinePlayer offlinePlayer) {
        return (EconomyPlayer)this.economyPlayerMap.get(offlinePlayer);
    }

    @Nullable
    public EconomyPlayer get(String name) {
        OfflinePlayer player = this.main.getPlayMan().getPlayer(name, true);
        if (player == null) {
            return null;
        }
        return this.get(player);
    }

    public EconomyBank getBank(String name) {
        return (EconomyBank)this.economyBankMap.get(name);
    }

    public EconomyResponse withdrawPlayer(EconomyPlayer p, double v) {
        if (v < 0.0) {
            return new EconomyResponse(v, p.getBalanceAsDouble(), EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_NegativeAmounts.get(this.main));
        }
        if (!p.has(v)) {
            return new EconomyResponse(v, p.getBalanceAsDouble(), EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_Overdraft.get(this.main));
        }
        double balance = p.withdraw(v);
        return new EconomyResponse(v, balance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(EconomyPlayer p, double v) {
        if (v < 0.0) {
            return new EconomyResponse(v, p.getBalanceAsDouble(), EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_NegativeAmounts.get(this.main));
        }
        if (!p.canHave(v)) {
            return new EconomyResponse(v, p.getBalanceAsDouble(), EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_OverLimit.get(this.main));
        }
        double balance = p.deposit(v);
        return new EconomyResponse(v, balance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.main.getName();
    }

    public boolean hasBankSupport() {
        return true;
    }

    public int fractionalDigits() {
        return this.fractionalDigits;
    }

    public String format(double v) {
        return this.main.getConsole().formatMoney(v);
    }

    public String currencyNamePlural() {
        return this.currencyNamePlural;
    }

    public String currencyNameSingular() {
        return this.currencyNameSingular;
    }

    @Deprecated
    public boolean hasAccount(String s) {
        return this.get(s) != null;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return this.get(offlinePlayer) != null;
    }

    @Deprecated
    public boolean hasAccount(String s, String s1) {
        return this.hasAccount(s);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s) {
        return this.hasAccount(offlinePlayer);
    }

    @Deprecated
    public double getBalance(String s) {
        EconomyPlayer player = this.get(s);
        if (player == null) {
            return 0.0;
        }
        return player.getBalanceAsDouble();
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        return this.get(offlinePlayer).getBalanceAsDouble();
    }

    @Deprecated
    public double getBalance(String s, String s1) {
        return this.getBalance(s);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s) {
        return this.getBalance(offlinePlayer);
    }

    @Deprecated
    public boolean has(String s, double v) {
        return this.get(s).has(v);
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        return this.get(offlinePlayer).has(v);
    }

    @Deprecated
    public boolean has(String s, String s1, double v) {
        return this.has(s, v);
    }

    public boolean has(OfflinePlayer offlinePlayer, String s, double v) {
        return this.has(offlinePlayer, v);
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String s, double v) {
        return this.withdrawPlayer(this.get(s), v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double v) {
        return this.withdrawPlayer(this.get(offlinePlayer), v);
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String s, String s1, double v) {
        return this.withdrawPlayer(s, v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.withdrawPlayer(offlinePlayer, v);
    }

    @Deprecated
    public EconomyResponse depositPlayer(String s, double v) {
        return this.depositPlayer(this.get(s), v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double v) {
        return this.depositPlayer(this.get(offlinePlayer), v);
    }

    @Deprecated
    public EconomyResponse depositPlayer(String s, String s1, double v) {
        return this.depositPlayer(this.get(s), v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.depositPlayer(this.get(offlinePlayer), v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchBanks() {
        File[] files = this.bankData.listFiles();
        if (files == null) {
            return;
        }
        HashSet<String> thisBanks = new HashSet<String>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EconomyBank bank = new EconomyBank(this.main, file);
            if (!bank.isValid()) {
                this.main.getConsole().warn("Invalid bank file: " + file.getName() + ". Skipping...", new Object[0]);
                continue;
            }
            thisBanks.add(bank.getName());
        }
        Set<String> set = this.banks;
        synchronized (set) {
            this.banks.clear();
            this.banks.addAll(thisBanks);
        }
    }

    @Deprecated
    public EconomyResponse createBank(String bankName, String playerName) {
        bankName = DivinityEconomy.cleanBankName(bankName);
        OfflinePlayer player = this.main.getPlayMan().getPlayer(playerName, true);
        if (player == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_PlayerNotExist.get(this.main));
        }
        return this.createBank(bankName, player);
    }

    public EconomyResponse createBank(String bankName, OfflinePlayer player) {
        if (this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankAlreadyExists.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        bank.set(FileKey.NAME, bankName);
        bank.set(FileKey.UUID, player.getUniqueId().toString());
        bank.set(FileKey.MEMBERS, new ArrayList<UUID>(Collections.singleton(player.getUniqueId())));
        bank.setBalance(0.0);
        bank.clean();
        bank.save();
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), EconomyResponse.ResponseType.SUCCESS, LangEntry.ECONOMY_CreatedBank.get(this.main, bank.getName()));
    }

    public EconomyResponse deleteBank(String bankName) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        if (!this.economyBankMap.containsKey(bankName)) {
            this.economyBankMap.get(bankName);
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.remove(bankName);
        bank.delete();
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, LangEntry.ECONOMY_DeletedBank.get(this.main, bank.getName()));
    }

    public EconomyResponse bankBalance(String bankName) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), EconomyResponse.ResponseType.SUCCESS, LangEntry.ECONOMY_BankBalance.get(this.main, bank.getName(), bank.getBalanceAsDouble()));
    }

    public EconomyResponse bankHas(String bankName, double v) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        boolean has = bank.has(v);
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), has ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankHas.get(this.main, bank.getName(), v));
    }

    public EconomyResponse bankWithdraw(String bankName, double v) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        double balance = bank.withdraw(v);
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, LangEntry.ECONOMY_BankWithdraw.get(this.main, v, bank.getName()));
    }

    public EconomyResponse bankDeposit(String bankName, double v) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        double balance = bank.deposit(v);
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.SUCCESS, LangEntry.ECONOMY_BankDeposit.get(this.main, v, bank.getName()));
    }

    @Deprecated
    public EconomyResponse isBankOwner(String bankName, String playerName) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        boolean isOwner = bank.isOwner(playerName);
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), isOwner ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_IsOwner.get(this.main, playerName, bank.getName()));
    }

    public EconomyResponse isBankOwner(String bankName, OfflinePlayer offlinePlayer) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        boolean isOwner = bank.isOwner(offlinePlayer.getUniqueId());
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), isOwner ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_IsOwner.get(this.main, offlinePlayer.getName(), bank.getName()));
    }

    @Deprecated
    public EconomyResponse isBankMember(String bankName, String playerName) {
        if (!this.economyBankMap.query(bankName = DivinityEconomy.cleanBankName(bankName))) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_BankNotExist.get(this.main));
        }
        OfflinePlayer player = this.main.getPlayMan().getPlayer(playerName, true);
        if (player == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_PlayerNotExist.get(this.main));
        }
        return this.isBankMember(bankName, player);
    }

    public EconomyResponse isBankMember(String bankName, OfflinePlayer offlinePlayer) {
        EconomyPlayer player = this.get(offlinePlayer.getUniqueId());
        EconomyBank bank = (EconomyBank)this.economyBankMap.get(bankName);
        UUID uuid = player.getUUID();
        if (uuid == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_PlayerNotExist.get(this.main));
        }
        boolean isMember = bank.isMember(uuid);
        return new EconomyResponse(0.0, bank.getBalanceAsDouble(), isMember ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, LangEntry.ECONOMY_IsMember.get(this.main, offlinePlayer.getName(), bank.getName()));
    }

    public List<String> getBanks() {
        return new ArrayList<String>(this.banks);
    }

    @Deprecated
    public boolean createPlayerAccount(String s) {
        return this.get(s) != null;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        return this.get(offlinePlayer) != null;
    }

    @Deprecated
    public boolean createPlayerAccount(String s, String s1) {
        return this.get(s) != null;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        return this.get(offlinePlayer) != null;
    }

    public static String cleanBankName(String name) {
        return name.toLowerCase().replaceAll("[^a-z0-9]", "").strip();
    }
}

