/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy.banks;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.economy.EconomyObject;
import org.divinitycraft.divinityeconomy.economy.FileKey;

public class EconomyBank
extends EconomyObject {
    Set<FileKey> keys = Set.of(FileKey.BALANCE, FileKey.NAME, FileKey.UUID, FileKey.MEMBERS);

    public EconomyBank(DEPlugin main, File file) {
        super(main, file);
        this.clean();
        this.save();
    }

    public boolean isOwner(String playerName) {
        String ownerName = this.getOwnerName();
        if (ownerName == null) {
            return false;
        }
        return ownerName.equalsIgnoreCase(playerName);
    }

    public boolean isOwner(UUID playerUUID) {
        String ownerUUID = this.getUUIDAsString();
        if (ownerUUID == null) {
            return false;
        }
        return ownerUUID.equalsIgnoreCase(playerUUID.toString());
    }

    @Nullable
    public String getOwnerName() {
        return this.getMain().getPlayMan().getPlayerName(this.getMain().getPlayMan().getPlayer(this.getUUID())).getName();
    }

    @Nonnull
    public Set<UUID> getMembers() {
        return new HashSet<UUID>(this.config.getStringList(FileKey.MEMBERS.getKey()).stream().map(UUID::fromString).toList());
    }

    @Nonnull
    public EconomyBank addMembers(@Nonnull Set<UUID> members) {
        Set<UUID> membersSet = this.getMembers();
        membersSet.addAll(members);
        return this.setMembers(membersSet);
    }

    @Nonnull
    public EconomyBank removeMembers(@Nonnull Set<UUID> members) {
        Set<UUID> membersSet = this.getMembers();
        members.forEach(membersSet::remove);
        return this.setMembers(membersSet);
    }

    public boolean isMember(@Nonnull UUID playerUUID) {
        return this.getMembers().contains(playerUUID);
    }

    public EconomyBank setMembers(Set<UUID> members) {
        this.setAndSave(FileKey.MEMBERS, members);
        return this;
    }

    public boolean isValid() {
        for (FileKey key : this.keys) {
            if (this.config.contains(key.getKey())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkKey(@Nonnull String key) {
        return this.keys.contains((Object)FileKey.get(key));
    }

    public void delete() {
        File backupFile;
        File file = this.getFile();
        if (file != null && file.exists()) {
            file.delete();
        }
        if ((backupFile = this.getBackupFile()) != null && backupFile.exists()) {
            backupFile.delete();
        }
    }
}

