/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy.banks;

import java.io.File;
import java.io.IOException;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.economy.banks.EconomyBank;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.utils.LRUCache;

public class EconomyBankLRUCache
extends LRUCache<String, EconomyBank> {
    protected final File bankFile;

    public EconomyBankLRUCache(DEPlugin main, File bankFile) {
        super(main);
        this.bankFile = bankFile;
    }

    @Override
    protected int loadMemorySize() {
        return 2048;
    }

    @Override
    public boolean query(String key) {
        return this.containsKey(key) || this.getFile(key).exists();
    }

    public File getFile(String key) {
        return new File(this.bankFile, EconomyBank.getFilename(key));
    }

    @Override
    protected EconomyBank load(String key) {
        File file = this.getFile(key);
        return this.ingest(file);
    }

    protected EconomyBank ingest(File bankFile) {
        return new EconomyBank(this.getMain(), bankFile);
    }

    protected boolean create(File bankFile) {
        boolean result = false;
        try {
            result = bankFile.createNewFile();
        }
        catch (IOException e) {
            this.main.getConsole().warn(LangEntry.ECONOMY_FailedToCreateBankFile.get(this.getMain()), bankFile.getAbsolutePath(), e.getMessage());
        }
        return result;
    }
}

