/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.economy.players;

import java.io.File;
import org.bukkit.OfflinePlayer;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.economy.banks.EconomyBank;
import org.divinitycraft.divinityeconomy.economy.players.EconomyPlayer;
import org.divinitycraft.divinityeconomy.utils.LRUCache;

public class EconomyPlayerLRUCache
extends LRUCache<OfflinePlayer, EconomyPlayer> {
    protected final File userFile;

    public EconomyPlayerLRUCache(DEPlugin main, File userFile) {
        super(main);
        this.userFile = userFile;
    }

    @Override
    protected int loadMemorySize() {
        return 2048;
    }

    @Override
    protected boolean query(OfflinePlayer player) {
        return this.containsKey(player) || this.getFile(player).exists();
    }

    protected File getFile(OfflinePlayer offlinePlayer) {
        return new File(this.userFile, EconomyBank.getFilename(offlinePlayer.getUniqueId().toString()));
    }

    @Override
    protected EconomyPlayer load(OfflinePlayer player) {
        File file = this.getFile(player);
        return this.ingest(file, player);
    }

    protected EconomyPlayer ingest(File userFolder, OfflinePlayer player) {
        return new EconomyPlayer(this.getMain(), userFolder, player);
    }
}

