/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.mail;

import java.time.Duration;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.divinitycraft.divinityeconomy.mail.MailList;

public class Mail {
    private final MailList mailList;
    private final ConfigurationSection configurationSection;

    public Mail(MailList mailList, ConfigurationSection configurationSection) {
        this.mailList = mailList;
        this.configurationSection = configurationSection;
    }

    public String getID() {
        return String.valueOf(this.getDateFrom().getTimeInMillis());
    }

    public String getRawMessage() {
        return this.configurationSection.getString(this.mailList.strMessage);
    }

    public String getMessage() {
        String message = this.getRawMessage();
        message = message.replace("<daysAgo>", String.valueOf(this.getDaysSince()));
        message = message.replace("<hoursAgo>", String.valueOf(this.getHoursSince()));
        message = message.replace("<minsAgo>", String.valueOf(this.getMinutesSince()));
        Map<String, Object> aptime = this.getApTimeSince();
        message = message.replace("<aptime>", String.format("%s %s ago", aptime.get("value"), aptime.get("type")));
        return message;
    }

    public Calendar getDateFrom() {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.configurationSection.getLong(this.mailList.strDate));
        return date;
    }

    public Duration getTimeSince() {
        Calendar currentDate = Calendar.getInstance();
        return Duration.between(this.getDateFrom().toInstant(), currentDate.toInstant());
    }

    public int getDaysSince() {
        return (int)this.getTimeSince().toDays();
    }

    public int getHoursSince() {
        return (int)this.getTimeSince().toHours();
    }

    public int getMinutesSince() {
        return (int)this.getTimeSince().toMinutes();
    }

    public Map<String, Object> getApTimeSince() {
        int days = this.getDaysSince();
        int hours = this.getHoursSince();
        int minutes = this.getMinutesSince();
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        if (minutes <= 120) {
            result.put("value", minutes);
            result.put("type", "minutes");
        } else if (hours <= 72) {
            result.put("value", hours);
            result.put("type", "hours");
        } else {
            result.put("value", days);
            result.put("type", "days");
        }
        return result;
    }

    public boolean getRead() {
        return this.configurationSection.getBoolean(this.mailList.strRead);
    }

    public void setRead(boolean state) {
        this.configurationSection.set(this.mailList.strRead, (Object)state);
    }

    public ConfigurationSection getConfigurationSection() {
        return this.configurationSection;
    }
}

