/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.mail;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.divinitycraft.divinityeconomy.mail.Mail;
import org.divinitycraft.divinityeconomy.utils.ArrayUtils;

public class MailList {
    public final String strDate = "date";
    public final String strMessage = "message";
    public final String strRead = "read";
    private final Map<String, Mail> mail;
    private final ConfigurationSection configurationSection;
    private final String playerUUID;
    private final boolean isDud;

    public MailList(String UUID2, @Nullable ConfigurationSection configurationSection) {
        this.playerUUID = UUID2;
        this.configurationSection = configurationSection;
        this.mail = new ConcurrentHashMap<String, Mail>();
        if (configurationSection == null) {
            this.isDud = true;
            return;
        }
        this.isDud = false;
        for (String mailID : this.configurationSection.getKeys(false)) {
            ConfigurationSection mailSection = this.configurationSection.getConfigurationSection(mailID);
            if (mailSection == null) continue;
            Mail mail = new Mail(this, mailSection);
            this.addMail(mail);
        }
    }

    public Map<Integer, Mail[]> getPages(int pageSize) {
        Object[] allMail = this.getAllMail().values().toArray(new Mail[0]);
        Map<Integer, List<Object>> toPages = ArrayUtils.paginator(allMail, pageSize);
        ConcurrentHashMap<Integer, Mail[]> mailPages = new ConcurrentHashMap<Integer, Mail[]>();
        for (int pageNum : toPages.keySet()) {
            List<Object> objects = toPages.get(pageNum);
            ArrayList mail = new ArrayList();
            objects.forEach(obj -> mail.add((Mail)obj));
            mailPages.put(pageNum, mail.toArray(new Mail[0]));
        }
        return mailPages;
    }

    public ArrayList<String> getReadMail() {
        ArrayList<String> readMail = new ArrayList<String>();
        for (String mailID : this.getMailIDs()) {
            if (!this.getMail(mailID).getRead()) continue;
            readMail.add(mailID);
        }
        return readMail;
    }

    public ArrayList<String> getUnreadMail() {
        ArrayList<String> unreadMail = new ArrayList<String>();
        for (String mailID : this.getMailIDs()) {
            if (this.getMail(mailID).getRead()) continue;
            unreadMail.add(mailID);
        }
        return unreadMail;
    }

    public Mail getMail(String mailID) {
        return this.mail.get(mailID);
    }

    public Set<String> getMailIDs() {
        return this.mail.keySet();
    }

    public Map<String, Mail> getAllMail() {
        return this.mail;
    }

    public String getPlayer() {
        return this.playerUUID;
    }

    public boolean hasMail() {
        return !this.getMailIDs().isEmpty();
    }

    public boolean hasNewMail() {
        return !this.getUnreadMail().isEmpty();
    }

    public String addMail(Mail mail) {
        if (this.isDud) {
            return null;
        }
        String mailID = mail.getID();
        this.mail.put(mailID, mail);
        this.setData(mailID, mail.getConfigurationSection());
        return mailID;
    }

    public ConfigurationSection createMailSection(String name) {
        return this.configurationSection.createSection(name);
    }

    public ConfigurationSection createTempMailSection() {
        return this.createMailSection("temp");
    }

    public void removeTempMailSection() {
        this.setData("temp", null);
    }

    public Mail createMail(String message, Calendar date, boolean read) {
        if (this.isDud) {
            return null;
        }
        ConfigurationSection tempSection = this.createTempMailSection();
        tempSection.set("message", (Object)message);
        tempSection.set("date", (Object)date.getTimeInMillis());
        tempSection.set("read", (Object)read);
        Mail mail = new Mail(this, tempSection);
        this.setMail(mail.getID(), mail);
        this.removeTempMailSection();
        return mail;
    }

    public Mail createMail(String message) {
        if (this.isDud) {
            return null;
        }
        return this.createMail(message, Calendar.getInstance(), false);
    }

    public void setMail(String mailID, Mail mail) {
        this.mail.put(mailID, mail);
        this.setData(mailID, mail.getConfigurationSection());
    }

    public void removeMail(String mailID) {
        this.mail.remove(mailID);
        this.setData(mailID, null);
    }

    public ConfigurationSection getConfigurationSection() {
        return this.configurationSection;
    }

    private void setData(String key, Object value) {
        this.configurationSection.set(key, value);
    }

    public void saveAllMail() {
        if (this.isDud) {
            return;
        }
        for (Mail mail : this.getAllMail().values()) {
            this.setData(mail.getID(), mail.getConfigurationSection());
        }
    }
}

