/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market;

import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.TokenLRUCache;
import org.divinitycraft.divinityeconomy.utils.Converter;

public abstract class TokenManager
extends DivinityModule {
    protected final String itemFile;
    protected final String aliasFile;
    protected BukkitRunnable saveTimer;
    protected Map<String, String> aliasMap;
    private static final int MAX_SEARCH_DEPTH_INT = 64;
    private static final long MAX_SEARCH_NANO_LONG = 50000000L;
    private TokenLRUCache itemNamesCache;
    protected Map<String, Set<String>> revAliasMap;
    protected Map<String, ? extends MarketableToken> itemMap;
    protected long totalItems;
    protected long defaultTotalItems;
    protected double maxItemValue;
    protected double minItemValue;
    protected double buyScale;
    protected double sellScale;
    protected double baseQuantity;
    protected boolean dynamicPricing;
    protected boolean wholeMarketInflation;
    protected boolean ignoreNamedItems;
    protected boolean saveMessagesDisabled;
    protected FileConfiguration config;

    public TokenManager(DEPlugin main, String itemFile, String aliasFile, Map<String, ? extends MarketableToken> itemMap) {
        super(main);
        this.itemFile = itemFile;
        this.aliasFile = aliasFile;
        this.aliasMap = new ConcurrentHashMap<String, String>();
        this.revAliasMap = new ConcurrentHashMap<String, Set<String>>();
        this.itemNamesCache = new TokenLRUCache(main);
        this.itemMap = itemMap;
    }

    public double getBuyScale() {
        return this.buyScale;
    }

    public double getSellScale() {
        return this.sellScale;
    }

    public double getMaxItemValue() {
        return this.maxItemValue;
    }

    public double getMinItemValue() {
        return this.minItemValue;
    }

    public abstract String getType();

    public MarketableToken getItem(String alias) {
        String matID = this.aliasMap.get(alias.toLowerCase());
        if (matID == null) {
            matID = alias;
        }
        return this.itemMap.get(matID.toLowerCase());
    }

    public Set<String> getItemIDs() {
        HashSet<String> itemNames = new HashSet<String>(this.itemMap.keySet());
        itemNames.addAll(this.itemMap.keySet());
        return itemNames;
    }

    public Set<String> getItemIDs(String startsWith) {
        return this.searchItemNames(this.getItemIDs(), startsWith);
    }

    public Set<String> getItemNames() {
        HashSet<String> itemNames = new HashSet<String>(this.itemMap.keySet());
        itemNames.addAll(this.aliasMap.keySet());
        return itemNames;
    }

    public Set<String> getItemNames(String startsWith) {
        return this.searchItemNames(this.getItemNames(), startsWith.toLowerCase());
    }

    public Set<String> getItemNames(Set<String> itemIDs) {
        HashSet<String> itemNames = new HashSet<String>();
        for (String itemID : itemIDs) {
            if (!this.revAliasMap.containsKey(itemID.toLowerCase())) continue;
            itemNames.addAll((Collection<String>)this.revAliasMap.get(itemID.toLowerCase()));
        }
        return itemNames;
    }

    public Set<String> getItemNames(Set<String> itemIds, String startWith) {
        return this.searchItemNames(this.getItemNames(itemIds), startWith.toLowerCase());
    }

    public Set<String> searchItemNames(Set<String> items, String term) {
        Set<String> itemNames = (Set<String>)this.itemNamesCache.get(term);
        if (itemNames == null) {
            itemNames = this.searchItemNamesUncached(items, term);
            this.itemNamesCache.put(term, itemNames);
        }
        return itemNames;
    }

    private Set<String> searchItemNamesUncached(Set<String> items, String term) {
        term = term.toLowerCase().strip();
        HashSet<String> itemNames = new HashSet<String>();
        HashSet<String> priority0ArrayList = new HashSet<String>();
        HashSet<String> priority1ArrayList = new HashSet<String>();
        HashSet<String> priority2ArrayList = new HashSet<String>();
        HashSet<String> priority3ArrayList = new HashSet<String>();
        long startTime = System.nanoTime();
        for (String item : items) {
            int depth = priority0ArrayList.size() + priority1ArrayList.size() + priority2ArrayList.size() + priority3ArrayList.size();
            if (depth > 64) {
                this.getConsole().debug("Max search depth reached, stopping search.", new Object[0]);
                break;
            }
            if (System.nanoTime() - startTime > 50000000L) {
                this.getConsole().debug("Max search time reached, stopping search.", new Object[0]);
                break;
            }
            String thisItem = item.toLowerCase().strip();
            if (thisItem.equalsIgnoreCase(term)) {
                priority0ArrayList.add(item);
                continue;
            }
            if (thisItem.startsWith(term)) {
                priority1ArrayList.add(item);
                continue;
            }
            if (thisItem.contains(term)) {
                priority2ArrayList.add(item);
                continue;
            }
            if (!thisItem.endsWith(term)) continue;
            priority3ArrayList.add(item);
        }
        itemNames.addAll(priority0ArrayList);
        itemNames.addAll(priority1ArrayList);
        itemNames.addAll(priority2ArrayList);
        itemNames.addAll(priority3ArrayList);
        this.getConsole().debug("Found %s items matching '%s' in %s milliseconds.", itemNames.size(), term, (System.nanoTime() - startTime) / 1000000L);
        return itemNames;
    }

    public int getItemCount() {
        return this.itemMap.size();
    }

    public int getAliasCount() {
        return this.aliasMap.size();
    }

    public double getBuyPrice(double stock) {
        return this.getPrice(stock, this.buyScale, this.getInflation());
    }

    public double getSellPrice(double stock) {
        return this.getPrice(stock, this.sellScale, this.getInflation());
    }

    public void setPrice(MarketableToken itemData, double value) {
        itemData.setQuantity(this.calculateStock(value, this.buyScale, this.getInflation()));
    }

    public void editQuantity(MarketableToken itemData, int quantity) {
        itemData.editQuantity(quantity);
        this.editTotalMaterials(quantity);
    }

    public void setQuantity(MarketableToken itemData, int quantity) {
        this.editQuantity(itemData, quantity - itemData.getQuantity());
    }

    public boolean getAllowed(MarketableToken itemData) {
        return itemData.getAllowed();
    }

    public boolean setAllowed(MarketableToken itemData, boolean allowed) {
        itemData.setAllowed(allowed);
        return this.getAllowed(itemData);
    }

    public double calculatePrice(double amount, double stock, double scale, boolean purchase) {
        return this.calculatePrice(this.baseQuantity, stock, this.defaultTotalItems, this.totalItems, amount, scale, purchase, this.dynamicPricing, this.wholeMarketInflation);
    }

    public double getPrice(double stock, double scale, double inflation) {
        if (!this.wholeMarketInflation) {
            inflation = 1.0;
        }
        return this.fitPriceToConstraints(this.getPrice(this.baseQuantity, stock, scale, inflation));
    }

    public double fitPriceToConstraints(double price) {
        return Converter.constrainDouble(price, this.minItemValue, this.maxItemValue);
    }

    public int calculateStock(double price, double scale, double inflation) {
        double rawPrice = price / (scale * inflation);
        double finalScale = rawPrice / 15.0;
        double newQuantity = this.baseQuantity / finalScale;
        return (int)newQuantity;
    }

    public double getInflation() {
        if (this.wholeMarketInflation) {
            return Converter.constrainDouble(this.getInflation(this.defaultTotalItems, this.totalItems), 0.0, 100.0);
        }
        return 1.0;
    }

    private void editTotalMaterials(int amount) {
        this.totalItems += (long)amount;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public long getDefaultTotalItems() {
        return this.defaultTotalItems;
    }

    public void loadAliases() {
        try {
            File aliasFile = this.getConfMan().getFile(this.aliasFile);
            if (!aliasFile.exists()) {
                aliasFile.createNewFile();
            }
            ConfigUpdater.update((Plugin)this.getMain(), this.aliasFile, aliasFile, Collections.emptyList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileConfiguration config = this.getConfMan().loadFile(this.aliasFile);
        ConcurrentHashMap<String, String> values = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap revBuildAliasValues = new ConcurrentHashMap();
        ConcurrentHashMap<String, Set<String>> revResultAliasValues = new ConcurrentHashMap<String, Set<String>>();
        for (String key2 : config.getKeys(false)) {
            String value = config.getString(key2 = key2.toLowerCase().replace(" ", ""));
            if (value == null) {
                if (this.getConfMan().getBoolean(Setting.IGNORE_ALIAS_ERRORS_BOOLEAN).booleanValue()) continue;
                this.getConsole().warn("Bad config value in %s: '%s' - Corresponding value is null", this.aliasFile, key2);
                continue;
            }
            if (this.getItem(value = value.toLowerCase().replace(" ", "")) == null) {
                if (this.getConfMan().getBoolean(Setting.IGNORE_ALIAS_ERRORS_BOOLEAN).booleanValue()) continue;
                this.getConsole().warn("Bad config value in %s: '%s' - Corresponding value '%s' does not exist.", this.aliasFile, key2, value);
                continue;
            }
            values.put(key2, value);
            if (!values.containsKey(key2)) {
                values.put(key2, key2);
            }
            if (!revBuildAliasValues.containsKey(value)) {
                revBuildAliasValues.put(value, new HashSet());
                ((Set)revBuildAliasValues.get(value)).add(value);
            }
            ((Set)revBuildAliasValues.get(value)).add(key2);
        }
        this.aliasMap = values;
        revBuildAliasValues.keySet().forEach(key -> revResultAliasValues.put((String)key, (Set)revBuildAliasValues.get(key)));
        this.revAliasMap = revResultAliasValues;
        this.getConsole().info(LangEntry.MARKET_ItemAliasesLoaded.get(this.getMain()), values.size(), this.aliasFile);
    }

    public void loadItems() {
        try {
            File itemFile = this.getConfMan().getFile(this.itemFile);
            if (!itemFile.exists()) {
                itemFile.createNewFile();
            }
            ConfigUpdater.update((Plugin)this.getMain(), this.itemFile, this.getConfMan().getFile(this.itemFile), Collections.emptyList());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = this.getConfMan().loadFile(this.itemFile);
        FileConfiguration defaultConf = this.getConfMan().readResource(this.itemFile);
        this.defaultTotalItems = 0L;
        this.totalItems = 0L;
        ConcurrentHashMap<String, ? extends MarketableToken> values = new ConcurrentHashMap<String, MarketableToken>();
        for (String key : defaultConf.getKeys(false)) {
            ConfigurationSection data = this.config.getConfigurationSection(key);
            ConfigurationSection defaultData = defaultConf.getConfigurationSection(key);
            if (data == null) {
                if (this.getConfMan().getBoolean(Setting.IGNORE_ITEM_ERRORS_BOOLEAN).booleanValue()) continue;
                this.getConsole().warn("Bad config value in %s: '%s' - Data is null, setting default.", this.itemFile, key);
                continue;
            }
            MarketableToken itemData = this.loadItem(key, data, defaultData);
            if (!itemData.check()) {
                if (this.getConfMan().getBoolean(Setting.IGNORE_ITEM_ERRORS_BOOLEAN).booleanValue()) continue;
                this.getConsole().warn("Bad config value in %s for '%s': %s", this.itemFile, key, itemData.getError());
                continue;
            }
            key = key.toLowerCase().replace(" ", "");
            this.defaultTotalItems += (long)itemData.getDefaultQuantity();
            this.totalItems += (long)itemData.getQuantity();
            values.put(key, itemData);
        }
        this.itemMap = values;
        this.getConsole().info(LangEntry.MARKET_ItemsLoaded.get(this.getMain()), values.size(), this.totalItems, this.defaultTotalItems, this.itemFile);
    }

    public abstract MarketableToken loadItem(String var1, ConfigurationSection var2, ConfigurationSection var3);

    private void setData(String key, Object value) {
        this.config.set(key, value);
    }

    private void saveItem(MarketableToken itemData) {
        this.setData(itemData.getID(), itemData.getItemConfig());
    }

    public void saveItems() {
        this.itemMap.values().forEach(this::saveItem);
        this.saveFile();
        if (!this.saveMessagesDisabled) {
            this.getConsole().info(LangEntry.GENERIC_FileSaved.get(this.getMain()), this.itemFile);
        }
    }

    private void saveFile() {
        FileConfiguration config = this.getConfMan().loadFile(this.itemFile);
        for (String key : config.getKeys(false)) {
            String internalKey = key.toLowerCase().replace(" ", "");
            if (!this.itemMap.containsKey(internalKey)) continue;
            config.set(key, this.config.get(key));
        }
        this.getConfMan().saveFile(config, this.itemFile);
    }

    public double calculatePrice(double baseQuantity, double currentQuantity, double defaultMarketSize, double marketSize, double amount, double scale, boolean purchase, boolean dynamic, boolean marketInflation) {
        double value = 0.0;
        double inflation = 1.0;
        for (int i = 0; i < Converter.constrainInt((int)amount, 1, 10000); ++i) {
            if (marketInflation) {
                inflation = this.getInflation(defaultMarketSize, marketSize);
            }
            if (purchase) {
                value += this.getPrice(baseQuantity, currentQuantity, scale, inflation);
                if (dynamic) {
                    currentQuantity -= 1.0;
                }
                if (!dynamic || !marketInflation) continue;
                marketSize -= 1.0;
                continue;
            }
            value += this.getPrice(baseQuantity, currentQuantity + 1.0, scale, inflation);
            if (dynamic) {
                currentQuantity += 1.0;
            }
            if (!dynamic || !marketInflation) continue;
            marketSize += 1.0;
        }
        return value;
    }

    public double getPrice(double baseQuantity, double currentQuantity, double scale, double inflation) {
        currentQuantity = Math.max(currentQuantity, 1.0);
        double rawPrice = this.getRawPrice(baseQuantity, currentQuantity);
        return this.fitPriceToConstraints(rawPrice * scale * inflation);
    }

    private double getRawPrice(double baseQuantity, double currentQuantity) {
        double scale = this.getScale(baseQuantity, currentQuantity);
        return this.fitPriceToConstraints(scale * 15.0);
    }

    public double getInflation(double defaultMarketSize, double actualMarketSize) {
        return this.getScale(defaultMarketSize, actualMarketSize);
    }

    public double getScale(double baseQuantity, double currentQuantity) {
        return baseQuantity / currentQuantity;
    }
}

