/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.enchants;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;
import org.divinitycraft.divinityeconomy.response.Response;
import org.divinitycraft.divinityeconomy.utils.ArrayUtils;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class EnchantManager
extends ItemManager {
    public static final String enchantFile = "enchants.yml";
    public static final String aliasFile = "enchantAliases.yml";
    private boolean allowUnsafe;

    public EnchantManager(DEPlugin main) {
        super(main, enchantFile, aliasFile, new ConcurrentHashMap());
    }

    @Override
    public void init() {
        this.allowUnsafe = this.getConfMan().getBoolean(Setting.MARKET_ENCHANTS_ALLOW_UNSAFE_BOOLEAN);
        this.saveMessagesDisabled = this.getConfMan().getBoolean(Setting.IGNORE_SAVE_MESSAGE_BOOLEAN);
        this.buyScale = this.getConfMan().getDouble(Setting.MARKET_ENCHANTS_BUY_TAX_FLOAT);
        this.sellScale = this.getConfMan().getDouble(Setting.MARKET_ENCHANTS_SELL_TAX_FLOAT);
        this.baseQuantity = this.getConfMan().getInt(Setting.MARKET_ENCHANTS_BASE_QUANTITY_INTEGER).intValue();
        this.dynamicPricing = this.getConfMan().getBoolean(Setting.MARKET_ENCHANTS_DYN_PRICING_BOOLEAN);
        this.wholeMarketInflation = this.getConfMan().getBoolean(Setting.MARKET_ENCHANTS_WHOLE_MARKET_INF_BOOLEAN);
        this.maxItemValue = this.getConfMan().getDouble(Setting.MARKET_MAX_ITEM_VALUE_DOUBLE);
        if (this.maxItemValue < 0.0) {
            this.maxItemValue = Double.MAX_VALUE;
        }
        this.minItemValue = this.getConfMan().getDouble(Setting.MARKET_MIN_ITEM_VALUE_DOUBLE);
        if (this.minItemValue < 0.0) {
            this.minItemValue = Double.MIN_VALUE;
        }
        int timer = Converter.getTicks(this.getConfMan().getInt(Setting.MARKET_SAVE_TIMER_INTEGER));
        this.saveTimer = new BukkitRunnable(){

            public void run() {
                EnchantManager.this.saveItems();
            }
        };
        this.saveTimer.runTaskTimerAsynchronously((Plugin)this.getMain(), (long)timer, (long)timer);
        this.loadItems();
        this.loadAliases();
    }

    @Override
    public void deinit() {
        this.saveTimer.cancel();
        this.saveItems();
    }

    public MarketableEnchant getEnchant(String alias) {
        return (MarketableEnchant)this.getItem(alias);
    }

    public MarketableEnchant getEnchant(Enchantment enchantment) {
        return (MarketableEnchant)this.getItem(enchantment.getKey().getKey());
    }

    public boolean supportsEnchant(ItemStack itemStack, Enchantment enchantment) {
        EnchantmentStorageMeta enchantmentStorageMeta;
        ItemMeta itemMeta;
        return this.allowUnsafe || itemStack.getType() == Material.BOOK || (itemMeta = itemStack.getItemMeta()) instanceof EnchantmentStorageMeta && !(enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta).hasConflictingStoredEnchant(enchantment) || enchantment.canEnchantItem(itemStack);
    }

    @Override
    public String getType() {
        return "ENCHANTMENT";
    }

    public int getEnchantCount() {
        return this.itemMap.size();
    }

    public void removeEnchantLevelsFromItem(ItemStack itemStack, Enchantment enchantment, int levels) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            int currentLevel = enchantmentStorageMeta.getStoredEnchantLevel(enchantment);
            enchantmentStorageMeta.removeStoredEnchant(enchantment);
            int levelsLeft = currentLevel - levels;
            if (levelsLeft > 0) {
                enchantmentStorageMeta.addStoredEnchant(enchantment, levelsLeft, true);
            } else if (itemStack.getType() == Material.ENCHANTED_BOOK) {
                itemStack.setType(Material.BOOK);
            }
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            int currentLevel = itemStack.getEnchantmentLevel(enchantment);
            itemStack.removeEnchantment(enchantment);
            int levelsLeft = currentLevel - levels;
            if (levelsLeft > 0) {
                itemStack.addUnsafeEnchantment(enchantment, levelsLeft);
            }
        }
    }

    public void removeEnchantsFromItem(ItemStack itemStack) {
        Map<Enchantment, Integer> enchantmentIntegerMap = EnchantManager.getEnchantments(itemStack);
        enchantmentIntegerMap.forEach((enchantment, integer) -> this.removeEnchantLevelsFromItem(itemStack, (Enchantment)enchantment, (int)integer));
    }

    public Response addEnchantToItem(ItemStack itemStack, Enchantment enchantment, int levels) {
        int newLevel = levels + itemStack.getEnchantmentLevel(enchantment);
        MarketableEnchant enchantData = (MarketableEnchant)this.getItem(enchantment.getKey().getKey());
        if (enchantData == null) {
            return new Response(EconomyResponse.ResponseType.FAILURE, LangEntry.MARKET_ItemIsNotSupported.get(this.getMain(), enchantment.getKey().getKey()));
        }
        if (enchantData.getMaxLevel() < newLevel) {
            return new Response(EconomyResponse.ResponseType.FAILURE, LangEntry.MARKET_LevelIsGreaterThanMax.get(this.getMain(), newLevel, enchantData.getMaxLevel()));
        }
        if (itemStack.getType() == Material.BOOK) {
            itemStack.setType(Material.ENCHANTED_BOOK);
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)itemStack.getItemMeta();
            esm.addStoredEnchant(enchantment, newLevel, true);
            itemStack.setItemMeta((ItemMeta)esm);
        } else {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
                enchantmentStorageMeta.addStoredEnchant(enchantment, newLevel, true);
                itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
            } else {
                itemStack.addUnsafeEnchantment(enchantment, newLevel);
            }
        }
        return new Response(EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean isEnchanted(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            return ((EnchantmentStorageMeta)itemMeta).hasStoredEnchants();
        }
        return itemMeta.hasEnchants();
    }

    @Override
    public EnchantValueResponse getBuyValue(ItemStack[] itemStacks) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        for (ItemStack itemStack : itemStacks) {
            response.addResponse(this.getBuyValue(itemStack, 0));
        }
        return response;
    }

    @Override
    public EnchantValueResponse getBuyValue(ItemStack itemStack, int amount) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        Map<Enchantment, Integer> enchantments = EnchantManager.getEnchantments(itemStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            int level = enchantments.get(enchantment);
            String enchantID = enchantment.getKey().getKey();
            response.addResponse(this.getBuyValue(itemStack, enchantID, level));
        }
        return response;
    }

    @Override
    public MarketableToken loadItem(String ID, ConfigurationSection data, ConfigurationSection defaultData) {
        return new MarketableEnchant(this.getMain(), this, ID, data, defaultData);
    }

    public EnchantValueResponse getBuyValue(ItemStack itemStack, String enchantID, int levelsToBuy) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketableEnchant enchantData = (MarketableEnchant)this.getItem(enchantID);
        if (enchantData == null) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemDoesNotExist.get(this.getMain(), enchantID));
        }
        if (enchantData.getEnchantment() == null) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemDoesNotExistInTheStore.get(this.getMain(), enchantID));
        }
        Map<Enchantment, Integer> enchantments = EnchantManager.getEnchantments(itemStack);
        int itemStackEnchantmentLevel = enchantments.getOrDefault(enchantData.getEnchantment(), 0);
        int newTotalLevel = itemStackEnchantmentLevel + levelsToBuy;
        int enchantAmount = MarketableEnchant.levelsToBooks(itemStackEnchantmentLevel, newTotalLevel);
        double value = this.calculatePrice(enchantAmount, enchantData.getQuantity(), this.buyScale, false);
        response.addToken(enchantData, enchantAmount, value, itemStack);
        if (!enchantData.getAllowed()) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), enchantData.getName()));
        }
        if (!this.supportsEnchant(itemStack, enchantData.getEnchantment()) && !this.allowUnsafe) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsNotSupportedOnThisItem.get(this.getMain(), enchantData.getName()));
        }
        if (enchantData.getMaxLevel() < newTotalLevel) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_LevelWouldBeGreaterThanMax.get(this.getMain(), newTotalLevel, enchantData.getMaxLevel()));
        }
        if (enchantAmount > enchantData.getQuantity()) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_InvalidStockAmount.get(this.getMain(), enchantData.getName(), enchantData.getQuantity(), enchantAmount));
        }
        if (value <= 0.0) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), enchantData.getName()));
        }
        return response;
    }

    @Override
    public EnchantValueResponse getSellValue(ItemStack[] itemStacks) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        for (ItemStack itemStack : itemStacks) {
            EnchantValueResponse thisResponse = this.getSellValue(itemStack, 0);
            if (thisResponse.isFailure()) continue;
            response.addResponse(thisResponse);
        }
        return response;
    }

    @Override
    public EnchantValueResponse getSellValue(ItemStack itemStack, int amount) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        Map<Enchantment, Integer> enchantments = EnchantManager.getEnchantments(itemStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            EnchantValueResponse thisResponse = this.getSellValue(itemStack, enchantment.getKey().getKey(), enchantments.get(enchantment));
            if (thisResponse.isFailure()) continue;
            response.addResponse(thisResponse);
        }
        return response;
    }

    @Override
    public Set<String> getItemNames(ItemStack itemStack) {
        HashSet<String> itemNames = new HashSet<String>();
        Map<Enchantment, Integer> enchantments = EnchantManager.getEnchantments(itemStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            itemNames.add(enchantment.getKey().getKey());
        }
        return itemNames;
    }

    public Set<String> getCompatibleEnchants(ItemStack itemStack) {
        HashSet<String> itemNames = new HashSet<String>();
        for (MarketableToken token : this.itemMap.values()) {
            MarketableEnchant enchant = (MarketableEnchant)token;
            if (!this.supportsEnchant(itemStack, enchant.getEnchantment())) continue;
            itemNames.addAll((Collection)this.revAliasMap.get(enchant.getID().toLowerCase()));
        }
        return itemNames;
    }

    public String[] getCompatibleEnchants(ItemStack itemStack, String startsWith) {
        return this.searchItemNames(this.getCompatibleEnchants(itemStack), startsWith).toArray(new String[0]);
    }

    @Override
    public Set<String> getItemNames(ItemStack itemStack, String startswith) {
        return this.searchItemNames(this.getItemNames(itemStack), startswith);
    }

    public EnchantValueResponse getSellValue(ItemStack itemStack, String enchantID, int levelsToSell) {
        EnchantValueResponse response = new EnchantValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketableEnchant enchantData = (MarketableEnchant)this.getItem(enchantID);
        if (enchantData == null) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemDoesNotExist.get(this.getMain(), enchantID));
        }
        Enchantment enchantment = enchantData.getEnchantment();
        String itemCleanName = this.getMarkMan().getName(itemStack);
        if (enchantment == null) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemDoesNotExistInTheStore.get(this.getMain(), enchantID));
        }
        if (!enchantData.getAllowed()) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), enchantData.getName()));
        }
        Map<Enchantment, Integer> itemStackEnchants = EnchantManager.getEnchantments(itemStack);
        if (!itemStackEnchants.containsKey(enchantment)) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsNotEnchanted.get(this.getMain(), itemCleanName, enchantData.getName()));
        }
        int itemStackEnchantLevel = itemStackEnchants.get(enchantment);
        int bookLevel = MarketableEnchant.levelsToBooks(itemStackEnchantLevel - levelsToSell, itemStackEnchantLevel);
        if (itemStackEnchantLevel < levelsToSell) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemNotEnoughLevels.get(this.getMain(), itemCleanName, itemStackEnchantLevel, levelsToSell));
        }
        double value = this.calculatePrice(bookLevel, enchantData.getQuantity(), this.sellScale, false);
        response.addToken(enchantData, levelsToSell, value, itemStack);
        if (value <= 0.0) {
            return (EnchantValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), enchantData.getName()));
        }
        return response;
    }

    public void editLevelQuantity(MarketableEnchant enchantData, int levels) {
        int books = levels > 0 ? MarketableEnchant.levelsToBooks(0, levels) : -MarketableEnchant.levelsToBooks(0, -levels);
        this.editQuantity(enchantData, books);
    }

    public String getBuyValueString(@Nonnull ItemStack heldItem, @Nonnull String enchantID, int levels) {
        EnchantValueResponse value = this.getBuyValue(heldItem, enchantID, levels);
        if (value.isFailure()) {
            return String.format("Error: %s", value.getErrorMessage());
        }
        return String.format("Value: %s", this.getConsole().formatMoney(value.getValue()));
    }

    public String getSellValueString(@Nonnull ItemStack heldItem, @Nonnull String enchantID, int levels) {
        EnchantValueResponse value = this.getSellValue(heldItem, enchantID, levels);
        if (value.isFailure()) {
            return String.format("Error: %s", value.getErrorMessage());
        }
        return String.format("Value: %s", this.getConsole().formatMoney(value.getValue()));
    }

    public String getSellValueString(@Nonnull ItemStack heldItem) {
        EnchantValueResponse evr = this.getSellValue(new ItemStack[]{heldItem});
        if (evr.isFailure()) {
            return String.format("Error: %s", evr.getErrorMessage());
        }
        return String.format("Value: %s", this.getConsole().formatMoney(evr.getValue()));
    }

    public String[] getUpgradeValueString(@Nonnull ItemStack heldItem, @Nullable String enchantID) {
        MarketableEnchant enchantData = this.getEnchant(enchantID);
        int maxLevel = 1;
        if (enchantData != null) {
            maxLevel = enchantData.getMaxLevel() - heldItem.getEnchantmentLevel(enchantData.getEnchantment());
        }
        return ArrayUtils.strRange(1, maxLevel);
    }

    public String[] getDowngradeValueString(@Nonnull ItemStack heldItem, @Nullable String enchantID) {
        MarketableEnchant enchantData = this.getEnchant(enchantID);
        int maxLevel = 1;
        if (enchantData != null) {
            maxLevel = heldItem.getEnchantmentLevel(enchantData.getEnchantment());
        }
        return ArrayUtils.strRange(1, maxLevel);
    }

    public static Map<Enchantment, Integer> getEnchantments(@Nonnull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            return enchantmentStorageMeta.getStoredEnchants();
        }
        return itemMeta.getEnchants();
    }
}

