/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.enchants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.market.TokenValueResponse;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.enchants.MarketableEnchant;

public class EnchantValueResponse
extends TokenValueResponse {
    private Map<String, ArrayList<MarketableEnchant>> enchantMap = new ConcurrentHashMap<String, ArrayList<MarketableEnchant>>();
    private ArrayList<ItemStack> itemStacks = new ArrayList();
    private ArrayList<String> itemStackIDs = new ArrayList();
    private ArrayList<ItemStack> clones = new ArrayList();

    public EnchantValueResponse() {
    }

    public EnchantValueResponse(EconomyResponse.ResponseType type, String message) {
        super(type, message);
    }

    public EnchantValueResponse addToken(MarketableEnchant enchant, int quantity, double value, ItemStack itemStack) {
        super.addToken(enchant, quantity, value);
        return this.addItemStack(enchant, itemStack);
    }

    public EnchantValueResponse addResponse(EnchantValueResponse response) {
        for (ItemStack itemStack : response.getItemStacks()) {
            for (MarketableEnchant enchant : response.getEnchants(itemStack)) {
                this.addItemStack(enchant, itemStack);
            }
        }
        return (EnchantValueResponse)super.addResponse(response);
    }

    public Map<String, ArrayList<MarketableEnchant>> getEnchantMap() {
        return this.enchantMap;
    }

    public List<ItemStack> getClones() {
        return this.clones;
    }

    public ItemStack[] getClonesAsArray() {
        return this.clones.toArray(new ItemStack[0]);
    }

    @Nonnull
    public List<MarketableEnchant> getEnchants(ItemStack itemStack) {
        return this.enchantMap.getOrDefault(ItemManager.getOrSetIdentity(itemStack), new ArrayList());
    }

    public List<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public ItemStack[] getItemStacksAsArray() {
        return this.itemStacks.toArray(new ItemStack[0]);
    }

    private EnchantValueResponse addItemStack(MarketableEnchant enchant, ItemStack itemStack) {
        String identity = ItemManager.getOrSetIdentity(itemStack);
        ArrayList<MarketableEnchant> enchants = this.enchantMap.getOrDefault(identity, new ArrayList());
        enchants.add(enchant);
        this.enchantMap.put(identity, enchants);
        if (!this.itemStackIDs.contains(identity)) {
            this.itemStacks.add(itemStack);
            this.itemStackIDs.add(identity);
            this.clones.add(ItemManager.clone(itemStack));
        }
        return this;
    }
}

