/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials;

import java.util.HashSet;
import java.util.Set;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.DivinityModule;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public class MarketManager
extends DivinityModule {
    private final Set<MaterialManager> managers = new HashSet<MaterialManager>();

    public MarketManager(DEPlugin main) {
        super(main, false);
    }

    public void addManager(MaterialManager manager) {
        this.managers.add(manager);
    }

    public void removeManager(MaterialManager manager) {
        this.managers.remove(manager);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void deinit() {
    }

    public MarketableMaterial getItem(ItemStack itemStack) {
        MarketableMaterial material = null;
        for (MaterialManager man : this.managers) {
            material = man.getItem(itemStack);
            if (material == null) continue;
            this.getConsole().debug("Market Manager for '%s'(%s) = %s", itemStack, material.getID(), material.getManager().getClass().getCanonicalName());
            break;
        }
        return material;
    }

    public MarketableMaterial getItem(String alias) {
        MarketableMaterial material = null;
        for (MaterialManager man : this.managers) {
            material = man.getItem(alias);
            if (material == null) continue;
            this.getConsole().debug("Market Manager for '%s'(%s) = %s", alias, material.getID(), material.getManager().getClass().getCanonicalName());
            break;
        }
        return material;
    }

    public Set<String> getItemNames() {
        HashSet<String> itemNames = new HashSet<String>();
        this.managers.forEach(man -> itemNames.addAll(man.getItemNames()));
        return itemNames;
    }

    public Set<String> getItemNames(String startsWith) {
        HashSet<String> itemNames = new HashSet<String>();
        this.managers.forEach(man -> itemNames.addAll(man.getItemNames(startsWith)));
        return itemNames;
    }

    public Set<String> getItemNames(Set<String> itemIDs) {
        HashSet<String> itemNames = new HashSet<String>();
        this.managers.forEach(man -> itemNames.addAll(man.getItemNames(itemIDs)));
        return itemNames;
    }

    public Set<String> getItemNames(Set<String> itemIds, String startWith) {
        return this.searchItemNames(this.getItemNames(itemIds), startWith.toLowerCase());
    }

    public Set<String> searchItemNames(Set<String> items, String term) {
        HashSet<String> itemNames = new HashSet<String>();
        for (MaterialManager man : this.managers) {
            itemNames.addAll(man.searchItemNames(items, term));
        }
        return itemNames;
    }

    public Set<String> searchItemNames(String term) {
        HashSet<String> strings = new HashSet<String>();
        this.managers.forEach(manager -> strings.addAll(manager.searchItemNames(manager.getItemIDs(), term)));
        return strings;
    }

    public MaterialValueResponse getSellValue(ItemStack[] itemStacks) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        for (ItemStack itemStack : itemStacks) {
            MarketableMaterial marketableMaterial = this.getItem(itemStack);
            if (marketableMaterial == null) {
                return (MaterialValueResponse)response.setFailure(String.format("item does not exist '%s'", itemStack.getType().name()));
            }
            MaterialValueResponse thisResponse = (MaterialValueResponse)marketableMaterial.getManager().getSellValue(itemStack, itemStack.getAmount());
            if (thisResponse.isFailure()) continue;
            response.addResponse(thisResponse);
        }
        return response;
    }

    public String getName(ItemStack itemStack) {
        MarketableMaterial marketableMaterial = this.getItem(itemStack);
        if (marketableMaterial == null) {
            return itemStack.getType().name();
        }
        return marketableMaterial.getName();
    }

    public double getInflation() {
        double inflation = 0.0;
        for (MaterialManager manager : this.managers) {
            inflation += manager.getInflation();
        }
        return Converter.constrainDouble(inflation * 100.0 / (double)this.managers.size(), 0.0, 100.0);
    }
}

