/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.MarketableToken;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.MarketableItem;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.utils.Converter;

public abstract class MaterialManager
extends ItemManager {
    public MaterialManager(DEPlugin main, String itemFile, String aliasFile, Map<String, ? extends MarketableMaterial> itemMap) {
        super(main, itemFile, aliasFile, (Map<String, ? extends MarketableItem>)itemMap);
    }

    @Override
    public void init() {
        this.saveMessagesDisabled = this.getConfMan().getBoolean(Setting.IGNORE_SAVE_MESSAGE_BOOLEAN);
        this.buyScale = this.getConfMan().getDouble(Setting.MARKET_MATERIALS_BUY_TAX_FLOAT);
        this.sellScale = this.getConfMan().getDouble(Setting.MARKET_MATERIALS_SELL_TAX_FLOAT);
        this.baseQuantity = this.getConfMan().getInt(Setting.MARKET_MATERIALS_BASE_QUANTITY_INTEGER).intValue();
        this.dynamicPricing = this.getConfMan().getBoolean(Setting.MARKET_MATERIALS_DYN_PRICING_BOOLEAN);
        this.wholeMarketInflation = this.getConfMan().getBoolean(Setting.MARKET_MATERIALS_WHOLE_MARKET_INF_BOOLEAN);
        this.maxItemValue = this.getConfMan().getDouble(Setting.MARKET_MAX_ITEM_VALUE_DOUBLE);
        this.ignoreNamedItems = this.getConfMan().getBoolean(Setting.MARKET_MATERIALS_IGNORE_NAMED_ITEMS_BOOLEAN);
        if (this.maxItemValue < 0.0) {
            this.maxItemValue = Double.MAX_VALUE;
        }
        this.minItemValue = this.getConfMan().getDouble(Setting.MARKET_MIN_ITEM_VALUE_DOUBLE);
        if (this.minItemValue < 0.0) {
            this.minItemValue = Double.MIN_VALUE;
        }
        int timer = Converter.getTicks(this.getConfMan().getInt(Setting.MARKET_SAVE_TIMER_INTEGER));
        this.saveTimer = new BukkitRunnable(){

            public void run() {
                MaterialManager.this.saveItems();
            }
        };
        this.saveTimer.runTaskTimerAsynchronously((Plugin)this.getMain(), (long)timer, (long)timer);
        this.loadItems();
        this.loadAliases();
        this.getMarkMan().addManager(this);
    }

    @Override
    public void deinit() {
        this.saveTimer.cancel();
        this.saveItems();
        this.getMarkMan().removeManager(this);
    }

    @Override
    public Set<String> getItemNames(ItemStack itemStack) {
        return this.getItemNames(this.getItem(itemStack).getID());
    }

    @Override
    public Set<String> getItemNames(ItemStack itemStack, String startswith) {
        return this.searchItemNames(this.getItemNames(itemStack), startswith);
    }

    @Override
    public MarketableMaterial getItem(String alias) {
        return (MarketableMaterial)super.getItem(alias);
    }

    public MarketableMaterial getItem(ItemStack itemStack) {
        for (MarketableToken thisMat : this.itemMap.values()) {
            MarketableMaterial genMat = (MarketableMaterial)thisMat;
            if (!genMat.equals(itemStack)) continue;
            return genMat;
        }
        return null;
    }

    @Override
    public MaterialValueResponse getSellValue(ItemStack[] itemStacks) {
        if (itemStacks.length == 0) {
            return new MaterialValueResponse(EconomyResponse.ResponseType.FAILURE, LangEntry.MARKET_NoItemsToSell.get(this.getMain()));
        }
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        for (ItemStack itemStack : itemStacks) {
            MaterialValueResponse thisResponse = (MaterialValueResponse)this.getSellValue(itemStack, itemStack.getAmount());
            if (thisResponse.isFailure()) continue;
            response.addResponse(thisResponse);
        }
        return response;
    }

    @Override
    public MaterialValueResponse getBuyValue(ItemStack[] itemStacks) {
        if (itemStacks.length == 0) {
            return new MaterialValueResponse(EconomyResponse.ResponseType.FAILURE, LangEntry.MARKET_NoItemsToBuy.get(this.getMain()));
        }
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        for (ItemStack itemStack : itemStacks) {
            MaterialValueResponse thisResponse = (MaterialValueResponse)this.getBuyValue(itemStack, itemStack.getAmount());
            if (thisResponse.isFailure()) continue;
            response.addResponse(thisResponse);
        }
        return response;
    }

    public void checkLoadedItems() {
        for (String key : this.getLocalKeys()) {
            if (this.config.contains(key)) continue;
            this.getConsole().warn("Item '%s' is missing from the config, consider adding this item to the market.", key);
        }
    }

    public Set<String> getLocalKeys() {
        return new HashSet<String>();
    }
}

