/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.block;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.config.Setting;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.ItemManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.market.items.materials.block.MarketableBlock;

public class BlockManager
extends MaterialManager {
    public static final String materialsFile = "materials.yml";
    public static final String aliasesFile = "materialAliases.yml";
    private boolean itemDmgScaling = false;

    public BlockManager(DEPlugin main) {
        super(main, materialsFile, aliasesFile, new ConcurrentHashMap());
    }

    private static double getDamageValue(ItemStack itemStack) {
        double damageValue = 1.0;
        Damageable dmg = (Damageable)itemStack.getItemMeta();
        if (dmg == null) {
            return damageValue;
        }
        double durability = dmg.getDamage();
        double maxDurability = itemStack.getType().getMaxDurability();
        if (maxDurability > 0.0) {
            damageValue = (maxDurability - durability) / maxDurability;
        }
        return damageValue;
    }

    public MarketableBlock getMaterial(String alias) {
        return (MarketableBlock)this.getItem(alias);
    }

    @Override
    public void init() {
        super.init();
        this.itemDmgScaling = this.getConfMan().getBoolean(Setting.MARKET_MATERIALS_ITEM_DMG_SCALING_BOOLEAN);
    }

    @Override
    public Set<String> getLocalKeys() {
        HashSet<String> entityKeys = new HashSet<String>();
        for (Material type : Material.values()) {
            try {
                NamespacedKey key = type.getKey();
                entityKeys.add(key.getKey().toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entityKeys;
    }

    @Override
    public String getType() {
        return "MATERIAL";
    }

    private double getDamageScaling(ItemStack itemStack) {
        if (this.itemDmgScaling) {
            return BlockManager.getDamageValue(itemStack);
        }
        return 1.0;
    }

    @Override
    public MaterialValueResponse getSellValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        if (ItemManager.removeEnchantedItems(new ItemStack[]{itemStack}).length == 0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsEnchanted.get(this.getMain(), this.getMarkMan().getName(itemStack)));
        }
        if ((ItemManager.itemIsNamed(itemStack) || ItemManager.itemHasLore(itemStack)) && this.ignoreNamedItems) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsNamedOrLored.get(this.getMain(), this.getMarkMan().getName(itemStack)));
        }
        MarketableBlock materialData = (MarketableBlock)this.getItem(itemStack);
        if (materialData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, materialData.getQuantity(), this.sellScale * this.getDamageScaling(itemStack), false);
        response.addToken(materialData, amount, value, new ItemStack[]{itemStack});
        if (!materialData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), materialData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), materialData.getName()));
        }
        if (this.getEnchMan().isEnchanted(itemStack)) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsEnchanted.get(this.getMain(), materialData.getName()));
        }
        if ((ItemManager.itemIsNamed(itemStack) || ItemManager.itemHasLore(itemStack)) && this.ignoreNamedItems) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsNamedOrLored.get(this.getMain(), materialData.getName()));
        }
        return response;
    }

    @Override
    public MaterialValueResponse getBuyValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketableBlock materialData = (MarketableBlock)this.getItem(itemStack);
        if (materialData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, materialData.getQuantity(), this.buyScale * this.getDamageScaling(itemStack), true);
        response.addToken(materialData, amount, value, new ItemStack[]{itemStack});
        if (!materialData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), materialData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), materialData.getName()));
        }
        return response;
    }

    @Override
    public MarketableMaterial loadItem(String ID, ConfigurationSection data, ConfigurationSection defaultData) {
        return new MarketableBlock(this.getMain(), this, ID, data, defaultData);
    }
}

