/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialManager;
import org.divinitycraft.divinityeconomy.market.items.materials.MaterialValueResponse;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.MarketableEntity;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.SpawnerPlaceListener;

public class EntityManager
extends MaterialManager {
    public static final String entitiesFile = "entities.yml";
    public static final String aliasesFile = "entityAliases.yml";

    public EntityManager(DEPlugin main) {
        super(main, entitiesFile, aliasesFile, new ConcurrentHashMap());
        new SpawnerPlaceListener(main);
    }

    @Override
    public String getType() {
        return "ENTITY";
    }

    @Override
    public Set<String> getLocalKeys() {
        HashSet<String> entityKeys = new HashSet<String>();
        for (EntityType type : EntityType.values()) {
            try {
                NamespacedKey key = type.getKey();
                entityKeys.add(key.getKey().toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entityKeys;
    }

    @Override
    public MaterialValueResponse getSellValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketableEntity entityData = (MarketableEntity)this.getItem(itemStack);
        if (entityData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, entityData.getQuantity(), this.sellScale, false);
        response.addToken(entityData, amount, value, new ItemStack[]{itemStack});
        if (!entityData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), entityData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), entityData.getName()));
        }
        return response;
    }

    @Override
    public MaterialValueResponse getBuyValue(ItemStack itemStack, int amount) {
        MaterialValueResponse response = new MaterialValueResponse(EconomyResponse.ResponseType.SUCCESS, null);
        MarketableEntity entityData = (MarketableEntity)this.getItem(itemStack);
        if (entityData == null) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemCannotBeFound.get(this.getMain(), itemStack.getType().name()));
        }
        double value = this.calculatePrice(amount, entityData.getQuantity(), this.buyScale, true);
        response.addToken(entityData, amount, value, new ItemStack[]{itemStack});
        if (!entityData.getAllowed()) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsBanned.get(this.getMain(), entityData.getName()));
        }
        if (value <= 0.0) {
            return (MaterialValueResponse)response.setFailure(LangEntry.MARKET_ItemIsWorthless.get(this.getMain(), entityData.getName()));
        }
        return response;
    }

    @Override
    public MarketableMaterial loadItem(String ID, ConfigurationSection data, ConfigurationSection defaultData) {
        return new MarketableEntity(this.getMain(), this, ID, data, defaultData);
    }
}

