/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.market.items.materials.entity;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.market.items.materials.entity.NBTFuncs;

public class SpawnerPlaceListener
implements Listener {
    private final DEPlugin main;

    public SpawnerPlaceListener(DEPlugin main) {
        this.main = main;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block placedBlock = event.getBlockPlaced();
        if (placedBlock.getType() == Material.SPAWNER) {
            ItemStack itemStack = event.getItemInHand();
            ItemMeta meta = itemStack.getItemMeta();
            if (meta == null) {
                return;
            }
            if (meta instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
                BlockState blockState = placedBlock.getState();
                if (blockState instanceof CreatureSpawner) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    CreatureSpawner itemSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
                    if (!NBTFuncs.hasSpawnerTag(this.main, itemSpawner)) {
                        return;
                    }
                    NBTFuncs.unsetSpawnerTag(this.main, itemSpawner);
                    spawner.setSpawnedType(itemSpawner.getSpawnedType());
                    spawner.setDelay(itemSpawner.getDelay());
                    spawner.setMinSpawnDelay(itemSpawner.getMinSpawnDelay());
                    spawner.setMaxSpawnDelay(itemSpawner.getMaxSpawnDelay());
                    spawner.setSpawnCount(itemSpawner.getSpawnCount());
                    spawner.setMaxNearbyEntities(itemSpawner.getMaxNearbyEntities());
                    spawner.setRequiredPlayerRange(itemSpawner.getRequiredPlayerRange());
                    spawner.setSpawnRange(itemSpawner.getSpawnRange());
                    spawner.update();
                }
            }
        }
    }
}

