/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.placeholders.expansions.market;

import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.placeholders.DivinityExpansion;

public class PAPIHandEnchantValue
extends DivinityExpansion {
    public PAPIHandEnchantValue(DEPlugin main) {
        super(main, "^(raw_|)hand_(b|s)value_enchants$");
    }

    @Override
    public String getResult(OfflinePlayer player, String value) {
        boolean formatted = value.replaceFirst(this.value, "$1").isEmpty();
        boolean isPurchase = !value.replaceFirst(this.value, "$2").equals("s");
        Player onlinePlayer = player.getPlayer();
        if (onlinePlayer == null) {
            return this.returnEmpty();
        }
        ItemStack handItem = onlinePlayer.getInventory().getItemInMainHand();
        ItemStack[] handItems = new ItemStack[]{handItem};
        if (handItem.getType() == Material.AIR) {
            return this.returnEmpty();
        }
        if (handItem.getAmount() == 0) {
            return this.returnEmpty();
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(handItem);
        if (marketableMaterial == null) {
            return this.returnEmpty();
        }
        EnchantValueResponse enchantResponse = isPurchase ? this.getMain().getEnchMan().getBuyValue(handItems) : this.getMain().getEnchMan().getSellValue(handItems);
        if (enchantResponse.isFailure()) {
            return this.returnEmpty();
        }
        if (formatted) {
            return this.getMain().getConsole().formatMoney(enchantResponse.getValue());
        }
        return String.format("%,.2f", enchantResponse.getValue());
    }

    public String returnEmpty() {
        return LangEntry.W_empty.get(this.getMain());
    }
}

