/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.placeholders.expansions.market;

import java.math.BigDecimal;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.market.TokenValueResponse;
import org.divinitycraft.divinityeconomy.market.items.enchants.EnchantValueResponse;
import org.divinitycraft.divinityeconomy.market.items.materials.MarketableMaterial;
import org.divinitycraft.divinityeconomy.placeholders.DivinityExpansion;

public class PAPIHandTotalValue
extends DivinityExpansion {
    public PAPIHandTotalValue(DEPlugin main) {
        super(main, "^(raw_|)hand_(b|s)value_total$");
    }

    @Override
    public String getResult(OfflinePlayer player, String value) {
        EnchantValueResponse enchantResponse;
        TokenValueResponse materialResponse;
        boolean formatted = value.replaceFirst(this.value, "$1").isEmpty();
        boolean isPurchase = !value.replaceFirst(this.value, "$2").equals("s");
        Player onlinePlayer = player.getPlayer();
        if (onlinePlayer == null) {
            return this.returnEmpty();
        }
        ItemStack handItem = onlinePlayer.getInventory().getItemInMainHand();
        ItemStack[] handItems = new ItemStack[]{handItem};
        if (handItem.getType() == Material.AIR) {
            return this.returnEmpty();
        }
        if (handItem.getAmount() == 0) {
            return this.returnEmpty();
        }
        MarketableMaterial marketableMaterial = this.getMain().getMarkMan().getItem(handItem);
        if (marketableMaterial == null) {
            return this.returnEmpty();
        }
        if (isPurchase) {
            materialResponse = marketableMaterial.getManager().getBuyValue(handItem, handItem.getAmount());
            enchantResponse = this.getMain().getEnchMan().getBuyValue(handItems);
        } else {
            materialResponse = marketableMaterial.getManager().getSellValue(handItem, handItem.getAmount());
            enchantResponse = this.getMain().getEnchMan().getSellValue(handItems);
        }
        if (materialResponse.isFailure() & enchantResponse.isFailure()) {
            return this.returnEmpty();
        }
        BigDecimal totalValue = new BigDecimal("0.00");
        totalValue = totalValue.add(BigDecimal.valueOf(materialResponse.getValue()));
        totalValue = totalValue.add(BigDecimal.valueOf(enchantResponse.getValue()));
        if (formatted) {
            return this.getMain().getConsole().formatMoney(totalValue.doubleValue());
        }
        return String.format("%,.2f", totalValue.doubleValue());
    }

    public String returnEmpty() {
        return LangEntry.W_empty.get(this.getMain());
    }
}

