/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.response;

import javax.annotation.Nonnull;
import net.milkbowl.vault.economy.EconomyResponse;
import org.divinitycraft.divinityeconomy.response.Response;

public class ValueResponse
extends Response {
    private double value = 0.0;

    public ValueResponse(double value, @Nonnull EconomyResponse.ResponseType responseType, String errorMessage) {
        super(responseType, errorMessage);
        this.value = value;
    }

    public ValueResponse(@Nonnull EconomyResponse.ResponseType responseType, String errorMessage) {
        super(responseType, errorMessage);
    }

    public ValueResponse() {
    }

    public ValueResponse(double value) {
        this.setValue(value);
    }

    public ValueResponse addResponse(ValueResponse response) {
        this.addValue(response.getValue());
        if (response.isFailure()) {
            this.setFailure(response.getErrorMessage());
        }
        return this;
    }

    public double getValue() {
        return this.value;
    }

    protected ValueResponse setValue(double value) {
        this.value = value;
        return this;
    }

    protected ValueResponse addValue(double value) {
        this.value += value;
        return this;
    }

    protected ValueResponse remValue(double value) {
        this.value -= value;
        return this;
    }

    @Override
    public String toString() {
        return String.format("ValueResponse{ type=%s, errorMessage=%s, value=%s }", this.getResponseType(), this.getErrorMessage(), this.getValue());
    }
}

