/*
 * Decompiled with CFR 0.152.
 */
package org.divinitycraft.divinityeconomy.world.events;

import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.divinitycraft.divinityeconomy.DEPlugin;
import org.divinitycraft.divinityeconomy.lang.LangEntry;
import org.divinitycraft.divinityeconomy.world.WorldManager;

public class WorldNotification
implements Listener {
    private final DEPlugin main;
    private final WorldManager worldManager;

    public WorldNotification(DEPlugin main, WorldManager worldManager) {
        this.main = main;
        this.worldManager = worldManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        this.handleEvent(player, world);
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World toWorld = player.getWorld();
        this.handleEvent(player, toWorld);
    }

    public void handleEvent(Player player, World world) {
        try {
            if (!this.main.getEconMan().getPlayer((OfflinePlayer)player).getNotification()) {
                return;
            }
            boolean marketEnabled = this.worldManager.isMarketEnabled(world);
            boolean economyEnabled = this.worldManager.isEconomyEnabled(world);
            if (marketEnabled && economyEnabled) {
                this.main.getConsole().info(player, LangEntry.WORLDS_BothEnabled.get(this.main), new Object[0]);
            } else if (marketEnabled) {
                this.main.getConsole().info(player, LangEntry.WORLDS_MarketEnabled.get(this.main), new Object[0]);
            } else if (economyEnabled) {
                this.main.getConsole().info(player, LangEntry.WORLDS_EconomyEnabled.get(this.main), new Object[0]);
            } else {
                this.main.getConsole().info(player, LangEntry.WORLDS_BothDisabled.get(this.main), new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

