/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.CloneCache;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.FunctionParameter;
import org.mariuszgromada.math.mxparser.KwTypeComparator;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.StringResources;
import org.mariuszgromada.math.mxparser.StringUtils;
import org.mariuszgromada.math.mxparser.TokenStackElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.parsertokens.BinaryRelation;
import org.mariuszgromada.math.mxparser.parsertokens.BitwiseOperator;
import org.mariuszgromada.math.mxparser.parsertokens.BooleanOperator;
import org.mariuszgromada.math.mxparser.parsertokens.CalculusOperator;
import org.mariuszgromada.math.mxparser.parsertokens.ConstantValue;
import org.mariuszgromada.math.mxparser.parsertokens.Function1Arg;
import org.mariuszgromada.math.mxparser.parsertokens.Function2Arg;
import org.mariuszgromada.math.mxparser.parsertokens.Function3Arg;
import org.mariuszgromada.math.mxparser.parsertokens.FunctionVariadic;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Operator;
import org.mariuszgromada.math.mxparser.parsertokens.ParserSymbol;
import org.mariuszgromada.math.mxparser.parsertokens.RandomVariable;
import org.mariuszgromada.math.mxparser.parsertokens.Token;
import org.mariuszgromada.math.mxparser.parsertokens.Unit;

final class ExpressionUtils {
    static final boolean LANGUAGE_SPECIFIC_DESCRIPTIONS_SET = StringModel.LANGUAGE_SPECIFIC_DESCRIPTIONS_SET;
    static List<KeyWord> baseKeyWordsListParUdfUni111;
    static List<KeyWord> baseKeyWordsListParUdfUni110;
    static List<KeyWord> baseKeyWordsListParUdfUni101;
    static List<KeyWord> baseKeyWordsListParUdfUni100;
    static List<KeyWord> baseKeyWordsListParUdfUni011;
    static List<KeyWord> baseKeyWordsListParUdfUni010;
    static List<KeyWord> baseKeyWordsListParUdfUni001;
    static List<KeyWord> baseKeyWordsListParUdfUni000;
    private static final String FUNCTION = "function";
    private static final String ARGUMENT = "argument";
    private static final String UNITCONST = "unit/const";
    private static final String ERROR = "error";
    private static final String KEY_ADVANCED_SEARCH_TAG = "key=";
    private static final String DESC_ADVANCED_SEARCH_TAG = "desc=";
    private static final String SYN_ADVANCED_SEARCH_TAG = "syn=";
    private static final String SINCE_ADVANCED_SEARCH_TAG = "since=";
    private static final String KEYID_ADVANCED_SEARCH_TAG = "keyid=";
    private static final String TYPEID_ADVANCED_SEARCH_TAG = "typeid=";
    private static final String TYPE_ADVANCED_SEARCH_TAG = "type=";

    ExpressionUtils() {
    }

    static void addUDFSpecificParserKeyWords(List<KeyWord> keyWordsList) {
        ExpressionUtils.addKeyWord("par", Function1Arg.PARAM_DESC, 63, Function1Arg.PARAM_SYN, "4.2", 4, keyWordsList);
        ExpressionUtils.addKeyWord("[npar]", ConstantValue.NPAR_DESC, 303, "[npar]", "4.2", 9, keyWordsList);
    }

    static void addArgumentsKeyWords(List<Argument> argumentsList, List<KeyWord> keyWordsList) {
        int argumentsNumber = argumentsList.size();
        for (int argumentIndex = 0; argumentIndex < argumentsNumber; ++argumentIndex) {
            Argument arg = argumentsList.get(argumentIndex);
            if (arg.getArgumentType() != 3) {
                ExpressionUtils.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, arg.getArgumentName(), "", 101, keyWordsList);
                continue;
            }
            ExpressionUtils.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, arg.getArgumentName() + "(n)", "", 102, keyWordsList);
        }
    }

    static void addFunctionsKeyWords(List<Function> functionsList, List<KeyWord> keyWordsList) {
        int functionsNumber = functionsList.size();
        for (int functionIndex = 0; functionIndex < functionsNumber; ++functionIndex) {
            Function fun = functionsList.get(functionIndex);
            StringBuilder syntax = new StringBuilder(fun.getFunctionName());
            syntax.append("(");
            int paramsNum = fun.getParametersNumber();
            for (int i = 0; i < paramsNum; ++i) {
                syntax.append(fun.getParameterName(i));
                if (paramsNum <= 1 || i >= paramsNum - 1) continue;
                syntax.append(",");
            }
            syntax.append(")");
            ExpressionUtils.addKeyWord(fun.getFunctionName(), fun.getDescription(), functionIndex, syntax.toString(), "", 103, keyWordsList);
        }
    }

    static void addConstantsKeyWords(List<Constant> constantsList, List<KeyWord> keyWordsList) {
        int constantsNumber = constantsList.size();
        for (int constantIndex = 0; constantIndex < constantsNumber; ++constantIndex) {
            Constant c = constantsList.get(constantIndex);
            ExpressionUtils.addKeyWord(c.getConstantName(), c.getDescription(), constantIndex, c.getConstantName(), "", 104, keyWordsList);
        }
    }

    static void addKeyWord(String wordString, String wordDescription, int wordId, String wordSyntax, String wordSince, int wordTypeId, List<KeyWord> keyWordsList) {
        keyWordsList.add(new KeyWord(wordString, wordDescription, wordId, wordSyntax, wordSince, wordTypeId));
    }

    static void addKeyWordUnicode(String wordString, String wordDescription, int wordId, String wordSyntax, String wordSince, int wordTypeId, boolean unicodeKeyWordsEnabled, List<KeyWord> keyWordsList) {
        if (unicodeKeyWordsEnabled) {
            ExpressionUtils.addKeyWord(wordString, wordDescription + ParserSymbol.UNICODE_MATH_DESC, wordId, wordSyntax, wordSince, wordTypeId, keyWordsList);
        }
    }

    static void addParserKeyWords(boolean parserKeyWordsOnly, boolean UDFExpression, boolean unicodeKeyWordsEnabled, List<KeyWord> keyWordsList) {
        List<KeyWord> baseKeyWordsList = ExpressionUtils.getBaseKeyWordsList(parserKeyWordsOnly, UDFExpression, unicodeKeyWordsEnabled);
        keyWordsList.addAll(baseKeyWordsList);
    }

    static List<KeyWord> getBaseKeyWordsList(boolean parserKeyWordsOnly, boolean UDFExpression, boolean unicodeKeyWordsEnabled) {
        if (parserKeyWordsOnly && UDFExpression && unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni111;
        }
        if (parserKeyWordsOnly && UDFExpression && !unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni110;
        }
        if (parserKeyWordsOnly && !UDFExpression && unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni101;
        }
        if (parserKeyWordsOnly && !UDFExpression && !unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni100;
        }
        if (!parserKeyWordsOnly && UDFExpression && unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni011;
        }
        if (!parserKeyWordsOnly && UDFExpression && !unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni010;
        }
        if (!parserKeyWordsOnly && !UDFExpression && unicodeKeyWordsEnabled) {
            return baseKeyWordsListParUdfUni001;
        }
        return baseKeyWordsListParUdfUni000;
    }

    static void makeAllParserKeyWords() {
        baseKeyWordsListParUdfUni111 = ExpressionUtils.makeParserKeyWords(true, true, true);
        baseKeyWordsListParUdfUni110 = ExpressionUtils.makeParserKeyWords(true, true, false);
        baseKeyWordsListParUdfUni101 = ExpressionUtils.makeParserKeyWords(true, false, true);
        baseKeyWordsListParUdfUni100 = ExpressionUtils.makeParserKeyWords(true, false, false);
        baseKeyWordsListParUdfUni011 = ExpressionUtils.makeParserKeyWords(false, true, true);
        baseKeyWordsListParUdfUni010 = ExpressionUtils.makeParserKeyWords(false, true, false);
        baseKeyWordsListParUdfUni001 = ExpressionUtils.makeParserKeyWords(false, false, true);
        baseKeyWordsListParUdfUni000 = ExpressionUtils.makeParserKeyWords(false, false, false);
    }

    static List<KeyWord> makeParserKeyWords(boolean parserKeyWordsOnly, boolean UDFExpression, boolean unicodeKeyWordsEnabled) {
        ArrayList<KeyWord> keyWordsList = new ArrayList<KeyWord>();
        ExpressionUtils.makeParserKeyWords(parserKeyWordsOnly, UDFExpression, unicodeKeyWordsEnabled, keyWordsList);
        return keyWordsList;
    }

    private static void makeParserKeyWords(boolean parserKeyWordsOnly, boolean UDFExpression, boolean unicodeKeyWordsEnabled, List<KeyWord> keyWordsList) {
        ExpressionUtils.addKeyWord("+", Operator.PLUS_DESC, 1, Operator.PLUS_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("-", Operator.MINUS_DESC, 2, Operator.MINUS_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("*", Operator.MULTIPLY_DESC, 3, Operator.MULTIPLY_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00d7", Operator.MULTIPLY_DESC, 3, Operator.MULTIPLY_SYN_UNI_1, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2a09", Operator.MULTIPLY_DESC, 3, Operator.MULTIPLY_SYN_UNI_2, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2219", Operator.MULTIPLY_DESC, 3, Operator.MULTIPLY_SYN_UNI_3, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("/", Operator.DIVIDE_DESC, 4, Operator.DIVIDE_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord(":", Operator.DIVIDE_DESC, 4, Operator.DIVIDE_EUROPE_SYN, "6.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("\\", Operator.DIVIDE_QUOTIENT_DESC, 13, Operator.DIVIDE_QUOTIENT_SYN, "6.0", 1, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00f7", Operator.DIVIDE_DESC, 4, Operator.DIVIDE_SYN_UNI_1, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("^", Operator.POWER_DESC, 5, Operator.POWER_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("!", Operator.FACT_DESC, 6, Operator.FACT_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("#", Operator.MOD_DESC, 7, Operator.MOD_SYN, "1.0", 1, keyWordsList);
        ExpressionUtils.addKeyWord("%", Operator.PERC_DESC, 8, Operator.PERC_SYN, "4.1", 1, keyWordsList);
        ExpressionUtils.addKeyWord("^^", Operator.TETRATION_DESC, 9, Operator.TETRATION_SYN, "4.2", 1, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u221a", Operator.SQUARE_ROOT_DESC, 10, Operator.SQUARE_ROOT_SYN, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u221b", Operator.CUBE_ROOT_DESC, 11, Operator.CUBE_ROOT_SYN, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u221c", Operator.FOURTH_ROOT_DESC, 12, Operator.FOURTH_ROOT_SYN, "5.0", 1, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("~", BooleanOperator.NEG_DESC, 11, BooleanOperator.NEG_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac", BooleanOperator.NEG_DESC, 11, BooleanOperator.NEG_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("&", BooleanOperator.AND_DESC, 1, BooleanOperator.AND_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2227", BooleanOperator.AND_DESC, 1, BooleanOperator.AND_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("&&", BooleanOperator.AND_DESC, 1, BooleanOperator.AND1_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("/\\", BooleanOperator.AND_DESC, 1, BooleanOperator.AND2_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("~&", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("~&&", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND1_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("~/\\", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND2_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("~\u2227", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac&", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_2, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac&&", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_3, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac/\\", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_4, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac\u2227", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_5, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u22bc", BooleanOperator.NAND_DESC, 2, BooleanOperator.NAND_SYN_UNI_6, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("|", BooleanOperator.OR_DESC, 3, BooleanOperator.OR_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("||", BooleanOperator.OR_DESC, 3, BooleanOperator.OR1_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("\\/", BooleanOperator.OR_DESC, 3, BooleanOperator.OR2_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2228", BooleanOperator.OR_DESC, 3, BooleanOperator.OR_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("~|", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("~||", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR1_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWord("~\\/", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR2_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("~\u2228", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac|", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_2, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac||", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_3, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac\\/", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_4, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u00ac\u2228", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_5, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u22bd", BooleanOperator.NOR_DESC, 4, BooleanOperator.NOR_SYN_UNI_6, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("(+)", BooleanOperator.XOR_DESC, 5, BooleanOperator.XOR_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u22bb", BooleanOperator.XOR_DESC, 5, BooleanOperator.XOR_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("-->", BooleanOperator.IMP_DESC, 6, BooleanOperator.IMP_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u21d2", BooleanOperator.IMP_DESC, 6, BooleanOperator.IMP_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("-/>", BooleanOperator.NIMP_DESC, 8, BooleanOperator.NIMP_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u21cf", BooleanOperator.NIMP_DESC, 8, BooleanOperator.NIMP_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("<--", BooleanOperator.CIMP_DESC, 7, BooleanOperator.CIMP_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u21d0", BooleanOperator.CIMP_DESC, 7, BooleanOperator.CIMP_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("</-", BooleanOperator.CNIMP_DESC, 9, BooleanOperator.CNIMP_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u21cd", BooleanOperator.CNIMP_DESC, 9, BooleanOperator.CNIMP_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("<->", BooleanOperator.EQV_DESC, 10, BooleanOperator.EQV_SYN, "1.0", 2, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u21d4", BooleanOperator.EQV_DESC, 10, BooleanOperator.EQV_SYN_UNI_1, "5.0", 2, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("=", BinaryRelation.EQ_DESC, 1, BinaryRelation.EQ_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord("==", BinaryRelation.EQ_DESC, 1, BinaryRelation.EQ1_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord("<>", BinaryRelation.NEQ_DESC, 2, BinaryRelation.NEQ_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2260", BinaryRelation.NEQ_DESC, 2, BinaryRelation.NEQ_SYN_UNI_1, "5.0", 3, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord("~=", BinaryRelation.NEQ_DESC, 2, BinaryRelation.NEQ1_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord("!=", BinaryRelation.NEQ_DESC, 2, BinaryRelation.NEQ2_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord("<", BinaryRelation.LT_DESC, 3, BinaryRelation.LT_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord(">", BinaryRelation.GT_DESC, 4, BinaryRelation.GT_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWord("<=", BinaryRelation.LEQ_DESC, 5, BinaryRelation.LEQ_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2264", BinaryRelation.LEQ_DESC, 5, BinaryRelation.LEQ_SYN_UNI_1, "5.0", 3, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u22dc", BinaryRelation.LEQ_DESC, 5, BinaryRelation.LEQ_SYN_UNI_2, "5.0", 3, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWord(">=", BinaryRelation.GEQ_DESC, 6, BinaryRelation.GEQ_SYN, "1.0", 3, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u2265", BinaryRelation.GEQ_DESC, 6, BinaryRelation.GEQ_SYN_UNI_1, "5.0", 3, unicodeKeyWordsEnabled, keyWordsList);
        ExpressionUtils.addKeyWordUnicode("\u22dd", BinaryRelation.GEQ_DESC, 6, BinaryRelation.GEQ_SYN_UNI_2, "5.0", 3, unicodeKeyWordsEnabled, keyWordsList);
        if (!parserKeyWordsOnly) {
            ExpressionUtils.addKeyWord("sin", Function1Arg.SIN_DESC, 1, Function1Arg.SIN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("cos", Function1Arg.COS_DESC, 2, Function1Arg.COS_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("tan", Function1Arg.TAN_DESC, 3, Function1Arg.TAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("tg", Function1Arg.TAN_DESC, 3, Function1Arg.TG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ctan", Function1Arg.CTAN_DESC, 4, Function1Arg.CTAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ctg", Function1Arg.CTAN_DESC, 4, Function1Arg.CTG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("cot", Function1Arg.CTAN_DESC, 4, Function1Arg.COT_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sec", Function1Arg.SEC_DESC, 5, Function1Arg.SEC_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("cosec", Function1Arg.COSEC_DESC, 6, Function1Arg.COSEC_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("csc", Function1Arg.COSEC_DESC, 6, Function1Arg.CSC_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("asin", Function1Arg.ASIN_DESC, 7, Function1Arg.ASIN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arsin", Function1Arg.ASIN_DESC, 7, Function1Arg.ARSIN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcsin", Function1Arg.ASIN_DESC, 7, Function1Arg.ARCSIN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acos", Function1Arg.ACOS_DESC, 8, Function1Arg.ACOS_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcos", Function1Arg.ACOS_DESC, 8, Function1Arg.ARCOS_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccos", Function1Arg.ACOS_DESC, 8, Function1Arg.ARCCOS_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("atan", Function1Arg.ATAN_DESC, 9, Function1Arg.ATAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arctan", Function1Arg.ATAN_DESC, 9, Function1Arg.ARCTAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("atg", Function1Arg.ATAN_DESC, 9, Function1Arg.ATG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arctg", Function1Arg.ATAN_DESC, 9, Function1Arg.ARCTG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("actan", Function1Arg.ACTAN_DESC, 10, Function1Arg.ACTAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcctan", Function1Arg.ACTAN_DESC, 10, Function1Arg.ARCCTAN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("actg", Function1Arg.ACTAN_DESC, 10, Function1Arg.ACTG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcctg", Function1Arg.ACTAN_DESC, 10, Function1Arg.ARCCTG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acot", Function1Arg.ACTAN_DESC, 10, Function1Arg.ACOT_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccot", Function1Arg.ACTAN_DESC, 10, Function1Arg.ARCCOT_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ln", Function1Arg.LN_DESC, 11, Function1Arg.LN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("log2", Function1Arg.LOG2_DESC, 12, Function1Arg.LOG2_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("log10", Function1Arg.LOG10_DESC, 13, Function1Arg.LOG10_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("lg", Function1Arg.LOG10_DESC, 13, Function1Arg.LOG10_SYN_LG, "5.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("rad", Function1Arg.RAD_DESC, 14, Function1Arg.RAD_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("exp", Function1Arg.EXP_DESC, 15, Function1Arg.EXP_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sqrt", Function1Arg.SQRT_DESC, 16, Function1Arg.SQRT_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sinh", Function1Arg.SINH_DESC, 17, Function1Arg.SINH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("cosh", Function1Arg.COSH_DESC, 18, Function1Arg.COSH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("tanh", Function1Arg.TANH_DESC, 19, Function1Arg.TANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("tgh", Function1Arg.TANH_DESC, 19, Function1Arg.TGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ctanh", Function1Arg.COTH_DESC, 20, Function1Arg.CTANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("coth", Function1Arg.COTH_DESC, 20, Function1Arg.COTH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ctgh", Function1Arg.COTH_DESC, 20, Function1Arg.CTGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sech", Function1Arg.SECH_DESC, 21, Function1Arg.SECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("csch", Function1Arg.CSCH_DESC, 22, Function1Arg.CSCH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("cosech", Function1Arg.CSCH_DESC, 22, Function1Arg.COSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("deg", Function1Arg.DEG_DESC, 23, Function1Arg.DEG_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("abs", Function1Arg.ABS_DESC, 24, Function1Arg.ABS_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sgn", Function1Arg.SGN_DESC, 25, Function1Arg.SGN_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("floor", Function1Arg.FLOOR_DESC, 26, Function1Arg.FLOOR_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ceil", Function1Arg.CEIL_DESC, 27, Function1Arg.CEIL_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("not", Function1Arg.NOT_DESC, 29, Function1Arg.NOT_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("asinh", Function1Arg.ARSINH_DESC, 30, Function1Arg.ASINH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arsinh", Function1Arg.ARSINH_DESC, 30, Function1Arg.ARSINH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcsinh", Function1Arg.ARSINH_DESC, 30, Function1Arg.ARCSINH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acosh", Function1Arg.ARCOSH_DESC, 31, Function1Arg.ACOSH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcosh", Function1Arg.ARCOSH_DESC, 31, Function1Arg.ARCOSH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccosh", Function1Arg.ARCOSH_DESC, 31, Function1Arg.ARCCOSH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("atanh", Function1Arg.ARTANH_DESC, 32, Function1Arg.ATANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arctanh", Function1Arg.ARTANH_DESC, 32, Function1Arg.ARCTANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("atgh", Function1Arg.ARTANH_DESC, 32, Function1Arg.ATGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arctgh", Function1Arg.ARTANH_DESC, 32, Function1Arg.ARCTGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("actanh", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ACTANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcctanh", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ARCCTANH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acoth", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ACOTH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcoth", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ARCOTH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccoth", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ARCCOTH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("actgh", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ACTGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcctgh", Function1Arg.ARCOTH_DESC, 33, Function1Arg.ARCCTGH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("asech", Function1Arg.ARSECH_DESC, 34, Function1Arg.ASECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arsech", Function1Arg.ARSECH_DESC, 34, Function1Arg.ARSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcsech", Function1Arg.ARSECH_DESC, 34, Function1Arg.ARCSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acsch", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ACSCH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcsch", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ARCSCH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccsch", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ARCCSCH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("acosech", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ACOSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcosech", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ARCOSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccosech", Function1Arg.ARCSCH_DESC, 35, Function1Arg.ARCCOSECH_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sinc", Function1Arg.SA_DESC, 36, Function1Arg.SA_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Sa", Function1Arg.SA_DESC, 36, Function1Arg.SA1_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Sinc", Function1Arg.SINC_DESC, 37, Function1Arg.SINC_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Bell", Function1Arg.BELL_NUMBER_DESC, 38, Function1Arg.BELL_NUMBER_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Fib", Function1Arg.FIBONACCI_NUMBER_DESC, 40, Function1Arg.FIBONACCI_NUMBER_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Luc", Function1Arg.LUCAS_NUMBER_DESC, 39, Function1Arg.LUCAS_NUMBER_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("harm", Function1Arg.HARMONIC_NUMBER_DESC, 41, Function1Arg.HARMONIC_NUMBER_SYN, "1.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ispr", Function1Arg.IS_PRIME_DESC, 42, Function1Arg.IS_PRIME_SYN, "2.3", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Pi", Function1Arg.PRIME_COUNT_DESC, 43, Function1Arg.PRIME_COUNT_SYN, "2.3", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Ei", Function1Arg.EXP_INT_DESC, 44, Function1Arg.EXP_INT_SYN, "2.3", 4, keyWordsList);
            ExpressionUtils.addKeyWord("li", Function1Arg.LOG_INT_DESC, 45, Function1Arg.LOG_INT_SYN, "2.3", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Li", Function1Arg.OFF_LOG_INT_DESC, 46, Function1Arg.OFF_LOG_INT_SYN, "2.3", 4, keyWordsList);
            ExpressionUtils.addKeyWord("erf", Function1Arg.GAUSS_ERF_DESC, 47, Function1Arg.GAUSS_ERF_SYN, "3.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("erfc", Function1Arg.GAUSS_ERFC_DESC, 48, Function1Arg.GAUSS_ERFC_SYN, "3.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("erfInv", Function1Arg.GAUSS_ERF_INV_DESC, 49, Function1Arg.GAUSS_ERF_INV_SYN, "3.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("erfcInv", Function1Arg.GAUSS_ERFC_INV_DESC, 50, Function1Arg.GAUSS_ERFC_INV_SYN, "3.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ulp", Function1Arg.ULP_DESC, 51, Function1Arg.ULP_SYN, "3.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("isNaN", Function1Arg.ISNAN_DESC, 52, Function1Arg.ISNAN_SYN, "4.1", 4, keyWordsList);
            ExpressionUtils.addKeyWord("ndig10", Function1Arg.NDIG10_DESC, 53, Function1Arg.NDIG10_SYN, "4.1", 4, keyWordsList);
            ExpressionUtils.addKeyWord("nfact", Function1Arg.NFACT_DESC, 54, Function1Arg.NFACT_SYN, "4.1", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arcsec", Function1Arg.ARCSEC_DESC, 55, Function1Arg.ARCSEC_SYN, "4.1", 4, keyWordsList);
            ExpressionUtils.addKeyWord("arccsc", Function1Arg.ARCCSC_DESC, 56, Function1Arg.ARCCSC_SYN, "4.1", 4, keyWordsList);
            ExpressionUtils.addKeyWord("Gamma", Function1Arg.GAMMA_DESC, 57, Function1Arg.GAMMA_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("LambW0", Function1Arg.LAMBERT_W0_DESC, 58, Function1Arg.LAMBERT_W0_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("LambW1", Function1Arg.LAMBERT_W1_DESC, 59, Function1Arg.LAMBERT_W1_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("sgnGamma", Function1Arg.SGN_GAMMA_DESC, 60, Function1Arg.SGN_GAMMA_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("logGamma", Function1Arg.LOG_GAMMA_DESC, 61, Function1Arg.LOG_GAMMA_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("diGamma", Function1Arg.DI_GAMMA_DESC, 62, Function1Arg.DI_GAMMA_SYN, "4.2", 4, keyWordsList);
            ExpressionUtils.addKeyWord("rStud", Function1Arg.RND_STUDENT_T_DESC, 64, Function1Arg.RND_STUDENT_T_SYN, "5.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("rChi2", Function1Arg.RND_CHI2_DESC, 65, Function1Arg.RND_CHI2_SYN, "5.0", 4, keyWordsList);
            ExpressionUtils.addKeyWord("log", Function2Arg.LOG_DESC, 1, Function2Arg.LOG_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("mod", Function2Arg.MOD_DESC, 2, Function2Arg.MOD_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("C", Function2Arg.BINOM_COEFF_DESC, 3, Function2Arg.BINOM_COEFF_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("nCk", Function2Arg.BINOM_COEFF_DESC, 3, Function2Arg.BINOM_COEFF_NCK_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Bern", Function2Arg.BERNOULLI_NUMBER_DESC, 4, Function2Arg.BERNOULLI_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Stirl1", Function2Arg.STIRLING1_NUMBER_DESC, 5, Function2Arg.STIRLING1_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Stirl2", Function2Arg.STIRLING2_NUMBER_DESC, 6, Function2Arg.STIRLING2_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Worp", Function2Arg.WORPITZKY_NUMBER_DESC, 7, Function2Arg.WORPITZKY_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Euler", Function2Arg.EULER_NUMBER_DESC, 8, Function2Arg.EULER_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("KDelta", Function2Arg.KRONECKER_DELTA_DESC, 9, Function2Arg.KRONECKER_DELTA_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("EulerPol", Function2Arg.EULER_POLYNOMIAL_DESC, 10, Function2Arg.EULER_POLYNOMIAL_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Harm", Function2Arg.HARMONIC_NUMBER_DESC, 11, Function2Arg.HARMONIC_NUMBER_SYN, "1.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("rUni", Function2Arg.RND_UNIFORM_CONT_DESC, 12, Function2Arg.RND_UNIFORM_CONT_SYN, "3.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("rUnid", Function2Arg.RND_UNIFORM_DISCR_DESC, 13, Function2Arg.RND_UNIFORM_DISCR_SYN, "3.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("round", Function2Arg.ROUND_DESC, 14, Function2Arg.ROUND_SYN, "3.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("rNor", Function2Arg.RND_NORMAL_DESC, 15, Function2Arg.RND_NORMAL_SYN, "3.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("ndig", Function2Arg.NDIG_DESC, 16, Function2Arg.NDIG_SYN, "4.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("dig10", Function2Arg.DIGIT10_DESC, 17, Function2Arg.DIGIT10_SYN, "4.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("factval", Function2Arg.FACTVAL_DESC, 18, Function2Arg.FACTVAL_SYN, "4.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("factexp", Function2Arg.FACTEXP_DESC, 19, Function2Arg.FACTEXP_SYN, "4.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("root", Function2Arg.ROOT_DESC, 20, Function2Arg.ROOT_SYN, "4.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaL", Function2Arg.INC_GAMMA_LOWER_DESC, 21, Function2Arg.INC_GAMMA_LOWER_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaU", Function2Arg.INC_GAMMA_UPPER_DESC, 22, Function2Arg.INC_GAMMA_UPPER_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaRegL", Function2Arg.REG_GAMMA_LOWER_DESC, 23, Function2Arg.REG_GAMMA_LOWER_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaRegU", Function2Arg.REG_GAMMA_UPPER_DESC, 24, Function2Arg.REG_GAMMA_UPPER_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaP", Function2Arg.REG_GAMMA_LOWER_DESC, 23, Function2Arg.REG_GAMMA_LOWER_P_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("GammaQ", Function2Arg.REG_GAMMA_UPPER_DESC, 24, Function2Arg.REG_GAMMA_UPPER_Q_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("nPk", Function2Arg.PERMUTATIONS_DESC, 25, Function2Arg.PERMUTATIONS_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("Beta", Function2Arg.BETA_DESC, 26, Function2Arg.BETA_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("logBeta", Function2Arg.LOG_BETA_DESC, 27, Function2Arg.LOG_BETA_SYN, "4.2", 5, keyWordsList);
            ExpressionUtils.addKeyWord("pStud", Function2Arg.PDF_STUDENT_T_DESC, 28, Function2Arg.PDF_STUDENT_T_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("cStud", Function2Arg.CDF_STUDENT_T_DESC, 29, Function2Arg.CDF_STUDENT_T_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("qStud", Function2Arg.QNT_STUDENT_T_DESC, 30, Function2Arg.QNT_STUDENT_T_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("pChi2", Function2Arg.PDF_CHI2_DESC, 31, Function2Arg.PDF_CHI2_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("cChi2", Function2Arg.CDF_CHI2_DESC, 32, Function2Arg.CDF_CHI2_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("qChi2", Function2Arg.QNT_CHI2_DESC, 33, Function2Arg.QNT_CHI2_SYN, "5.0", 5, keyWordsList);
            ExpressionUtils.addKeyWord("rFSned", Function2Arg.RND_F_SNEDECOR_DESC, 34, Function2Arg.RND_F_SNEDECOR_SYN, "5.1", 5, keyWordsList);
            ExpressionUtils.addKeyWord("if", Function3Arg.IF_DESC, 1, Function3Arg.IF_SYN, "1.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("chi", Function3Arg.CHI_DESC, 3, Function3Arg.CHI_SYN, "1.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("CHi", Function3Arg.CHI_LR_DESC, 4, Function3Arg.CHI_LR_SYN, "1.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("Chi", Function3Arg.CHI_L_DESC, 5, Function3Arg.CHI_L_SYN, "1.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("cHi", Function3Arg.CHI_R_DESC, 6, Function3Arg.CHI_R_SYN, "1.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("pUni", Function3Arg.PDF_UNIFORM_CONT_DESC, 7, Function3Arg.PDF_UNIFORM_CONT_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("cUni", Function3Arg.CDF_UNIFORM_CONT_DESC, 8, Function3Arg.CDF_UNIFORM_CONT_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("qUni", Function3Arg.QNT_UNIFORM_CONT_DESC, 9, Function3Arg.QNT_UNIFORM_CONT_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("pNor", Function3Arg.PDF_NORMAL_DESC, 10, Function3Arg.PDF_NORMAL_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("cNor", Function3Arg.CDF_NORMAL_DESC, 11, Function3Arg.CDF_NORMAL_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("qNor", Function3Arg.QNT_NORMAL_DESC, 12, Function3Arg.QNT_NORMAL_SYN, "3.0", 6, keyWordsList);
            ExpressionUtils.addKeyWord("dig", Function3Arg.DIGIT_DESC, 13, Function3Arg.DIGIT_SYN, "4.1", 6, keyWordsList);
            ExpressionUtils.addKeyWord("BetaInc", Function3Arg.INC_BETA_DESC, 14, Function3Arg.INC_BETA_SYN, "4.2", 6, keyWordsList);
            ExpressionUtils.addKeyWord("BetaReg", Function3Arg.REG_BETA_DESC, 15, Function3Arg.REG_BETA_SYN, "4.2", 6, keyWordsList);
            ExpressionUtils.addKeyWord("BetaI", Function3Arg.REG_BETA_DESC, 15, Function3Arg.REG_BETA_I_SYN, "4.2", 6, keyWordsList);
            ExpressionUtils.addKeyWord("pFSned", Function3Arg.PDF_F_SNEDECOR_DESC, 16, Function3Arg.PDF_F_SNEDECOR_SYN, "5.1", 6, keyWordsList);
            ExpressionUtils.addKeyWord("cFSned", Function3Arg.CDF_F_SNEDECOR_DESC, 17, Function3Arg.CDF_F_SNEDECOR_SYN, "5.1", 6, keyWordsList);
            ExpressionUtils.addKeyWord("qFSned", Function3Arg.QNT_F_SNEDECOR_DESC, 18, Function3Arg.QNT_F_SNEDECOR_SYN, "5.1", 6, keyWordsList);
            ExpressionUtils.addKeyWord("iff", FunctionVariadic.IFF_DESC, 1, FunctionVariadic.IFF_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("min", FunctionVariadic.MIN_DESC, 2, FunctionVariadic.MIN_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("max", FunctionVariadic.MAX_DESC, 3, FunctionVariadic.MAX_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("ConFrac", FunctionVariadic.CONT_FRAC_DESC, 4, FunctionVariadic.CONT_FRAC_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("ConPol", FunctionVariadic.CONT_POL_DESC, 5, FunctionVariadic.CONT_POL_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("gcd", FunctionVariadic.GCD_DESC, 6, FunctionVariadic.GCD_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("lcm", FunctionVariadic.LCM_DESC, 7, FunctionVariadic.LCM_SYN, "1.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("add", FunctionVariadic.SUM_DESC, 8, FunctionVariadic.SUM_SYN, "2.4", 7, keyWordsList);
            ExpressionUtils.addKeyWord("multi", FunctionVariadic.PROD_DESC, 9, FunctionVariadic.PROD_SYN, "2.4", 7, keyWordsList);
            ExpressionUtils.addKeyWord("mean", FunctionVariadic.AVG_DESC, 10, FunctionVariadic.AVG_SYN, "2.4", 7, keyWordsList);
            ExpressionUtils.addKeyWord("var", FunctionVariadic.VAR_DESC, 11, FunctionVariadic.VAR_SYN, "2.4", 7, keyWordsList);
            ExpressionUtils.addKeyWord("std", FunctionVariadic.STD_DESC, 12, FunctionVariadic.STD_SYN, "2.4", 7, keyWordsList);
            ExpressionUtils.addKeyWord("rList", FunctionVariadic.RND_LIST_DESC, 13, FunctionVariadic.RND_LIST_SYN, "3.0", 7, keyWordsList);
            ExpressionUtils.addKeyWord("coalesce", FunctionVariadic.COALESCE_DESC, 14, FunctionVariadic.COALESCE_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("or", FunctionVariadic.OR_DESC, 15, FunctionVariadic.OR_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("and", FunctionVariadic.AND_DESC, 16, FunctionVariadic.AND_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("xor", FunctionVariadic.XOR_DESC, 17, FunctionVariadic.XOR_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("argmin", FunctionVariadic.ARGMIN_DESC, 18, FunctionVariadic.ARGMIN_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("argmax", FunctionVariadic.ARGMAX_DESC, 19, FunctionVariadic.ARGMAX_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("med", FunctionVariadic.MEDIAN_DESC, 20, FunctionVariadic.MEDIAN_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("mode", FunctionVariadic.MODE_DESC, 21, FunctionVariadic.MODE_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("base", FunctionVariadic.BASE_DESC, 22, FunctionVariadic.BASE_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("ndist", FunctionVariadic.NDIST_DESC, 23, FunctionVariadic.NDIST_SYN, "4.1", 7, keyWordsList);
            ExpressionUtils.addKeyWord("sum", CalculusOperator.SUM_DESC, 1, CalculusOperator.SUM_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2211", CalculusOperator.SUM_DESC, 1, CalculusOperator.SUM_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u03a3", CalculusOperator.SUM_DESC, 1, CalculusOperator.SUM_SYN_UNI_2, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("prod", CalculusOperator.PROD_DESC, 3, CalculusOperator.PROD_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u220f", CalculusOperator.PROD_DESC, 3, CalculusOperator.PROD_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u213f", CalculusOperator.PROD_DESC, 3, CalculusOperator.PROD_SYN_UNI_2, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u03a0", CalculusOperator.PROD_DESC, 3, CalculusOperator.PROD_SYN_UNI_3, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("int", CalculusOperator.INT_DESC, 5, CalculusOperator.INT_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u222b", CalculusOperator.INT_DESC, 5, CalculusOperator.INT_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("der", CalculusOperator.DER_DESC, 6, CalculusOperator.DER_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2202", CalculusOperator.DER_DESC, 6, CalculusOperator.DER_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("der-", CalculusOperator.DER_LEFT_DESC, 7, CalculusOperator.DER_LEFT_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2202-", CalculusOperator.DER_LEFT_DESC, 7, CalculusOperator.DER_LEFT_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("der+", CalculusOperator.DER_RIGHT_DESC, 8, CalculusOperator.DER_RIGHT_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2202+", CalculusOperator.DER_RIGHT_DESC, 8, CalculusOperator.DER_RIGHT_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("dern", CalculusOperator.DERN_DESC, 9, CalculusOperator.DERN_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWord("diff", CalculusOperator.FORW_DIFF_DESC, 10, CalculusOperator.FORW_DIFF_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2206", CalculusOperator.FORW_DIFF_DESC, 10, CalculusOperator.FORW_DIFF_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u0394", CalculusOperator.FORW_DIFF_DESC, 10, CalculusOperator.FORW_DIFF_SYN_UNI_2, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("difb", CalculusOperator.BACKW_DIFF_DESC, 11, CalculusOperator.BACKW_DIFF_SYN, "1.0", 8, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2207", CalculusOperator.BACKW_DIFF_DESC, 11, CalculusOperator.BACKW_DIFF_SYN_UNI_1, "5.0", 8, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("avg", CalculusOperator.AVG_DESC, 12, CalculusOperator.AVG_SYN, "2.4", 8, keyWordsList);
            ExpressionUtils.addKeyWord("vari", CalculusOperator.VAR_DESC, 13, CalculusOperator.VAR_SYN, "2.4", 8, keyWordsList);
            ExpressionUtils.addKeyWord("stdi", CalculusOperator.STD_DESC, 14, CalculusOperator.STD_SYN, "2.4", 8, keyWordsList);
            ExpressionUtils.addKeyWord("mini", CalculusOperator.MIN_DESC, 15, CalculusOperator.MIN_SYN, "2.4", 8, keyWordsList);
            ExpressionUtils.addKeyWord("maxi", CalculusOperator.MAX_DESC, 16, CalculusOperator.MAX_SYN, "2.4", 8, keyWordsList);
            ExpressionUtils.addKeyWord("solve", CalculusOperator.SOLVE_DESC, 17, CalculusOperator.SOLVE_SYN, "4.0", 8, keyWordsList);
            ExpressionUtils.addKeyWord("pi", ConstantValue.PI_DESC, 1, "pi", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u03c0", ConstantValue.PI_DESC, 1, "\u03c0", "5.0", 9, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u213c", ConstantValue.PI_DESC, 1, "\u213c", "5.0", 9, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("e", ConstantValue.EULER_DESC, 2, "e", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u212f", ConstantValue.EULER_DESC, 2, "\u212f", "5.0", 9, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWordUnicode("\u2147", ConstantValue.EULER_DESC, 2, "\u2147", "5.0", 9, unicodeKeyWordsEnabled, keyWordsList);
            ExpressionUtils.addKeyWord("[gam]", ConstantValue.EULER_MASCHERONI_DESC, 3, "[gam]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[phi]", ConstantValue.GOLDEN_RATIO_DESC, 4, "[phi]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[PN]", ConstantValue.PLASTIC_DESC, 5, "[PN]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[B*]", ConstantValue.EMBREE_TREFETHEN_DESC, 6, "[B*]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[F'd]", ConstantValue.FEIGENBAUM_DELTA_DESC, 7, "[F'd]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[F'a]", ConstantValue.FEIGENBAUM_ALPHA_DESC, 8, "[F'a]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[C2]", ConstantValue.TWIN_PRIME_DESC, 9, "[C2]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[M1]", ConstantValue.MEISSEL_MERTEENS_DESC, 10, "[M1]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[B2]", ConstantValue.BRAUN_TWIN_PRIME_DESC, 11, "[B2]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[B4]", ConstantValue.BRAUN_PRIME_QUADR_DESC, 12, "[B4]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[BN'L]", ConstantValue.BRUIJN_NEWMAN_DESC, 13, "[BN'L]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Kat]", ConstantValue.CATALAN_DESC, 14, "[Kat]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[K*]", ConstantValue.LANDAU_RAMANUJAN_DESC, 15, "[K*]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[K.]", ConstantValue.VISWANATH_DESC, 16, "[K.]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[B'L]", ConstantValue.LEGENDRE_DESC, 17, "[B'L]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[RS'm]", ConstantValue.RAMANUJAN_SOLDNER_DESC, 18, "[RS'm]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[EB'e]", ConstantValue.ERDOS_BORWEIN_DESC, 19, "[EB'e]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Bern]", ConstantValue.BERNSTEIN_DESC, 20, "[Bern]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[GKW'l]", ConstantValue.GAUSS_KUZMIN_WIRSING_DESC, 21, "[GKW'l]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[HSM's]", ConstantValue.HAFNER_SARNAK_MCCURLEY_DESC, 22, "[HSM's]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[lm]", ConstantValue.GOLOMB_DICKMAN_DESC, 23, "[lm]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Cah]", ConstantValue.CAHEN_DESC, 24, "[Cah]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Ll]", ConstantValue.LAPLACE_LIMIT_DESC, 25, "[Ll]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[AG]", ConstantValue.ALLADI_GRINSTEAD_DESC, 26, "[AG]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[L*]", ConstantValue.LENGYEL_DESC, 27, "[L*]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[L.]", ConstantValue.LEVY_DESC, 28, "[L.]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Dz3]", ConstantValue.APERY_DESC, 29, "[Dz3]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[A3n]", ConstantValue.MILLS_DESC, 30, "[A3n]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Bh]", ConstantValue.BACKHOUSE_DESC, 31, "[Bh]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Pt]", ConstantValue.PORTER_DESC, 32, "[Pt]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[L2]", ConstantValue.LIEB_QUARE_ICE_DESC, 33, "[L2]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Nv]", ConstantValue.NIVEN_DESC, 34, "[Nv]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Ks]", ConstantValue.SIERPINSKI_DESC, 35, "[Ks]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Kh]", ConstantValue.KHINCHIN_DESC, 36, "[Kh]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[FR]", ConstantValue.FRANSEN_ROBINSON_DESC, 37, "[FR]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[La]", ConstantValue.LANDAU_DESC, 38, "[La]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[P2]", ConstantValue.PARABOLIC_DESC, 39, "[P2]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Om]", ConstantValue.OMEGA_DESC, 40, "[Om]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[MRB]", ConstantValue.MRB_DESC, 41, "[MRB]", "1.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[li2]", ConstantValue.LI2_DESC, 42, "[li2]", "2.3", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[EG]", ConstantValue.GOMPERTZ_DESC, 43, "[EG]", "2.3", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[c]", ConstantValue.LIGHT_SPEED_DESC, 101, "[c]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[G.]", ConstantValue.GRAVITATIONAL_CONSTANT_DESC, 102, "[G.]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[g]", ConstantValue.GRAVIT_ACC_EARTH_DESC, 103, "[g]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[hP]", ConstantValue.PLANCK_CONSTANT_DESC, 104, "[hP]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[h-]", ConstantValue.PLANCK_CONSTANT_REDUCED_DESC, 105, "[h-]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[lP]", ConstantValue.PLANCK_LENGTH_DESC, 106, "[lP]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[mP]", ConstantValue.PLANCK_MASS_DESC, 107, "[mP]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[tP]", ConstantValue.PLANCK_TIME_DESC, 108, "[tP]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[ly]", ConstantValue.LIGHT_YEAR_DESC, 201, "[ly]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[au]", ConstantValue.ASTRONOMICAL_UNIT_DESC, 202, "[au]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[pc]", ConstantValue.PARSEC_DESC, 203, "[pc]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[kpc]", ConstantValue.KILOPARSEC_DESC, 204, "[kpc]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Earth-R-eq]", ConstantValue.EARTH_RADIUS_EQUATORIAL_DESC, 205, "[Earth-R-eq]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Earth-R-po]", ConstantValue.EARTH_RADIUS_POLAR_DESC, 206, "[Earth-R-po]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Earth-R]", ConstantValue.EARTH_RADIUS_MEAN_DESC, 207, "[Earth-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Earth-M]", ConstantValue.EARTH_MASS_DESC, 208, "[Earth-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Earth-D]", ConstantValue.EARTH_SEMI_MAJOR_AXIS_DESC, 209, "[Earth-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Moon-R]", ConstantValue.MOON_RADIUS_MEAN_DESC, 210, "[Moon-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Moon-M]", ConstantValue.MOON_MASS_DESC, 211, "[Moon-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Moon-D]", ConstantValue.MOON_SEMI_MAJOR_AXIS_DESC, 212, "[Moon-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Solar-R]", ConstantValue.SOLAR_RADIUS_DESC, 213, "[Solar-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Solar-M]", ConstantValue.SOLAR_MASS_DESC, 214, "[Solar-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mercury-R]", ConstantValue.MERCURY_RADIUS_MEAN_DESC, 215, "[Mercury-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mercury-M]", ConstantValue.MERCURY_MASS_DESC, 216, "[Mercury-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mercury-D]", ConstantValue.MERCURY_SEMI_MAJOR_AXIS_DESC, 217, "[Mercury-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Venus-R]", ConstantValue.VENUS_RADIUS_MEAN_DESC, 218, "[Venus-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Venus-M]", ConstantValue.VENUS_MASS_DESC, 219, "[Venus-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Venus-D]", ConstantValue.VENUS_SEMI_MAJOR_AXIS_DESC, 220, "[Venus-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mars-R]", ConstantValue.MARS_RADIUS_MEAN_DESC, 221, "[Mars-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mars-M]", ConstantValue.MARS_MASS_DESC, 222, "[Mars-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Mars-D]", ConstantValue.MARS_SEMI_MAJOR_AXIS_DESC, 223, "[Mars-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Jupiter-R]", ConstantValue.JUPITER_RADIUS_MEAN_DESC, 224, "[Jupiter-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Jupiter-M]", ConstantValue.JUPITER_MASS_DESC, 225, "[Jupiter-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Jupiter-D]", ConstantValue.JUPITER_SEMI_MAJOR_AXIS_DESC, 226, "[Jupiter-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Saturn-R]", ConstantValue.SATURN_RADIUS_MEAN_DESC, 227, "[Saturn-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Saturn-M]", ConstantValue.SATURN_MASS_DESC, 228, "[Saturn-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Saturn-D]", ConstantValue.SATURN_SEMI_MAJOR_AXIS_DESC, 229, "[Saturn-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Uranus-R]", ConstantValue.URANUS_RADIUS_MEAN_DESC, 230, "[Uranus-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Uranus-M]", ConstantValue.URANUS_MASS_DESC, 231, "[Uranus-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Uranus-D]", ConstantValue.URANUS_SEMI_MAJOR_AXIS_DESC, 232, "[Uranus-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Neptune-R]", ConstantValue.NEPTUNE_RADIUS_MEAN_DESC, 233, "[Neptune-R]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Neptune-M]", ConstantValue.NEPTUNE_MASS_DESC, 234, "[Neptune-M]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Neptune-D]", ConstantValue.NEPTUNE_SEMI_MAJOR_AXIS_DESC, 235, "[Neptune-D]", "4.0", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[true]", ConstantValue.TRUE_DESC, 301, "[true]", "4.1", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[false]", ConstantValue.FALSE_DESC, 302, "[false]", "4.1", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[NaN]", ConstantValue.NAN_DESC, 999, "[NaN]", "4.1", 9, keyWordsList);
            ExpressionUtils.addKeyWord("[Uni]", RandomVariable.UNIFORM_DESC, 1, "[Uni]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int]", RandomVariable.INT_DESC, 2, "[Int]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int1]", RandomVariable.INT1_DESC, 3, "[Int1]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int2]", RandomVariable.INT2_DESC, 4, "[Int2]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int3]", RandomVariable.INT3_DESC, 5, "[Int3]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int4]", RandomVariable.INT4_DESC, 6, "[Int4]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int5]", RandomVariable.INT5_DESC, 7, "[Int5]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int6]", RandomVariable.INT6_DESC, 8, "[Int6]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int7]", RandomVariable.INT7_DESC, 9, "[Int7]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int8]", RandomVariable.INT8_DESC, 10, "[Int8]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Int9]", RandomVariable.INT9_DESC, 11, "[Int9]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat]", RandomVariable.NAT0_DESC, 12, "[nat]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat1]", RandomVariable.NAT0_1_DESC, 13, "[nat1]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat2]", RandomVariable.NAT0_2_DESC, 14, "[nat2]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat3]", RandomVariable.NAT0_3_DESC, 15, "[nat3]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat4]", RandomVariable.NAT0_4_DESC, 16, "[nat4]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat5]", RandomVariable.NAT0_5_DESC, 17, "[nat5]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat6]", RandomVariable.NAT0_6_DESC, 18, "[nat6]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat7]", RandomVariable.NAT0_7_DESC, 19, "[nat7]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat8]", RandomVariable.NAT0_8_DESC, 20, "[nat8]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[nat9]", RandomVariable.NAT0_9_DESC, 21, "[nat9]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat]", RandomVariable.NAT1_DESC, 22, "[Nat]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat1]", RandomVariable.NAT1_1_DESC, 23, "[Nat1]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat2]", RandomVariable.NAT1_2_DESC, 24, "[Nat2]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat3]", RandomVariable.NAT1_3_DESC, 25, "[Nat3]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat4]", RandomVariable.NAT1_4_DESC, 26, "[Nat4]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat5]", RandomVariable.NAT1_5_DESC, 27, "[Nat5]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat6]", RandomVariable.NAT1_6_DESC, 28, "[Nat6]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat7]", RandomVariable.NAT1_7_DESC, 29, "[Nat7]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat8]", RandomVariable.NAT1_8_DESC, 30, "[Nat8]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nat9]", RandomVariable.NAT1_9_DESC, 31, "[Nat9]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("[Nor]", RandomVariable.NOR_DESC, 32, "[Nor]", "3.0", 10, keyWordsList);
            ExpressionUtils.addKeyWord("@~", BitwiseOperator.COMPL_DESC, 1, BitwiseOperator.COMPL_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@&", BitwiseOperator.AND_DESC, 2, BitwiseOperator.AND_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@^", BitwiseOperator.XOR_DESC, 3, BitwiseOperator.XOR_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@|", BitwiseOperator.OR_DESC, 4, BitwiseOperator.OR_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@<<", BitwiseOperator.LEFT_SHIFT_DESC, 5, BitwiseOperator.LEFT_SHIFT_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@>>", BitwiseOperator.RIGHT_SHIFT_DESC, 6, BitwiseOperator.RIGHT_SHIFT_SYN, "4.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@~&", BitwiseOperator.NAND_DESC, 7, BitwiseOperator.NAND_SYN, "6.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@~|", BitwiseOperator.NOR_DESC, 8, BitwiseOperator.NOR_SYN, "6.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("@~^", BitwiseOperator.XNOR_DESC, 9, BitwiseOperator.XNOR_SYN, "6.0", 11, keyWordsList);
            ExpressionUtils.addKeyWord("[%]", Unit.PERC_DESC, 1, "[%]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[%%]", Unit.PERM_DESC, 2, "[%%]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Y]", Unit.YOTTA_DESC, 101, "[Y]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[sept]", Unit.YOTTA_DESC, 101, "[sept]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Z]", Unit.ZETTA_DESC, 102, "[Z]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[sext]", Unit.ZETTA_DESC, 102, "[sext]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[E]", Unit.EXA_DESC, 103, "[E]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[quint]", Unit.EXA_DESC, 103, "[quint]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[P]", Unit.PETA_DESC, 104, "[P]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[quad]", Unit.PETA_DESC, 104, "[quad]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[T]", Unit.TERA_DESC, 105, "[T]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[tril]", Unit.TERA_DESC, 105, "[tril]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[G]", Unit.GIGA_DESC, 106, "[G]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[bil]", Unit.GIGA_DESC, 106, "[bil]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[M]", Unit.MEGA_DESC, 107, "[M]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mil]", Unit.MEGA_DESC, 107, "[mil]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[k]", Unit.KILO_DESC, 108, "[k]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[th]", Unit.KILO_DESC, 108, "[th]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[hecto]", Unit.HECTO_DESC, 109, "[hecto]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[hund]", Unit.HECTO_DESC, 109, "[hund]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[deca]", Unit.DECA_DESC, 110, "[deca]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ten]", Unit.DECA_DESC, 110, "[ten]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[deci]", Unit.DECI_DESC, 111, "[deci]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[centi]", Unit.CENTI_DESC, 112, "[centi]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[milli]", Unit.MILLI_DESC, 113, "[milli]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mic]", Unit.MICRO_DESC, 114, "[mic]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[n]", Unit.NANO_DESC, 115, "[n]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[p]", Unit.PICO_DESC, 116, "[p]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[f]", Unit.FEMTO_DESC, 117, "[f]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[a]", Unit.ATTO_DESC, 118, "[a]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[z]", Unit.ZEPTO_DESC, 119, "[z]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[y]", Unit.YOCTO_DESC, 120, "[y]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[m]", Unit.METRE_DESC, 201, "[m]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[km]", Unit.KILOMETRE_DESC, 202, "[km]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[cm]", Unit.CENTIMETRE_DESC, 203, "[cm]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mm]", Unit.MILLIMETRE_DESC, 204, "[mm]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[inch]", Unit.INCH_DESC, 205, "[inch]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[yd]", Unit.YARD_DESC, 206, "[yd]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ft]", Unit.FEET_DESC, 207, "[ft]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mile]", Unit.MILE_DESC, 208, "[mile]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[nmi]", Unit.NAUTICAL_MILE_DESC, 209, "[nmi]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[m2]", Unit.METRE2_DESC, 301, "[m2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[cm2]", Unit.CENTIMETRE2_DESC, 302, "[cm2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mm2]", Unit.MILLIMETRE2_DESC, 303, "[mm2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[are]", Unit.ARE_DESC, 304, "[are]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ha]", Unit.HECTARE_DESC, 305, "[ha]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[acre]", Unit.ACRE_DESC, 306, "[acre]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[km2]", Unit.KILOMETRE2_DESC, 307, "[km2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mm3]", Unit.MILLIMETRE3_DESC, 401, "[mm3]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[cm3]", Unit.CENTIMETRE3_DESC, 402, "[cm3]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[m3]", Unit.METRE3_DESC, 403, "[m3]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[km3]", Unit.KILOMETRE3_DESC, 404, "[km3]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ml]", Unit.MILLILITRE_DESC, 405, "[ml]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[l]", Unit.LITRE_DESC, 406, "[l]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[gall]", Unit.GALLON_DESC, 407, "[gall]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[pint]", Unit.PINT_DESC, 408, "[pint]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[s]", Unit.SECOND_DESC, 501, "[s]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ms]", Unit.MILLISECOND_DESC, 502, "[ms]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[min]", Unit.MINUTE_DESC, 503, "[min]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[h]", Unit.HOUR_DESC, 504, "[h]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[day]", Unit.DAY_DESC, 505, "[day]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[week]", Unit.WEEK_DESC, 506, "[week]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[yearj]", Unit.JULIAN_YEAR_DESC, 507, "[yearj]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[kg]", Unit.KILOGRAM_DESC, 508, "[kg]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[gr]", Unit.GRAM_DESC, 509, "[gr]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mg]", Unit.MILLIGRAM_DESC, 510, "[mg]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[dag]", Unit.DECAGRAM_DESC, 511, "[dag]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[t]", Unit.TONNE_DESC, 512, "[t]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[oz]", Unit.OUNCE_DESC, 513, "[oz]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[lb]", Unit.POUND_DESC, 514, "[lb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[b]", Unit.BIT_DESC, 601, "[b]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[kb]", Unit.KILOBIT_DESC, 602, "[kb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Mb]", Unit.MEGABIT_DESC, 603, "[Mb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Gb]", Unit.GIGABIT_DESC, 604, "[Gb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Tb]", Unit.TERABIT_DESC, 605, "[Tb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Pb]", Unit.PETABIT_DESC, 606, "[Pb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Eb]", Unit.EXABIT_DESC, 607, "[Eb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Zb]", Unit.ZETTABIT_DESC, 608, "[Zb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[Yb]", Unit.YOTTABIT_DESC, 609, "[Yb]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[B]", Unit.BYTE_DESC, 610, "[B]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[kB]", Unit.KILOBYTE_DESC, 611, "[kB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[MB]", Unit.MEGABYTE_DESC, 612, "[MB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[GB]", Unit.GIGABYTE_DESC, 613, "[GB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[TB]", Unit.TERABYTE_DESC, 614, "[TB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[PB]", Unit.PETABYTE_DESC, 615, "[PB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[EB]", Unit.EXABYTE_DESC, 616, "[EB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[ZB]", Unit.ZETTABYTE_DESC, 617, "[ZB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[YB]", Unit.YOTTABYTE_DESC, 618, "[YB]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[J]", Unit.JOULE_DESC, 701, "[J]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[eV]", Unit.ELECTRONO_VOLT_DESC, 702, "[eV]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[keV]", Unit.KILO_ELECTRONO_VOLT_DESC, 703, "[keV]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[MeV]", Unit.MEGA_ELECTRONO_VOLT_DESC, 704, "[MeV]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[GeV]", Unit.GIGA_ELECTRONO_VOLT_DESC, 705, "[GeV]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[TeV]", Unit.TERA_ELECTRONO_VOLT_DESC, 706, "[TeV]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[m/s]", Unit.METRE_PER_SECOND_DESC, 801, "[m/s]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[km/h]", Unit.KILOMETRE_PER_HOUR_DESC, 802, "[km/h]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mi/h]", Unit.MILE_PER_HOUR_DESC, 803, "[mi/h]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[knot]", Unit.KNOT_DESC, 804, "[knot]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[m/s2]", Unit.METRE_PER_SECOND2_DESC, 901, "[m/s2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[km/h2]", Unit.KILOMETRE_PER_HOUR2_DESC, 902, "[km/h2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[mi/h2]", Unit.MILE_PER_HOUR2_DESC, 903, "[mi/h2]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[rad]", Unit.RADIAN_ARC_DESC, 1001, "[rad]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[deg]", Unit.DEGREE_ARC_DESC, 1002, "[deg]", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("[']", Unit.MINUTE_ARC_DESC, 1003, "[']", "4.0", 12, keyWordsList);
            ExpressionUtils.addKeyWord("['']", Unit.SECOND_ARC_DESC, 1004, "['']", "4.0", 12, keyWordsList);
            if (UDFExpression) {
                ExpressionUtils.addUDFSpecificParserKeyWords(keyWordsList);
            }
        }
        ExpressionUtils.addKeyWord("(", ParserSymbol.LEFT_PARENTHESES_DESC, 1, "( ... )", "1.0", 20, keyWordsList);
        ExpressionUtils.addKeyWord(")", ParserSymbol.RIGHT_PARENTHESES_DESC, 2, "( ... )", "1.0", 20, keyWordsList);
        ExpressionUtils.addKeyWord(",", ParserSymbol.COMMA_DESC, 3, "(a1, ... ,an)", "1.0", 20, keyWordsList);
        ExpressionUtils.addKeyWord(";", ParserSymbol.SEMI_DESC, 3, "(a1; ... ;an)", "1.0", 20, keyWordsList);
        ExpressionUtils.addKeyWord(ParserSymbol.NUMBER_LITERAL_STR, ParserSymbol.NUMBER_LITERAL_DESC, 1, "-2, 0.2, -002.1, 2.3e10, -.212, 1_2, 2_1_3, b1.111, b2.1001, h.af1,...", "1.0", 0, keyWordsList);
        ExpressionUtils.addKeyWord(" ", ParserSymbol.BLANK_DESC, 4, " ", "4.2", 20, keyWordsList);
    }

    static List<FunctionParameter> getFunctionParameters(int pos, List<Token> tokensList) {
        ArrayList<FunctionParameter> functionParameters = new ArrayList<FunctionParameter>();
        int cPos = pos + 2;
        int tokenLevel = tokensList.get((int)(pos + 1)).tokenLevel;
        int pPos = cPos;
        boolean end = false;
        ArrayList<Token> paramTkones = new ArrayList<Token>();
        StringBuilder paramStrBuilder = new StringBuilder();
        do {
            Token t = tokensList.get(cPos);
            boolean comma = false;
            boolean paren = false;
            if (t.tokenLevel == tokenLevel && t.tokenTypeId == 20) {
                if (t.tokenId == 2) {
                    paren = true;
                } else if (t.tokenId == 3) {
                    comma = true;
                }
            }
            if (paren || comma) {
                if (cPos > pos + 2) {
                    functionParameters.add(new FunctionParameter(paramTkones, paramStrBuilder.toString(), pPos, cPos - 1));
                    paramTkones = new ArrayList();
                    paramStrBuilder = new StringBuilder();
                    pPos = cPos + 1;
                }
            } else {
                paramTkones.add(t);
                paramStrBuilder.append(t.tokenStr);
            }
            if (paren) {
                end = true;
                continue;
            }
            ++cPos;
        } while (!end);
        return functionParameters;
    }

    private static String cleanMinusMinus(String expressionString) {
        String expressionStringCleaned = expressionString;
        if (expressionStringCleaned.length() >= 2) {
            boolean toClean = false;
            int pos = 1;
            do {
                char currChar = expressionStringCleaned.charAt(pos);
                char prevChar = expressionStringCleaned.charAt(pos - 1);
                toClean = false;
                if (currChar == '-' && prevChar == '-') {
                    toClean = true;
                    if (pos - 2 >= 0 && expressionStringCleaned.charAt(pos - 2) == '<') {
                        toClean = false;
                    }
                    if (pos + 1 < expressionStringCleaned.length() && expressionStringCleaned.charAt(pos + 1) == '>') {
                        toClean = false;
                    }
                }
                if (!toClean) continue;
                String leftPart = expressionStringCleaned.substring(0, pos - 1);
                String rightPart = "";
                if (pos + 1 < expressionStringCleaned.length()) {
                    rightPart = expressionStringCleaned.substring(pos + 1);
                }
                expressionStringCleaned = leftPart;
                if (rightPart.length() > 0) {
                    expressionStringCleaned = leftPart.length() > 0 ? expressionStringCleaned + "+" + rightPart : rightPart;
                }
                pos = leftPart.length() + 1;
            } while (++pos < expressionStringCleaned.length());
        }
        return expressionStringCleaned;
    }

    static String cleanExpressionString(String expressionString, boolean attemptToFixExpStrEnabled) {
        StringBuilder expressionStringCleanedBuilder = new StringBuilder();
        if (expressionString == null) {
            return "";
        }
        int expLen = expressionString.length();
        if (expLen == 0) {
            return "";
        }
        char clag1 = 'a';
        int blankCnt = 0;
        int newExpLen = 0;
        for (int i = 0; i < expLen; ++i) {
            char c = expressionString.charAt(i);
            if (StringUtils.isBlankChar(c)) {
                ++blankCnt;
            } else if (blankCnt > 0) {
                if (newExpLen > 0 && StringUtils.isNotSpecialChar(clag1)) {
                    expressionStringCleanedBuilder.append(" ");
                }
                blankCnt = 0;
            }
            if (blankCnt != 0) continue;
            expressionStringCleanedBuilder.append(c);
            clag1 = c;
            ++newExpLen;
        }
        String expressionStringCleaned = expressionStringCleanedBuilder.toString();
        if (attemptToFixExpStrEnabled) {
            int len;
            if (expressionStringCleaned.contains("++")) {
                expressionStringCleaned = expressionStringCleaned.replace("++", "+");
            }
            if (expressionStringCleaned.contains("+-")) {
                expressionStringCleaned = expressionStringCleaned.replace("+-", "-");
            }
            if (expressionStringCleaned.contains("-+")) {
                expressionStringCleaned = expressionStringCleaned.replace("-+", "-");
            }
            if (expressionStringCleaned.contains("--")) {
                expressionStringCleaned = expressionStringCleaned.contains("-->") || expressionStringCleaned.contains("<--") ? ExpressionUtils.cleanMinusMinus(expressionStringCleaned) : expressionStringCleaned.replace("--", "+");
            }
            if ((len = expressionStringCleaned.length()) > 0 && expressionStringCleaned.charAt(0) == '+') {
                expressionStringCleaned = expressionStringCleaned.substring(1);
            }
            if ((len = expressionStringCleaned.length()) > 0 && (expressionStringCleaned.charAt(len - 1) == '-' || expressionStringCleaned.charAt(len - 1) == '+')) {
                expressionStringCleaned = expressionStringCleaned.substring(0, len - 1);
            }
        }
        return expressionStringCleaned;
    }

    static String createExpressionDescription(String description, String expressionString) {
        String expressionDescription = StringUtils.surroundSquareBrackets(expressionString) + ": ";
        if (description.trim().length() > 0) {
            expressionDescription = StringUtils.surroundSquareBrackets(description) + expressionDescription;
        }
        return expressionDescription;
    }

    static List<Token> getCopyOfInitialTokens(String expressionString, List<Token> initialTokens) {
        ArrayList<Token> tokensListCopy = new ArrayList<Token>();
        if (expressionString.length() == 0) {
            return tokensListCopy;
        }
        if (initialTokens.size() == 0) {
            return tokensListCopy;
        }
        for (int i = 0; i < initialTokens.size(); ++i) {
            Token token = initialTokens.get(i);
            if (token.tokenTypeId == -1) {
                if (StringUtils.regexMatch(token.tokenStr, "\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\]")) {
                    token.looksLike = UNITCONST;
                } else if (StringUtils.regexMatch(token.tokenStr, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
                    token.looksLike = ARGUMENT;
                    if (i < initialTokens.size() - 1) {
                        Token tokenNext = initialTokens.get(i + 1);
                        if (tokenNext.tokenTypeId == 20 && tokenNext.tokenId == 1) {
                            token.looksLike = FUNCTION;
                        }
                    }
                } else {
                    token.looksLike = ERROR;
                }
            }
            tokensListCopy.add(token.clone());
        }
        return tokensListCopy;
    }

    static String[] getMissingUserDefinedArguments(List<Token> tokens) {
        ArrayList<String> missingArguments = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals(ARGUMENT) || missingArguments.contains(t.tokenStr)) continue;
            missingArguments.add(t.tokenStr);
        }
        int n = missingArguments.size();
        String[] missArgs = new String[n];
        for (int i = 0; i < n; ++i) {
            missArgs[i] = (String)missingArguments.get(i);
        }
        return missArgs;
    }

    static String[] getMissingUserDefinedUnits(List<Token> tokens) {
        ArrayList<String> missingUnits = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals(UNITCONST) || missingUnits.contains(t.tokenStr)) continue;
            missingUnits.add(t.tokenStr);
        }
        int n = missingUnits.size();
        String[] missUnits = new String[n];
        for (int i = 0; i < n; ++i) {
            missUnits[i] = (String)missingUnits.get(i);
        }
        return missUnits;
    }

    static String[] getMissingUserDefinedFunctions(List<Token> tokens) {
        ArrayList<String> missingFunctions = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals(FUNCTION) || missingFunctions.contains(t.tokenStr)) continue;
            missingFunctions.add(t.tokenStr);
        }
        int n = missingFunctions.size();
        String[] missFun = new String[n];
        for (int i = 0; i < n; ++i) {
            missFun[i] = (String)missingFunctions.get(i);
        }
        return missFun;
    }

    static void showKeyWords(List<KeyWord> keyWordsList) {
        int keyWordsNumber = keyWordsList.size();
        String maxStr = "KEY_WORD";
        mXparser.consolePrintln("Keywords:");
        mXparser.consolePrintln(" -------------------------------------------");
        mXparser.consolePrintln("|      IDX | KEY_WORD |       ID |  TYPE_ID |");
        mXparser.consolePrintln(" -------------------------------------------");
        for (int keyWordIndex = 0; keyWordIndex < keyWordsNumber; ++keyWordIndex) {
            KeyWord keyWord = keyWordsList.get(keyWordIndex);
            String idxStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(keyWordIndex));
            String wordStr = StringUtils.getLeftSpaces(maxStr, keyWord.wordString);
            String idStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(keyWord.wordId));
            String typeIdStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(keyWord.wordTypeId));
            mXparser.consolePrintln("| " + idxStr + " | " + wordStr + " | " + idStr + " | " + typeIdStr + " |");
        }
        mXparser.consolePrintln(" -------------------------------------------");
    }

    static String getHelp(String query, List<KeyWord> keyWordsList, boolean addHeader, boolean addCaption, String caption) {
        StringBuilder helpStr = new StringBuilder();
        if (addCaption) {
            helpStr.append(ExpressionUtils.selectCaption(query, caption));
        }
        if (addHeader) {
            if (addCaption) {
                helpStr.append(StringInvariant.NEW_LINE);
            }
            StringUtils.stringBuilderPartsAppend(helpStr, StringUtils.getLeftSpaces("12345", "#  "), StringUtils.getRightSpaces("01234567890123456789", StringModel.STRING_RESOURCES.KEYWORD), StringUtils.getRightSpaces("                        ", StringModel.STRING_RESOURCES.TYPE), StringUtils.getRightSpaces("0123456789012345678901234567890123456789012345", StringModel.STRING_RESOURCES.SYNTAX), StringUtils.getRightSpaces("012345", StringModel.STRING_RESOURCES.SINCE), StringModel.STRING_RESOURCES.DESCRIPTION, StringInvariant.NEW_LINE);
            StringUtils.stringBuilderPartsAppend(helpStr, StringUtils.getLeftSpaces("12345", "-  "), StringUtils.getRightSpaces("01234567890123456789", "--------"), StringUtils.getRightSpaces("                        ", "----"), StringUtils.getRightSpaces("0123456789012345678901234567890123456789012345", "------"), StringUtils.getRightSpaces("012345", "-----"), "-----------");
        }
        List<KeyWord> keyWordsResult = ExpressionUtils.getKeyWords(query, keyWordsList);
        int id = 0;
        for (KeyWord keyWord : keyWordsResult) {
            String type = Token.getTokenTypeDescription(keyWord.wordTypeId);
            String kw = keyWord.wordString;
            if (++id > 1 || addCaption || addHeader) {
                helpStr.append(StringInvariant.NEW_LINE);
            }
            StringUtils.stringBuilderPartsAppend(helpStr, StringUtils.getLeftSpaces("12345", id + ". "), StringUtils.getRightSpaces("01234567890123456789", kw), StringUtils.getRightSpaces("                        ", "<" + type + ">"), StringUtils.getRightSpaces("0123456789012345678901234567890123456789012345", keyWord.syntax), StringUtils.getRightSpaces("012345", keyWord.since), keyWord.description);
        }
        return helpStr.toString();
    }

    static String getHelp(String query, List<KeyWord> keyWordsList) {
        return ExpressionUtils.getHelp(query, keyWordsList, true, true, "");
    }

    static String getHelpAsCsv(List<KeyWord> keyWordsList, String quote, String delimiter, boolean addHeader, String query) {
        List<KeyWord> keyWordsResult = ExpressionUtils.getKeyWords(query, keyWordsList);
        StringResources stringResources = StringModel.getStringResources();
        StringBuilder result = new StringBuilder();
        if (addHeader) {
            StringUtils.stringBuilderPartsAppendDelimited(quote, delimiter, result, stringResources.KEYWORD, stringResources.TYPE, stringResources.SYNTAX, stringResources.SINCE, stringResources.DESCRIPTION);
        }
        int n = 0;
        for (KeyWord kw : keyWordsResult) {
            StringUtils.stringBuilderPartsAppendDelimitedRow(quote, delimiter, addHeader || ++n > 1, result, kw.wordString, Token.getTokenTypeDescription(kw.wordTypeId), kw.syntax, kw.since, kw.description);
        }
        return StringUtils.cleanNewLineAtTheEnd(result.toString());
    }

    private static void buildHtmlTableRows(List<KeyWord> keyWordsList, boolean addHeader, StringBuilder stringBuilder) {
        StringResources stringResources = StringModel.getStringResources();
        if (addHeader) {
            StringUtils.stringBuilderPartsAppendHtmlTableHead(stringBuilder, stringResources.KEYWORD, stringResources.TYPE, stringResources.SYNTAX, stringResources.SINCE, stringResources.DESCRIPTION);
        }
        int n = 0;
        for (KeyWord kw : keyWordsList) {
            ++n;
            StringUtils.stringBuilderPartsAppendHtmlTableRow(stringBuilder, kw.wordString, Token.getTokenTypeDescription(kw.wordTypeId), kw.syntax, kw.since, kw.description);
        }
    }

    private static void buildMarkdownTableRows(List<KeyWord> keyWordsList, boolean addHeader, StringBuilder stringBuilder) {
        StringResources stringResources = StringModel.getStringResources();
        StringUtils.stringBuilderPartsAppendMarkdownTableHead(addHeader, stringBuilder, stringResources.KEYWORD, stringResources.TYPE, stringResources.SYNTAX, stringResources.SINCE, stringResources.DESCRIPTION);
        int n = 0;
        for (KeyWord kw : keyWordsList) {
            ++n;
            StringUtils.stringBuilderPartsAppendMarkdownTableRow(stringBuilder, kw.wordString, Token.getTokenTypeDescription(kw.wordTypeId), kw.syntax, kw.since, kw.description);
        }
    }

    private static String makeJsonKeyValuePair(String key, String value) {
        return StringUtils.surroundQuote(key) + ": " + StringUtils.surroundQuote(value);
    }

    private static void buildJsonRows(List<KeyWord> keyWordsList, StringBuilder stringBuilder) {
        StringResources stringResources = StringModel.getStringResources();
        int n = 0;
        for (KeyWord kw : keyWordsList) {
            if (++n > 1) {
                stringBuilder.append(",");
            }
            StringUtils.stringBuilderPartsAppendJsonRow(stringBuilder, ExpressionUtils.makeJsonKeyValuePair(stringResources.KEYWORD, kw.wordString), ExpressionUtils.makeJsonKeyValuePair(stringResources.TYPE, Token.getTokenTypeDescription(kw.wordTypeId)), ExpressionUtils.makeJsonKeyValuePair(stringResources.SYNTAX, kw.syntax), ExpressionUtils.makeJsonKeyValuePair(stringResources.SINCE, kw.since), ExpressionUtils.makeJsonKeyValuePair(stringResources.DESCRIPTION, kw.description));
        }
    }

    private static String buildHelpCaption(String query) {
        StringResources stringResources = StringModel.getStringResources();
        if (query.length() > 0) {
            return stringResources.HELP_CONTENT_LIMITED_TO_QUERY + ": " + StringUtils.surroundApostrophe(query);
        }
        return stringResources.ALL_HELP_CONTENT;
    }

    private static String selectCaption(String query, String caption) {
        if (caption == null || caption.length() == 0) {
            return ExpressionUtils.buildHelpCaption(query);
        }
        return caption;
    }

    private static String makeCssClassDef(String cssClass) {
        return " class=" + StringUtils.surroundQuote(cssClass);
    }

    static String getHelpAsHtmlTable(List<KeyWord> keyWordsList, boolean addHeader, boolean addCaption, boolean addFigure, String query, String caption, String cssClass) {
        List<KeyWord> keyWordsResult = ExpressionUtils.getKeyWords(query, keyWordsList);
        StringBuilder result = new StringBuilder();
        String cssClassDef = "";
        String captionText = ExpressionUtils.selectCaption(query, caption);
        if (cssClass != null && cssClass.length() > 0) {
            cssClassDef = ExpressionUtils.makeCssClassDef(cssClass);
        }
        if (addFigure) {
            StringUtils.stringBuilderLinesAppend(result, "<figure" + cssClassDef + ">", "<table>");
        } else {
            StringUtils.stringBuilderLinesAppend(result, "<table" + cssClassDef + ">");
            if (addCaption) {
                StringUtils.stringBuilderLinesAppend(result, "<caption>" + captionText + "</caption>");
            }
        }
        StringUtils.stringBuilderLinesAppend(result, "<tbody>");
        ExpressionUtils.buildHtmlTableRows(keyWordsResult, addHeader, result);
        StringUtils.stringBuilderLinesAppend(result, "</tbody>", "</table>");
        if (addFigure) {
            if (addCaption) {
                StringUtils.stringBuilderLinesAppend(result, "<figcaption>" + captionText + "</figcaption>");
            }
            StringUtils.stringBuilderLinesAppend(result, "</figure>");
        }
        return StringUtils.cleanNewLineAtTheEnd(result.toString());
    }

    static String getHelpAsHtmlTable(List<KeyWord> keyWordsList, boolean addHeadline, String query) {
        return ExpressionUtils.getHelpAsHtmlTable(keyWordsList, addHeadline, true, false, query, "", "");
    }

    static String getHelpAsMarkdownTable(List<KeyWord> keyWordsList, String query) {
        return ExpressionUtils.getHelpAsMarkdownTable(keyWordsList, true, true, query, "");
    }

    static String getHelpAsMarkdownTable(List<KeyWord> keyWordsList, boolean addHeader, boolean addCaption, String query, String caption) {
        List<KeyWord> keyWordsResult = ExpressionUtils.getKeyWords(query, keyWordsList);
        StringBuilder result = new StringBuilder();
        if (addCaption) {
            StringUtils.stringBuilderLinesAppend(result, "### " + ExpressionUtils.selectCaption(query, caption));
        }
        ExpressionUtils.buildMarkdownTableRows(keyWordsResult, addHeader, result);
        return StringUtils.cleanNewLineAtTheEnd(result.toString()).replace("\\\\|", "\\\\ |");
    }

    static String getHelpAsJson(List<KeyWord> keyWordsList, boolean addCaption, String query, String caption) {
        StringResources stringResources = StringModel.getStringResources();
        List<KeyWord> keyWordsResult = ExpressionUtils.getKeyWords(query, keyWordsList);
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (addCaption) {
            StringUtils.stringBuilderPartsAppend(result, StringInvariant.NEW_LINE, "  ", "{ " + ExpressionUtils.makeJsonKeyValuePair(stringResources.CAPTION, ExpressionUtils.selectCaption(query, caption)) + " " + "}");
            if (keyWordsResult.size() > 0) {
                result.append(",");
            }
        }
        ExpressionUtils.buildJsonRows(keyWordsResult, result);
        StringUtils.stringBuilderPartsAppend(result, StringInvariant.NEW_LINE, "]");
        return result.toString();
    }

    private static String buildHelpSearchLine(KeyWord kw, boolean advancedSearch) {
        if (advancedSearch) {
            return KEY_ADVANCED_SEARCH_TAG + kw.wordString + " " + DESC_ADVANCED_SEARCH_TAG + kw.description + " " + SYN_ADVANCED_SEARCH_TAG + kw.syntax + " " + SINCE_ADVANCED_SEARCH_TAG + kw.since + " " + KEYID_ADVANCED_SEARCH_TAG + kw.wordId + " " + TYPEID_ADVANCED_SEARCH_TAG + kw.wordTypeId + " " + TYPE_ADVANCED_SEARCH_TAG + Token.getTokenTypeDescription(kw.wordTypeId);
        }
        return kw.wordString + " " + kw.description + " " + kw.syntax + " " + kw.since + " " + kw.wordId + " " + kw.wordTypeId + " " + Token.getTokenTypeDescription(kw.wordTypeId);
    }

    private static boolean containsAdvancedSearchTag(String query, String tag) {
        return query.startsWith(tag) && query.length() > tag.length();
    }

    private static boolean checkIfAdvancedSearch(String query) {
        if (query == null) {
            return false;
        }
        if (query.length() < 5) {
            return false;
        }
        if (!query.contains("=")) {
            return false;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, TYPE_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, KEY_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, DESC_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, SYN_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, SINCE_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        if (ExpressionUtils.containsAdvancedSearchTag(query, KEYID_ADVANCED_SEARCH_TAG)) {
            return true;
        }
        return ExpressionUtils.containsAdvancedSearchTag(query, TYPEID_ADVANCED_SEARCH_TAG);
    }

    static List<KeyWord> getKeyWords(String query, List<KeyWord> keyWordsList) {
        ArrayList<KeyWord> kwyWordsToReturn = new ArrayList<KeyWord>();
        Collections.sort(keyWordsList, new KwTypeComparator());
        String queryLower = "";
        if (query != null) {
            queryLower = query.toLowerCase();
        }
        boolean advancedSearch = ExpressionUtils.checkIfAdvancedSearch(query);
        for (KeyWord kw : keyWordsList) {
            String searchLine = ExpressionUtils.buildHelpSearchLine(kw, advancedSearch);
            if (queryLower.length() != 0 && !searchLine.toLowerCase().contains(queryLower)) continue;
            kwyWordsToReturn.add(kw);
        }
        return kwyWordsToReturn;
    }

    static void showParsing(int lPos, int rPos, List<Token> tokensList) {
        mXparser.consolePrint("---> ");
        for (int i = lPos; i <= rPos; ++i) {
            Token token = tokensList.get(i);
            if (token.tokenTypeId == 0) {
                mXparser.consolePrint(token.tokenValue + " ");
                continue;
            }
            mXparser.consolePrint(token.tokenStr + " ");
        }
        mXparser.consolePrint("... ");
    }

    static void showTokens(List<Token> tokensList) {
        String maxStr = "TokenTypeId";
        mXparser.consolePrintln(" --------------------");
        mXparser.consolePrintln("| " + StringModel.STRING_RESOURCES.EXPRESSION_TOKENS + ":" + " |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        mXparser.consolePrintln("|    TokenIdx |       Token |        KeyW |     TokenId | TokenTypeId |  TokenLevel |  TokenValue |   LooksLike |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        if (tokensList == null) {
            mXparser.consolePrintln(StringModel.STRING_RESOURCES.NULL_TOKENS_LIST);
            return;
        }
        int tokensNumber = tokensList.size();
        for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
            String tokenIndexStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(tokenIndex));
            String tokenStr = StringUtils.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).tokenStr);
            String keyWordStr = StringUtils.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).keyWord);
            String tokenIdStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenId));
            String tokenTypeIdStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenTypeId));
            String tokenLevelStr = StringUtils.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenLevel));
            String tokenValueStr = StringUtils.getLeftSpaces(maxStr, Double.toString(tokensList.get((int)tokenIndex).tokenValue));
            String tokenLooksLikeStr = StringUtils.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).looksLike);
            mXparser.consolePrintln("| " + tokenIndexStr + " | " + tokenStr + " | " + keyWordStr + " | " + tokenIdStr + " | " + tokenTypeIdStr + " | " + tokenLevelStr + " | " + tokenValueStr + " | " + tokenLooksLikeStr + " |");
        }
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
    }

    static String tokenToString(Token token) {
        if (token == null) {
            return "";
        }
        if (token.isNumber()) {
            double intTokenValue = Math.round(token.tokenValue);
            if (intTokenValue == token.tokenValue) {
                return Long.toString((long)intTokenValue);
            }
            return Double.toString(token.tokenValue);
        }
        return token.tokenStr;
    }

    static String tokensListToString(List<Token> tokensList) {
        if (tokensList == null) {
            return "";
        }
        if (tokensList.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < tokensList.size(); ++i) {
            Token t0 = null;
            Token t1 = tokensList.get(i);
            if (i > 0) {
                t0 = tokensList.get(i - 1);
            }
            if (!(t0 == null || t0.isLeftParenthesis() || t0.isParameterSeparator() || t0.isBinaryOperator() || t0.isUnaryLeftOperator() || t0.isUnaryRightOperator() || t0.isUnicodeRootOperator() || t0.isRightParenthesis() || !t1.isNumber())) {
                result.append(" ");
            }
            result.append(ExpressionUtils.tokenToString(t1));
        }
        return result.toString();
    }

    static void evaluateTokensLevels(List<Token> initialTokens) {
        int tokenLevel = 0;
        Stack<TokenStackElement> tokenStack = new Stack<TokenStackElement>();
        boolean precedingFunction = false;
        if (initialTokens.size() > 0) {
            for (int tokenIndex = 0; tokenIndex < initialTokens.size(); ++tokenIndex) {
                TokenStackElement stackEl;
                Token token = initialTokens.get(tokenIndex);
                if (token.tokenTypeId == 4 || token.tokenTypeId == 5 || token.tokenTypeId == 6 || token.tokenTypeId == 103 || token.tokenTypeId == 8 || token.tokenTypeId == 102 || token.tokenTypeId == 7) {
                    precedingFunction = true;
                } else if (token.tokenTypeId == 20 && token.tokenId == 1) {
                    stackEl = new TokenStackElement();
                    stackEl.tokenId = token.tokenId;
                    stackEl.tokenIndex = tokenIndex;
                    stackEl.tokenLevel = ++tokenLevel;
                    stackEl.tokenTypeId = token.tokenTypeId;
                    stackEl.precedingFunction = precedingFunction;
                    tokenStack.push(stackEl);
                    precedingFunction = false;
                } else {
                    precedingFunction = false;
                }
                token.tokenLevel = ++tokenLevel;
                if (token.tokenTypeId != 20 || token.tokenId != 2) continue;
                --tokenLevel;
                if (tokenStack.isEmpty()) continue;
                stackEl = (TokenStackElement)tokenStack.pop();
                if (!stackEl.precedingFunction) continue;
                --tokenLevel;
            }
        }
    }

    static int getNumeralSystemBaseFromBaseInd(String baseInd) {
        if (baseInd.equals("b")) {
            return 2;
        }
        if (baseInd.equals("o")) {
            return 8;
        }
        if (baseInd.equals("h")) {
            return 16;
        }
        if (baseInd.equals("b1")) {
            return 1;
        }
        if (baseInd.equals("b2")) {
            return 2;
        }
        if (baseInd.equals("b3")) {
            return 3;
        }
        if (baseInd.equals("b4")) {
            return 4;
        }
        if (baseInd.equals("b5")) {
            return 5;
        }
        if (baseInd.equals("b6")) {
            return 6;
        }
        if (baseInd.equals("b7")) {
            return 7;
        }
        if (baseInd.equals("b8")) {
            return 8;
        }
        if (baseInd.equals("b9")) {
            return 9;
        }
        if (baseInd.equals("b10")) {
            return 10;
        }
        if (baseInd.equals("b11")) {
            return 11;
        }
        if (baseInd.equals("b12")) {
            return 12;
        }
        if (baseInd.equals("b13")) {
            return 13;
        }
        if (baseInd.equals("b14")) {
            return 14;
        }
        if (baseInd.equals("b15")) {
            return 15;
        }
        if (baseInd.equals("b16")) {
            return 16;
        }
        if (baseInd.equals("b17")) {
            return 17;
        }
        if (baseInd.equals("b18")) {
            return 18;
        }
        if (baseInd.equals("b19")) {
            return 19;
        }
        if (baseInd.equals("b20")) {
            return 20;
        }
        if (baseInd.equals("b21")) {
            return 21;
        }
        if (baseInd.equals("b22")) {
            return 22;
        }
        if (baseInd.equals("b23")) {
            return 23;
        }
        if (baseInd.equals("b24")) {
            return 24;
        }
        if (baseInd.equals("b25")) {
            return 25;
        }
        if (baseInd.equals("b26")) {
            return 26;
        }
        if (baseInd.equals("b27")) {
            return 27;
        }
        if (baseInd.equals("b28")) {
            return 28;
        }
        if (baseInd.equals("b29")) {
            return 29;
        }
        if (baseInd.equals("b30")) {
            return 30;
        }
        if (baseInd.equals("b31")) {
            return 31;
        }
        if (baseInd.equals("b32")) {
            return 32;
        }
        if (baseInd.equals("b33")) {
            return 33;
        }
        if (baseInd.equals("b34")) {
            return 34;
        }
        if (baseInd.equals("b35")) {
            return 35;
        }
        if (baseInd.equals("b36")) {
            return 36;
        }
        return 0;
    }

    static int findNonNegativeMinimum(int a, int b) {
        int posMin = Integer.MAX_VALUE;
        if (a >= 0 && a < posMin) {
            posMin = a;
        }
        if (b >= 0 && b < posMin) {
            posMin = b;
        }
        if (posMin < Integer.MAX_VALUE) {
            return posMin;
        }
        return Integer.MIN_VALUE;
    }

    static int findNonNegativeMinimum(int a, int b, int c) {
        int posMin = Integer.MAX_VALUE;
        if (a >= 0 && a < posMin) {
            posMin = a;
        }
        if (b >= 0 && b < posMin) {
            posMin = b;
        }
        if (c >= 0 && c < posMin) {
            posMin = c;
        }
        if (posMin < Integer.MAX_VALUE) {
            return posMin;
        }
        return Integer.MIN_VALUE;
    }

    static List<Argument> cloneForThreadSafeArgumenstList(Expression relatedExpressionThatInitiatedClone, List<Argument> argumentsListToClone, CloneCache cloneCache) {
        ArrayList<Argument> argumentListClone = new ArrayList<Argument>();
        for (int i = 0; i < argumentsListToClone.size(); ++i) {
            Argument arg = argumentsListToClone.get(i);
            if (cloneCache.isCloneInProgress(arg)) {
                argumentListClone.add(null);
                cloneCache.cacheArgumentToAddCloneAtTheEnd(argumentListClone, arg, i);
                continue;
            }
            Argument argClone = arg.getArgumentType() == 3 ? ((RecursiveArgument)arg).cloneForThreadSafeInternal(relatedExpressionThatInitiatedClone, cloneCache) : arg.cloneForThreadSafeInternal(relatedExpressionThatInitiatedClone, cloneCache);
            argumentListClone.add(argClone);
        }
        return argumentListClone;
    }

    static List<Function> cloneForThreadSafeFunctionsList(Expression relatedExpressionThatInitiatedClone, List<Function> functionsListToClone, CloneCache cloneCache) {
        ArrayList<Function> functionListClone = new ArrayList<Function>();
        for (int i = 0; i < functionsListToClone.size(); ++i) {
            Function fun = functionsListToClone.get(i);
            if (cloneCache.isCloneInProgress(fun)) {
                functionListClone.add(null);
                cloneCache.cacheFunctionToAddCloneAtTheEnd(functionListClone, fun, i);
                continue;
            }
            functionListClone.add(fun.cloneForThreadSafeInternal(relatedExpressionThatInitiatedClone, cloneCache));
        }
        return functionListClone;
    }

    static List<Constant> cloneForThreadSafeConstantsList(Expression relatedExpressionThatInitiatedClone, List<Constant> constantsListToClone, CloneCache cloneCache) {
        ArrayList<Constant> constantListClone = new ArrayList<Constant>();
        for (int i = 0; i < constantsListToClone.size(); ++i) {
            Constant con = constantsListToClone.get(i);
            if (cloneCache.isCloneInProgress(con)) {
                constantListClone.add(null);
                cloneCache.cacheConstantToAddCloneAtTheEnd(constantListClone, con, i);
                continue;
            }
            constantListClone.add(con.cloneForThreadSafeInternal(relatedExpressionThatInitiatedClone, cloneCache));
        }
        return constantListClone;
    }
}

