/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.impl;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;

public final class FullRegistryWrapperLookup
implements HolderLookup.Provider {
    private final Map<ResourceKey<? extends Registry<?>>, HolderLookup<?>> map;

    public FullRegistryWrapperLookup() {
        this.map = Stream.concat(BuiltInRegistries.REGISTRY.entrySet().stream().map(e -> new ObjectObjectImmutablePair((Object)((ResourceKey)e.getKey()), (Object)((Registry)e.getValue()).asLookup())), Stream.of(new ObjectObjectImmutablePair((Object)BuiltInRegistries.REGISTRY.key(), (Object)BuiltInRegistries.REGISTRY.asLookup()))).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    public FullRegistryWrapperLookup(CommandBuildContext registryAccess) {
        this.map = Stream.concat(BuiltInRegistries.REGISTRY.entrySet().stream().flatMap(e -> Stream.of(new ObjectObjectImmutablePair((Object)((ResourceKey)e.getKey()), (Object)((Registry)e.getValue()).asLookup()), new ObjectObjectImmutablePair((Object)((ResourceKey)e.getKey()), (Object)registryAccess.lookupOrThrow((ResourceKey)e.getKey())))), Stream.of(new ObjectObjectImmutablePair((Object)BuiltInRegistries.REGISTRY.key(), (Object)BuiltInRegistries.REGISTRY.asLookup()))).collect(Collectors.toMap(Pair::left, Pair::right, (i1, i2) -> i2));
    }

    public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
        return this.map.keySet().stream();
    }

    public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> key) {
        return Optional.ofNullable(this.map.getOrDefault(key, null)).map(w -> new SimpleRegistryWrapperImpl(w, key)).map(w -> w);
    }

    public CommandBuildContext toCommandRegAccessAccess() {
        return new CommandBuildContext(){

            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return FullRegistryWrapperLookup.this.listRegistries();
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.lookup(registryRef);
            }
        };
    }
}

