/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.EncapsulatedException;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorRule
extends GameRules.Value<EntitySelectorRule>
implements GameruleAccessor<EntitySelector> {
    private EntitySelector value;
    private String str;
    private IGameruleValidator<EntitySelector> validator;
    private IGameruleAdapter<EntitySelector> adapter;

    public EntitySelectorRule(GameRules.Type<EntitySelectorRule> type, String initialValue, IGameruleValidator<EntitySelector> validator, IGameruleAdapter<EntitySelector> adapter) {
        super(type);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.str = initialValue;
        this.value = EntitySelectorRule.parseStr(initialValue);
        this.validator = validator;
        this.adapter = adapter;
    }

    public EntitySelectorRule(GameRules.Type<EntitySelectorRule> type, String initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public EntitySelector get() {
        return this.value;
    }

    public boolean validate(String input) {
        input = input.trim();
        try {
            EntitySelector e = EntitySelectorRule.parseStr(input);
            if (this.validator.validate(e)) {
                this.value = EntitySelectorRule.parseStr(input);
                this.str = input;
                return true;
            }
            Optional<EntitySelector> o = this.adapter.adapt(e);
            if (o.isPresent() && this.validator.validate(o.get())) {
                this.value = o.get();
                this.str = input;
                return true;
            }
            return false;
        }
        catch (EncapsulatedException e) {
            return false;
        }
    }

    private static EntitySelector parseStr(String s) throws EncapsulatedException {
        try {
            return new EntitySelectorParser(new StringReader(s)).parse();
        }
        catch (CommandSyntaxException e) {
            throw new EncapsulatedException((Exception)((Object)e));
        }
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        String s = (String)context.getArgument(name, String.class);
        EntitySelector e = (EntitySelector)context.getArgument(name, EntitySelector.class);
        if (this.validator.validate(e)) {
            this.value = e;
            this.str = s;
            return;
        }
        throw new IllegalArgumentException("Unsupported value for input " + s);
    }

    protected void deserialize(String value) {
        try {
            Optional<EntitySelector> o;
            EntitySelector e = EntitySelectorRule.parseStr(value);
            boolean b = this.validator.validate(e);
            if (!b && (o = this.adapter.adapt(e)).isPresent()) {
                e = o.get();
                b = this.validator.validate(e);
            }
            if (b) {
                this.str = value;
                this.value = e;
            }
        }
        catch (EncapsulatedException e) {
            UnruledApi.LOGGER.warn("Failed to parse entity selector from '{}'", (Object)value);
            UnruledApi.LOGGER.warn((Object)e);
        }
    }

    public String serialize() {
        return this.str;
    }

    public int getCommandResult() {
        return this.str.length();
    }

    protected EntitySelectorRule getThis() {
        return this;
    }

    public EntitySelectorRule copy() {
        return new EntitySelectorRule((GameRules.Type<EntitySelectorRule>)this.type, this.str, this.validator, this.adapter);
    }

    public void setValue(EntitySelectorRule rule, @Nullable MinecraftServer server) {
        EntitySelector e = rule.get();
        if (this.validator.validate(e)) {
            this.value = e;
            this.str = rule.serialize();
            return;
        }
        Optional<EntitySelector> o = this.adapter.adapt(e);
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return;
        }
        this.str = rule.serialize();
        this.value = o.get();
    }

    @Override
    public IGameruleValidator<EntitySelector> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<EntitySelector> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<EntitySelector> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<EntitySelector> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<EntitySelectorRule, EntitySelector> {
        private final String initialStr;

        public Builder(String initialValue) {
            super(EntityArgument::entities, Builder::acceptor, EntitySelectorRule.parseStr(initialValue));
            this.initialStr = initialValue;
        }

        @Override
        @NotNull
        protected EntitySelectorRule ruleBuilder(GameRules.Type<EntitySelectorRule> type) {
            return new EntitySelectorRule(type, this.initialStr, this.validator, this.adapter);
        }

        static void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<EntitySelectorRule> key, GameRules.Type<EntitySelectorRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitEntitySelector(key, type);
        }
    }
}

