/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumRule<T extends Enum<T>>
extends GameRules.Value<EnumRule<T>>
implements GameruleAccessor<T> {
    private final Class<T> tClass;
    private T value;
    private IGameruleValidator<T> validator;
    private IGameruleAdapter<T> adapter;

    private static <U extends Enum<U>> void testValidator(Class<U> c, IGameruleValidator<U> v) {
        int i = 0;
        for (Enum u : (Enum[])c.getEnumConstants()) {
            if (!v.validate(u)) continue;
            ++i;
        }
        if (i == 0) {
            throw new UnsupportedOperationException("Validator needs to validate at least one enum entry");
        }
    }

    public EnumRule(GameRules.Type<EnumRule<T>> type, Class<T> targetClass, T initialValue, IGameruleValidator<T> validator, IGameruleAdapter<T> adapter) {
        super(type);
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(initialValue);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        EnumRule.testValidator(targetClass, validator);
        this.tClass = targetClass;
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public EnumRule(GameRules.Type<EnumRule<T>> type, Class<T> targetClass, T initialValue) {
        this((GameRules.Type<EnumRule<Enum>>)type, (Class<Enum>)targetClass, (Enum)initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public Optional<T> parse(String input) {
        Objects.requireNonNull(input);
        try {
            return Optional.of(Enum.valueOf(this.tClass, input));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public boolean validate(String input) {
        return this.setFromStr(input);
    }

    private boolean setFromStr(String s) {
        Optional<Object> o = this.parse(s);
        if (o.isEmpty()) {
            return false;
        }
        if (this.validator.validate((Enum)o.get())) {
            this.set((Enum)o.get());
            return true;
        }
        if ((o = this.adapter.adapt((Enum)o.get())).isPresent() && this.validator.validate((Enum)o.get())) {
            this.set((Enum)o.get());
            return true;
        }
        return false;
    }

    public T get() {
        return this.value;
    }

    private void set(T t) {
        this.value = t;
    }

    public void set(T value, MinecraftServer server) {
        this.bump(value, server);
    }

    private void bump(T value, MinecraftServer server) {
        if (value == null) {
            return;
        }
        boolean b = false;
        if (this.validator.validate(value)) {
            b = true;
        } else {
            Optional<T> o = this.adapter.adapt(value);
            if (o.isPresent() && this.validator.validate((Enum)o.get())) {
                value = (Enum)o.get();
                b = true;
            }
        }
        if (b) {
            this.set(value);
            this.onChanged(server);
        }
    }

    public T[] values() {
        List<Enum> l = Arrays.stream((Enum[])this.tClass.getEnumConstants()).filter(this.validator::validate).toList();
        Enum[] a = l.toArray((Enum[])this.tClass.getEnumConstants());
        int i = 0;
        for (Enum t : a) {
            if (t == null) break;
            ++i;
        }
        if (i == 0) {
            a[0] = this.value;
            i = 1;
        }
        a = Arrays.copyOf(a, i);
        return a;
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        String s = StringArgumentType.getString(context, (String)name);
        this.setFromStr(s);
    }

    protected void deserialize(String value) {
        if (!this.setFromStr(value)) {
            UnruledApi.LOGGER.warn("Unable to parse {} frm '{}'", (Object)this.tClass.getName(), (Object)value);
        }
    }

    public String serialize() {
        return ((Enum)this.value).name();
    }

    public int getCommandResult() {
        return Collections.singletonList(this.tClass).indexOf(this.value) + 1;
    }

    protected EnumRule<T> getThis() {
        return this;
    }

    public EnumRule<T> copy() {
        return new EnumRule<T>(this.type, this.tClass, this.value, this.validator, this.adapter);
    }

    public void setValue(EnumRule<T> rule, @Nullable MinecraftServer server) {
        T v = rule.get();
        this.bump(v, server);
    }

    public static <U extends Enum<U>> Iterable<String> getEnumNames(Class<U> target) {
        return Arrays.stream((Enum[])target.getEnumConstants()).map(Enum::name).toList();
    }

    @Override
    public IGameruleValidator<T> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<T> validator) {
        Objects.requireNonNull(validator);
        EnumRule.testValidator(this.tClass, validator);
        this.validator = validator;
    }

    @Override
    public IGameruleAdapter<T> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<T> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder<T extends Enum<T>>
    extends RuleBuilder<EnumRule<T>, T> {
        private final Class<T> targetClass;

        public Builder(Class<T> targetClass, T initialValue) {
            super(() -> targetClass, Builder::acceptor, initialValue);
            this.targetClass = targetClass;
        }

        @Override
        @NotNull
        protected EnumRule<T> ruleBuilder(GameRules.Type<EnumRule<T>> type) {
            return new EnumRule<Enum>(type, this.targetClass, (Enum)this.initialValue, this.validator, this.adapter);
        }

        static <U extends Enum<U>> void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<EnumRule<U>> key, GameRules.Type<EnumRule<U>> type) {
            ((IGameRulesVisitor)consumer).unruled_visitEnum(key, type);
        }
    }
}

