/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.unruled_api.rules;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import java.util.Optional;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.rules.RuleBuilder;
import mc.recraftors.unruled_api.utils.GameruleAccessor;
import mc.recraftors.unruled_api.utils.IGameRulesVisitor;
import mc.recraftors.unruled_api.utils.IGameruleAdapter;
import mc.recraftors.unruled_api.utils.IGameruleValidator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatRule
extends GameRules.Value<FloatRule>
implements GameruleAccessor<Float> {
    private float value;
    private IGameruleValidator<Float> validator;
    private IGameruleAdapter<Float> adapter;

    public FloatRule(GameRules.Type<FloatRule> type, float initialValue, IGameruleValidator<Float> validator, IGameruleAdapter<Float> adapter) {
        super(type);
        Objects.requireNonNull(validator);
        Objects.requireNonNull(adapter);
        this.value = initialValue;
        this.validator = validator;
        this.adapter = adapter;
    }

    public FloatRule(GameRules.Type<FloatRule> type, float initialValue) {
        this(type, initialValue, IGameruleValidator::alwaysTrue, Optional::of);
    }

    public float get() {
        return this.value;
    }

    public void set(float value, MinecraftServer server) {
        this.bump(value, server);
    }

    private void bump(float value, MinecraftServer server) {
        boolean b = false;
        if (this.validator.validate(Float.valueOf(value))) {
            b = true;
        } else {
            Optional<Float> o = this.adapter.adapt(Float.valueOf(value));
            if (o.isPresent() && this.validator.validate(o.get())) {
                value = o.get().floatValue();
                b = true;
            }
        }
        if (b) {
            this.value = value;
            this.onChanged(server);
        }
    }

    public boolean validate(String input) {
        try {
            float f = Float.parseFloat(input);
            if (this.validator.validate(Float.valueOf(f))) {
                this.value = f;
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static float parseFloat(String input) {
        if (!input.isEmpty()) {
            try {
                return Float.parseFloat(input);
            }
            catch (NumberFormatException e) {
                UnruledApi.LOGGER.warn("Failed to parse float from '{}'", (Object)input);
            }
        }
        return 0.0f;
    }

    private void set(float f) {
        if (this.validator.validate(Float.valueOf(f))) {
            this.value = f;
            return;
        }
        Optional<Float> o = this.adapter.adapt(Float.valueOf(f));
        if (o.isEmpty() || !this.validator.validate(o.get())) {
            return;
        }
        this.value = o.get().floatValue();
    }

    protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name) {
        float f = FloatArgumentType.getFloat(context, (String)name);
        this.set(f);
    }

    protected void deserialize(String value) {
        float f = FloatRule.parseFloat(value);
        this.set(f);
    }

    public String serialize() {
        return Float.toString(this.value);
    }

    public int getCommandResult() {
        return (int)this.value;
    }

    protected FloatRule getThis() {
        return this;
    }

    public FloatRule copy() {
        return new FloatRule((GameRules.Type<FloatRule>)this.type, this.value, this.validator, this.adapter);
    }

    public void setValue(FloatRule rule, @Nullable MinecraftServer server) {
        this.bump(rule.get(), server);
    }

    @Override
    public IGameruleValidator<Float> unruled_getValidator() {
        return this.validator;
    }

    @Override
    public void unruled_setValidator(IGameruleValidator<Float> validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public IGameruleAdapter<Float> unruled_getAdapter() {
        return this.adapter;
    }

    @Override
    public void unruled_setAdapter(IGameruleAdapter<Float> adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public static class Builder
    extends RuleBuilder<FloatRule, Float> {
        public Builder(float initialValue) {
            super(FloatArgumentType::floatArg, Builder::acceptor, Float.valueOf(initialValue));
        }

        @Override
        @NotNull
        protected FloatRule ruleBuilder(GameRules.Type<FloatRule> type) {
            return new FloatRule(type, ((Float)this.initialValue).floatValue(), this.validator, this.adapter);
        }

        static void acceptor(GameRules.GameRuleTypeVisitor consumer, GameRules.Key<FloatRule> key, GameRules.Type<FloatRule> type) {
            ((IGameRulesVisitor)consumer).unruled_visitFloat(key, type);
        }
    }
}

