package mc.recraftors.unruled_api;

import net.minecraft.world.level.GameRules;

/**
 * Custom gamerule category builder entrypoint
 */
@FunctionalInterface
public interface CategoryProvider {
    /**
     * Returns the name of the added category
     * @return the name of the added category
     */
    String ruleName();

    /**
     * Receives the added category.
     * Defaults to nothing, as value may be as well be fetched by name
     * from the categories class.
     */
    default void categoryReceiver(GameRules.Category category) {}
}
