package mc.recraftors.unruled_api.impl;

import mc.recraftors.unruled_api.utils.SimpleRegistryWrapperImpl;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.registry.*;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FullRegistryWrapperLookup implements HolderLookup.Provider {
    private final Map<ResourceKey<? extends Registry<?>>, HolderLookup<?>> map;
    private final FeatureFlagSet featureSet;

    public FullRegistryWrapperLookup(FeatureFlagSet featureSet, CommandBuildContext registryAccess) {
        this.featureSet = featureSet;
        map = Stream.concat(
                BuiltInRegistries.REGISTRY.entrySet().stream()
                        .flatMap(e -> Stream.of(
                                new ImmutablePair<>(e.getKey(), e.getValue()),
                                new ImmutablePair<>(e.getKey(), registryAccess.lookupOrThrow(e.getKey()))
                        )),
                Stream.of(new ImmutablePair<>(BuiltInRegistries.REGISTRY.key(), BuiltInRegistries.REGISTRY))
        ).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (i1, i2) -> i2));
    }

    @Override
    public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
        return map.keySet().stream();
    }

    @Override
    public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> key) {
        //noinspection unchecked
        return Optional.ofNullable(map.getOrDefault(key, null))
                .map(w -> new SimpleRegistryWrapperImpl<>((HolderLookup<? super T>) w, key))
                .map(w -> (HolderLookup.RegistryLookup<T>) w);
    }

    public CommandBuildContext toCommandRegAccessAccess() {
        return new CommandBuildContext() {
            @Override
            public FeatureFlagSet enabledFeatures() {
                return FullRegistryWrapperLookup.this.featureSet;
            }

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return FullRegistryWrapperLookup.this.listRegistryKeys();
            }

            @Override
            public <T> Optional<? extends HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return FullRegistryWrapperLookup.this.lookup(registryRef);
            }
        };
    }
}
