package mc.recraftors.unruled_api.mixin;

import mc.recraftors.unruled_api.utils.Utils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(Commands.class)
public abstract class CommandManagerMixin {
    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/command/AdvancementCommand;register(Lcom/mojang/brigadier/CommandDispatcher;)V"))
    private void shareCommandRegistryAccess(
            Commands.CommandSelection environment, CommandBuildContext commandRegistryAccess, CallbackInfo ci
    ) {
        Utils.registryAccessThreadLocal.set(commandRegistryAccess);
    }
}
