package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.DSL;
import mc.recraftors.unruled_api.UnruledApi;
import net.minecraft.util.datafix.DataFixTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Arrays;

@SuppressWarnings("SameParameterValue")
@Mixin(DataFixTypes.class)
public abstract class DataFixTypesMixin {
    @Invoker("<init>")
    private static DataFixTypes constructorInvoker(String name, int ord, DSL.TypeReference ref) {
        return null;
    }

    @WrapOperation(
            method = "<clinit>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/datafixer/DataFixTypes;method_36589()[Lnet/minecraft/datafixer/DataFixTypes;"
            )
    )
    private static DataFixTypes[] unruled_customDataFixerInit(
            Operation<DataFixTypes[]> original
    ) {
        DataFixTypes[] base = original.call();
        DataFixTypes[] copy = Arrays.copyOf(base, base.length+1);
        DataFixTypes gamerulesDataFixTypes = constructorInvoker("GAMERULES", base.length, UnruledApi.GAMERULES_TYPE);
        copy[base.length] =gamerulesDataFixTypes;
        return copy;
    }
}
