package mc.recraftors.unruled_api.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mc.recraftors.unruled_api.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.server.Main;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Environment(EnvType.SERVER)
@Mixin(Main.class)
public abstract class DedicatedMainMixin {
    @WrapOperation(method = "*", at = @At(value = "NEW", target = "net/minecraft/world/level/LevelInfo"), require = 0)
    private static LevelSettings unruled_loadDefaultRules(
            String name, GameType gameMode, boolean hardcore, Difficulty difficulty, boolean allowCommands,
            GameRules gameRules, WorldDataConfiguration dataConfiguration, Operation<LevelSettings> original
    ) {
        ((GameRulesInvoker)gameRules).invokeLoad(Utils.loadDynamicFromJsonFile("config/default_gamerules.json"));
        return original.call(name, gameMode, hardcore, difficulty, allowCommands, gameRules, dataConfiguration);
    }
}
